<?php 
	/*	
	*	Goodlayers Core Plugin Filter
	*	---------------------------------------------------------------------
	*	This file contains the script to includes necessary function
	* 	for compatibility with goodlayers core plugin
	*	---------------------------------------------------------------------
	*/

	add_filter('gdlr_core_use_font_icons', 'seocrawler_gdlr_core_use_font_icons');
	if( !function_exists('seocrawler_gdlr_core_use_font_icons') ){
		function seocrawler_gdlr_core_use_font_icons( $icons ){
			return seocrawler_get_option('plugin', 'font-icon', $icons);
		}
	} 
	
	// add body class for page builder
	add_filter('gdlr_core_page_builder_body_class', 'seocrawler_page_builder_body_class');
	if( !function_exists('seocrawler_page_builder_body_class') ){
		function seocrawler_page_builder_body_class( $classes ) {
			return $classes . ' seocrawler-body';
		}
	}
	add_filter('gdlr_core_sidebar_class', 'seocrawler_gdlr_core_sidebar_class');
	if( !function_exists('seocrawler_gdlr_core_sidebar_class') ){
		function seocrawler_gdlr_core_sidebar_class( $classes ) {
			return $classes . ' seocrawler-sidebar-area';
		}
	}

	// Set the neccessary function to be used in the theme
	add_action('after_setup_theme', 'seocrawler_goodlayers_core_setup');
	if( !function_exists( 'seocrawler_goodlayers_core_setup' ) ){
		function seocrawler_goodlayers_core_setup(){

			// to set the goodlayers core plugin pagination
			add_filter('gdlr_core_pagination_style', 'seocrawler_gdlr_core_pagination_style');
			add_filter('gdlr_core_pagination_align', 'seocrawler_gdlr_core_pagination_align');

			// set the default social share option
			add_filter('gdlr_core_social_share_list', 'seocrawler_gdlr_core_social_share_list');

			// widget title navigation
			add_filter('gdlr_core_widget_title_nav', 'seocrawler_gdlr_core_widget_title_nav');

			// single portfolio
			add_filter('gdlr_core_custom_post_slug', 'seocrawler_gdlr_core_custom_post_slug', 10, 2);

			add_filter('gdlr_core_portfolio_single_nav', 'seocrawler_gdlr_core_portfolio_single_nav');
			add_filter('gdlr_core_portfolio_single_nav_same_term', 'seocrawler_gdlr_core_portfolio_single_nav_same_term');
			add_filter('gdlr_core_portfolio_single_related', 'seocrawler_gdlr_core_portfolio_single_related');

			// srcset
			add_filter('gdlr_core_enable_srcset', 'seocrawler_gdlr_core_enable_srcset');

			// filter for portfolio icon hover
			add_filter('gdlr_core_portfolio_hover_icon_class', 'seocrawler_gdlr_core_portfolio_hover_icon_class');
			
			// youtube cookies
			add_filter('gdlr_core_privacy_settings', 'seocrawler_gdlr_core_privacy_settings');
		}
	}

	// youtube no cookies
	if( !function_exists('seocrawler_gdlr_core_privacy_settings') ){
		function seocrawler_gdlr_core_privacy_settings(){
			if( function_exists('gdlr_core_get_privacy_options') ){
				$privacy_options = gdlr_core_get_privacy_options(1) + gdlr_core_get_privacy_options(2);
				$privacy_settings = array();
				foreach( $privacy_options as $privacy_option_slug => $privacy_option ){
					$privacy_settings[$privacy_option_slug] = seocrawler_get_option('plugin', $privacy_option_slug, 
						(empty($privacy_option['default'])? '': $privacy_option['default']));
				}

				return $privacy_settings;
			}
			
			return array();
		}
	}

	// portfolio hover icon class
	if( !function_exists('seocrawler_gdlr_core_portfolio_hover_icon_class') ){
		function seocrawler_gdlr_core_portfolio_hover_icon_class( $type = '' ){
			if( $type == 'image' ){
			 	return seocrawler_get_option('general', 'portfolio-icon-hover-image', '');
			}else if( $type == 'video' ){
				return seocrawler_get_option('general', 'portfolio-icon-hover-video', '');
			}else if( $type == 'link' ){
				return seocrawler_get_option('general', 'portfolio-icon-hover-link', '');
			}
		}
	}

	// to enable srcset
	if( !function_exists('seocrawler_gdlr_core_enable_srcset') ){
		function seocrawler_gdlr_core_enable_srcset( $enable ){
			$enable_srcset = seocrawler_get_option('plugin', 'enable-srcset', 'disable');
			return ($enable_srcset == 'enable');
		}
	}
			
	// for goodlayers core pagination
	if( !function_exists('seocrawler_gdlr_core_pagination_style') ){
		function seocrawler_gdlr_core_pagination_style( $style ) {
			return seocrawler_get_option('general', 'pagination-style', $style);
		}
	}
	if( !function_exists('seocrawler_gdlr_core_pagination_align') ){
		function seocrawler_gdlr_core_pagination_align( $align ) {
			return seocrawler_get_option('general', 'pagination-align', $align);
		}
	}			

	// custom post type slug
	if( !function_exists('seocrawler_gdlr_core_custom_post_slug') ){
		function seocrawler_gdlr_core_custom_post_slug( $slug, $type = '' ) {
			if( empty($type) ){ $type = $slug; }

			if( $type == 'portfolio' ){
				$slug = seocrawler_get_option('general', 'portfolio-slug', $slug);
			}else if( $type == 'portfolio_category' ){
				$slug = seocrawler_get_option('general', 'portfolio-category-slug', $slug);
			}else if( $type == 'portfolio_tag' ){
				$slug = seocrawler_get_option('general', 'portfolio-tag-slug', $slug);
			}else if( $type == 'personnel' ){
				$slug = seocrawler_get_option('general', 'personnel-slug', $slug);
			}else if( $type == 'personnel_category' ){
				$slug = seocrawler_get_option('general', 'personnel-category-slug', $slug);
			}
			
			return $slug;
		}
	}

	// single portfolio
	if( !function_exists('seocrawler_gdlr_core_portfolio_single_nav') ){
		function seocrawler_gdlr_core_portfolio_single_nav( $check ) {
			return seocrawler_get_option('general', 'enable-single-portfolio-navigation', $check);
		}
	}
	if( !function_exists('seocrawler_gdlr_core_portfolio_single_nav_same_term') ){
		function seocrawler_gdlr_core_portfolio_single_nav_same_term( $check ) {
			return seocrawler_get_option('general', 'enable-single-portfolio-navigation-in-same-tag', $check);
		}
	}
	if( !function_exists('seocrawler_gdlr_core_portfolio_single_related') ){
		function seocrawler_gdlr_core_portfolio_single_related( $args ) {

			$enble_related_portfolio = seocrawler_get_option('general', 'enable-related-portfolio', 'enable');
			if( $enble_related_portfolio == 'enable' ){
				$args['portfolio-style'] = seocrawler_get_option('general', 'related-portfolio-style', 'grid');
				$args['enable-portfolio-tag'] = seocrawler_get_option('general', 'related-portfolio-enable-tag', '');
				$args['num-fetch'] = seocrawler_get_option('general', 'related-portfolio-num-fetch', 4);
				$args['column-size'] = seocrawler_get_option('general', 'related-portfolio-column-size', 15);
				$args['thumbnail-size'] = seocrawler_get_option('general', 'related-portfolio-thumbnail-size', 'medium');
				$args['hover'] = seocrawler_get_option('general', 'related-portfolio-thumbnail-hover', '');
				$args['excerpt-number'] = seocrawler_get_option('general', 'related-portfolio-num-excerpt', 20);
				$args['portfolio-title-font-size'] = seocrawler_get_option('general', 'related-portfolio-title-font-size', '');
				$args['portfolio-title-font-weight'] = seocrawler_get_option('general', 'related-portfolio-title-font-weight', '');

				return $args;
			}else{
				return array();
			}
		}
	}

	// set default social share option
	if( !function_exists('seocrawler_gdlr_core_social_share_list') ){
		function seocrawler_gdlr_core_social_share_list( $social ) {

			$social['facebook'] = seocrawler_get_option('general', 'blog-social-facebook', $social['facebook']);
			$social['linkedin'] = seocrawler_get_option('general', 'blog-social-linkedin', $social['linkedin']);
			$social['google-plus'] = seocrawler_get_option('general', 'blog-social-google-plus', $social['google-plus']);
			$social['pinterest'] = seocrawler_get_option('general', 'blog-social-pinterest', $social['pinterest']);
			$social['stumbleupon'] = seocrawler_get_option('general', 'blog-social-stumbleupon', $social['stumbleupon']);
			$social['twitter'] = seocrawler_get_option('general', 'blog-social-twitter', $social['twitter']);
			$social['email'] = seocrawler_get_option('general', 'blog-social-email', $social['email']);

			return $social;
		}
	}	

	// add filter to register custom fonts for font lists 
	add_filter('gdlr_core_custom_uploaded_font', 'seocrawler_register_custom_uploaded_font');
	if( !function_exists('seocrawler_register_custom_uploaded_font') ){
		function seocrawler_register_custom_uploaded_font( $custom_fonts ){

			$custom_font = seocrawler_get_option('typography', 'font-upload');
			if( !empty($custom_font) ){
				foreach($custom_font as $font_option){
					$font_option['name'] = str_replace('+', '', $font_option['name']);
					while( !empty($custom_fonts[$font_option['name']]) ){
						$font_option['name'] = $font_option['name'] . '+';
					}

					$custom_fonts[$font_option['name']] = array(
						'eot' => empty($font_option['eot'])? '': $font_option['eot'],
						'ttf' => empty($font_option['ttf'])? '': $font_option['ttf'],
						'woff' => empty($font_option['woff'])? '': $font_option['woff'],
						'font-weight' => empty($font_option['font-weight'])? 'normal': $font_option['font-weight'],
						'font-style' => empty($font_option['font-style'])? 'normal': $font_option['font-style']
					);
				}
			}			
			
			return $custom_fonts;
			
		} // seocrawler_register_custom_uploaded_font
	} // function_exists

	// format widget title
	if( !function_exists('seocrawler_gdlr_core_widget_title_nav') ){
		function seocrawler_gdlr_core_widget_title_nav( $title_nav ){
			return '</span><span class="gdlr-core-flexslider-nav gdlr-core-plain-style gdlr-core-size-widget">';
		}
	}
	
	// add page builder to post
	add_filter('gdlr_core_page_builder_post_type', 'seocrawler_gdlr_core_page_builder_post_type');
	if( !function_exists('seocrawler_gdlr_core_page_builder_post_type') ){
		function seocrawler_gdlr_core_page_builder_post_type( $post_types ){
			$post_types[] = 'post';
			return $post_types;
		}
	}

	// set lightbox type
	add_filter('gdlr_core_lightbox_type', 'seocrawler_gdlr_core_lightbox_type');
	if( !function_exists('seocrawler_gdlr_core_lightbox_type') ){
		function seocrawler_gdlr_core_lightbox_type(){
			$lightbox_type = seocrawler_get_option('plugin', 'lightbox', 'ilightbox');

			if( $lightbox_type == 'ilightbox' ){
				$ilightbox_skin = seocrawler_get_option('plugin', 'ilightbox-skin', 'dark');
				return $lightbox_type . '-' . $ilightbox_skin;
			}else{
				return $lightbox_type;
			}
		}
	}
	add_filter('body_class', 'seocrawler_lightbox_body_class');
	if( !function_exists('seocrawler_lightbox_body_class') ){
		function seocrawler_lightbox_body_class($class){
			$link_to_lightbox = seocrawler_get_option('plugin', 'link-to-lightbox', 'enable');
			if( $link_to_lightbox == 'enable' ){
				$class[] = 'gdlr-core-link-to-lightbox';
			}
			return $class;
		}
	}
	
	// add page builder pre defined template
	if( is_admin() && class_exists('gdlr_core_page_builder_template') ){
		add_filter('gdlr_core_page_builder_page_template_list', 'seocrawler_gdlr_core_page_builder_page_template_list');
		add_filter('gdlr_core_page_builder_get_page_template', 'seocrawler_gdlr_core_page_builder_get_page_template', 10, 2);
	}

	if( !function_exists('seocrawler_gdlr_core_page_builder_page_template_list') ){
		function seocrawler_gdlr_core_page_builder_page_template_list( $templates ){
			$templates['homepage'] = array(
				'title' => esc_html__('Homepage', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['homepage2'] = array(
				'title' => esc_html__('Homepage 2', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['homepage3'] = array(
				'title' => esc_html__('Homepage 3', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['homepage-marketing'] = array(
				'title' => esc_html__('Homepage - Marketing', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['homepage-seostrategy'] = array(
				'title' => esc_html__('Homepage - SEO Strategy', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['homepage-startup'] = array(
				'title' => esc_html__('Homepage - Start Up', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['code-optimization'] = array(
				'title' => esc_html__('Code Optimization', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['email-marketing'] = array(
				'title' => esc_html__('Email Marketing', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['seo-support'] = array(
				'title' => esc_html__('SEO Support', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['nap-syndication'] = array(
				'title' => esc_html__('Nap Syndication', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['target-strategy'] = array(
				'title' => esc_html__('Target Strategy', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['monitoring-ranking'] = array(
				'title' => esc_html__('Monitoring Ranking', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['search-engine-marketing'] = array(
				'title' => esc_html__('Search Engine Marketing', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['search-engine-optimization'] = array(
				'title' => esc_html__('Search Engine Optimization', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['about-our-team'] = array(
				'title' => esc_html__('About Our Team', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['about-us'] = array(
				'title' => esc_html__('About Us', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['about-us-marketing'] = array(
				'title' => esc_html__('About Us - Marketing', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['about-us-seo'] = array(
				'title' => esc_html__('About Us - SEO', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['about-us-startup'] = array(
				'title' => esc_html__('About Us - Start Up', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['service-startup'] = array(
				'title' => esc_html__('Service - Start Up', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['free-analysis'] = array(
				'title' => esc_html__('Free Analysis', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['free-quote'] = array(
				'title' => esc_html__('Free Quote', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['contact'] = array(
				'title' => esc_html__('Contact', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['contact2'] = array(
				'title' => esc_html__('Contact 2', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['contact3'] = array(
				'title' => esc_html__('Contact 3', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['allen-walker-optimization'] = array(
				'title' => esc_html__('Allen Walker Optimization', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['dell-audience-monitoring'] = array(
				'title' => esc_html__('Dell Audience Monitoring', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['hp-cloud-service-improvment'] = array(
				'title' => esc_html__('HP Cloud Service Improvement', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['traveltour-marketing-campaign'] = array(
				'title' => esc_html__('Travel Tour Marketing Campaign', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['real-estate-web-rank-improve'] = array(
				'title' => esc_html__('Real Estate Web Rank Improve', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['kleanity-social-engagement'] = array(
				'title' => esc_html__('Kleanity Social Engagement', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['website-seo-optimization'] = array(
				'title' => esc_html__('Website SEO Optimization', 'seocrawler'),
				'type' => 'wrapper',
			);
			$templates['conference-marketing'] = array(
				'title' => esc_html__('Conference Marketing', 'seocrawler'),
				'type' => 'wrapper',
			);
			return $templates;
		} // seocrawler_gdlr_core_page_builder_page_template_list
	} // function_exists

	if( !function_exists('seocrawler_gdlr_core_page_builder_get_page_template') ){
		function seocrawler_gdlr_core_page_builder_get_page_template( $value, $type ){

			if( !empty($value) ) return $value; 

			switch( $type ){
				case 'homepage': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"tablet-mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"67px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#282828","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"20"},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"9","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ff4800","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"0.8","background-filter":"none","background-blur-size":"","border-radius":{"top":"4px","right":"4px","bottom":"0px","left":"0px","settings":"unlink"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"25px","right":"0px","bottom":"23px","left":"0px","settings":"unlink"},"margin":{"top":"-76px","right":"0px","bottom":"0px","left":"30px","settings":"unlink"},"tablet-padding":"","tablet-margin":"","mobile-padding":"","mobile-margin":"","skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Free SEO Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"icon","left-icon":"icon_genius","left-image":"","title-left-icon":"icon_genius","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"21px","title-font-size":"21px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#ffffff","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin":{"top":"30px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4840","title":"Big Data Analysis","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5082","title":"Best Keyword Ranking","caption":"","content":"<p>Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4844","title":"Speed Optimization","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4841","title":"SEO Mobile Specialty","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4843","title":"Better Conversion","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4845","title":"Social Network Monitoring","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"hp-form","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"#efeeee","background-image":"4848","background-image-style":"no-repeat","background-image-position":"bottom-right","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"45px","right":"20px","bottom":"30px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"30px","settings":"unlink"},"skin":"Contact form white"},"items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4846","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"*We will get back to you within 3 days","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4849","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"55px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4850","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4791","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-i-cursor","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Be on the top & Get more traffic  to your website","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"35px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"30px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.","text-align":"left","font-size":"17px","padding-bottom":"25px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_cloud_alt","icon-hover":"","title":"Be on the top of Google","link-url":""},{"icon":"icon_clock_alt","icon-hover":"","title":"Save your time and let us handle it","link-url":""},{"icon":"icon_desktop","icon-hover":"","title":"Cros-devices ability","link-url":""},{"icon":"icon_star_alt","icon-hover":"","title":"Be rewarded by our services","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"","border-color":"","icon-size":"25px","content-size":"18px","list-bottom-margin":"24px","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"See Case Studies","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/portfolio-3-columns/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"16px","right":"24px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"4px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#ea4517","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"620px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"4851","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"5px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4851","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4791","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Services","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"10px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"30px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. ","text-align":"center","font-size":"17px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4852","thumbnail-size":"Service HP thumb","link-to":"page-url","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Code Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/code-optimization/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4858","thumbnail-size":"Service HP thumb","link-to":"page-url","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Seach Engine Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/search-engine-optimization/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4859","thumbnail-size":"Service HP thumb","link-to":"page-url","custom-image":"","video-url":"","page-id":"4763","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Seach Engine Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/search-engine-marketing/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4853","thumbnail-size":"Service HP thumb","link-to":"page-url","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Monitoring Ranking","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/monitoring-ranking","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4854","thumbnail-size":"Service HP thumb","link-to":"page-url","custom-image":"","video-url":"","page-id":"4781","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Target Strategy","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/target-strategy","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4855","thumbnail-size":"Service HP thumb","link-to":"page-url","custom-image":"","video-url":"","page-id":"4785","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Nap Syndication","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/nap-syndication/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4856","thumbnail-size":"Service HP thumb","link-to":"page-url","custom-image":"","video-url":"","page-id":"4787","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"SEO Support","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/seo-support/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4857","thumbnail-size":"Service HP thumb","link-to":"page-url","custom-image":"","video-url":"","page-id":"4789","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Email Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/email-marketing/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"15px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View More Services","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/our-services/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"16px","right":"24px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"4px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#ea4517","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"element","type":"divider"}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"20px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"805px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"What drives your website great results","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"82px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>","text-align":"center","font-size":"17px","padding-bottom":"60px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5073","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"24px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Page Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5068","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Internal Site Audit","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5070","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Content Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5074","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Technical SEO","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5075","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Brand Awareness","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5071","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Local Search Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5069","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Mobile Search Improving","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5072","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"28px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Competitors Monitoring","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4878","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"video-bg-height","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"#161616","background-image":"4584","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.38","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"250px","right":"0px","bottom":"250px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4865","thumbnail-size":"full","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=F0uq5gyqIf8","page-id":"4791","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"580px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"video-bg-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4867","background-image-style":"no-repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"107px","right":"70px","bottom":"70px","left":"77px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Watch The Presentation","caption":"Bookmarksgrove right at the coast","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"35px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>\n<p>of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her. powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of</p>\n","text-align":"left","font-size":"","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Story About Us","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/about-us/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"16px","right":"24px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"4px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#ea4517","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"640px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-screen-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"0px","left":"40px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We Know How To Code","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"35px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Dude.</p>","text-align":"left","font-size":"","padding-bottom":"30px"}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4869","title":"Digital Media Strategy","caption":"","content":"<p>Far far away, behind the word mountains.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"27px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5083","title":"Data Organization","caption":"","content":"<p>Separated they live in Bookmarksgrove</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"27px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5081","title":"Search Engine Friendly ","caption":"","content":"<p>Far far away, behind the word mountains.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"27px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-screen-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4873","background-image-style":"no-repeat","background-image-position":"bottom-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4735","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"2342","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"6302","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4749","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Port Carousel"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"32px","right":"0px","bottom":"5px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/free-analysis/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#33a8cf","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"/seocrawler/free-quote/","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"element","type":"divider"},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"770px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4882","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"58px","right":"0px","bottom":"57px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"What Clients Say?","title-left-icon":"","caption":"","tabs":[{"title":"John Doe","position":"Customer","content":"A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful.","image":"4875","image-img":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/testimonial-1.jpg","rating":""},{"title":"Jane Smith","position":"Web Marketing Analyst","content":"Donec id elit non mi porta gravida at eget metus. Maecenas faucibus mollis interdum. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum.","image":"4877","image-img":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/shutterstock_447504466.jpg","rating":""},{"title":"Paul Frank","position":"CEO Of Apple Corp.","content":"Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Donec sed odio dui. Vestibulum id ligula porta felis euismod semper.","image":"4876","image-img":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/shutterstock_342458267.jpg","rating":""}],"style":"center","column":"1","enable-quote":"disable","carousel":"enable","carousel-autoslide":"enable","carousel-navigation":"navigation","carousel-nav-style":"default","title-size":"26px","title-text-transform":"none","title-letter-spacing":"0px","caption-size":"16px","content-size":"20px","title-color":"","caption-color":"","quote-color":"","content-color":"","name-color":"","position-color":"","title-wrap-bottom-margin":"40px","content-bottom-padding":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f5f5f5","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"25px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"5079","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-visionx.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5078","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-smart.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5077","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-minepower.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5080","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-keyvision.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5076","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-soundfx-150x33.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"navigation","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4893","background-image-style":"repeat-x","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.14","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4890","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"76px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Service Plans","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"price-table","value":{"id":"","class":"","tabs":[{"icon":"icon_genius","image":"","image-img":"","title":"Basic Plan","caption":"Suitable For Small Business","price":"100","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"disable"},{"icon":"fa fa-star-o","image":"","image-img":"","title":"Advanced Plan","caption":"Suitable For Pro","price":"300","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"enable"},{"icon":"icon_lightbulb_alt","image":"","image-img":"","title":"Platinum Plan","caption":"Suitable For Enterprise","price":"500","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"disable"}],"price-prefix":"$","price-suffix":"/ MO","header-color":"#81ca41","header-gradient-color":"#a4ca41","icon-color":"","title-color":"","caption-color":"#f8f8f8","price-background-color":"","price-prefix-color":"","price-text-color":"","price-suffix-color":"","content-background-color":"","content-color":"","content-border-color":"","button-text-color":"","button-background-color":"#81ca41","button-background-gradient-color":"","a-header-color":"#33a3cf","a-header-gradient-color":"#337dcf","a-icon-color":"","a-title-color":"","a-caption-color":"#f8f8f8","a-price-background-color":"","a-price-prefix-color":"","a-price-text-color":"","a-price-suffix-color":"","a-content-background-color":"","a-content-color":"","a-content-border-color":"","a-button-text-color":"","a-button-background-color":"#33a4cf","a-button-background-gradient-color":"","padding-bottom":"30px"}}]}]}]';
				case 'homepage2': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#282828","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"45px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4935","title":"Big Data Analysis","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"8px","right":"28px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4938","title":"Best Keyword Ranking","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"8px","right":"25px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"25px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4936","title":"SEO Mobile Specialty","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"26px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4939","title":"Better Conversion","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"8px","right":"28px","bottom":"","left":"5px"},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4937","title":"Social Network Monitoring","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"8px","right":"25px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4940","title":"Speed Optimization","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Consonantia, there.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"17px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"8px","right":"25px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4941","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Contact form grey"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Free SEO Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"icon_genius","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"28px","title-font-size":"25px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#3155a7","title-color":"#3155a7","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin":{"top":"-4px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4846","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"*We will get back to you within 3 days","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"75px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Be on the top & Get more traffic  to your website","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"35px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language.","text-align":"left","font-size":"17px","padding-bottom":"25px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_cloud_alt","icon-hover":"","title":"Be on the top of Google","link-url":""},{"icon":"icon_clock_alt","icon-hover":"","title":"Save your time and let us handle it","link-url":""},{"icon":"icon_desktop","icon-hover":"","title":"Cros-devices ability","link-url":""},{"icon":"icon_star_alt","icon-hover":"","title":"Be rewarded by our services","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#3155a7","icon-background-color":"","content-color":"#3155a7","border-color":"","icon-size":"25px","content-size":"18px","list-bottom-margin":"24px","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"See Case Studies","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/demo2/portfolio-3-columns/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"16px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"border-radius":"4px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#111111","text-hover-color":"","background-color":"#3155a7","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"16px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"counter-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4942","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Purple Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"icon","top-icon":"fa fa-comments-o","top-text":"","prefix":"","start-number":"0","end-number":"2342","animation-time":"1000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"37px","top-text-size":"16px","number-size":"58px","bottom-text-size":"16px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"counter-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#19377d","background-image":"4942","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Purple Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"icon","top-icon":"icon_laptop","top-text":"","prefix":"","start-number":"0","end-number":"6302","animation-time":"1000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"37px","top-text-size":"16px","number-size":"58px","bottom-text-size":"16px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"counter-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4943","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Purple Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"icon","top-icon":"fa fa-star-o","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"1000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"37px","top-text-size":"16px","number-size":"58px","bottom-text-size":"16px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"counter-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#142d67","background-image":"4942","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Purple Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"icon","top-icon":"icon_easel","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"1000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"37px","top-text-size":"16px","number-size":"58px","bottom-text-size":"16px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"640px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-screen-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"50px","left":"40px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We Know How To Code","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"35px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Dude.</p>","text-align":"left","font-size":"","padding-bottom":"30px"}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_easel","icon-style":"normal","image":"4869","title":"Digital Media Strategy","caption":"","content":"Far far away, behind the word mountains.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"27px","title-size":"18px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"#3155a7","icon-background":"","background-color":"","media-margin":{"top":"13px","right":"27px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_datareport","icon-style":"normal","image":"4870","title":"Data Organization","caption":"","content":"Separated they live in Bookmarksgrove","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"27px","title-size":"18px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"#3155a7","icon-background":"","background-color":"","media-margin":{"top":"13px","right":"27px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_flowchart","icon-style":"normal","image":"4871","title":"Search Engine Friendly ","caption":"","content":"Far far away, behind the word mountains.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"27px","title-size":"18px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"14px","read-more-size":"14px","icon-color":"#3155a7","icon-background":"","background-color":"","media-margin":{"top":"13px","right":"27px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-screen-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4944","background-image-style":"cover","background-image-position":"bottom-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"video-bg-height","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"#161616","background-image":"4584","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.38","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"250px","right":"0px","bottom":"250px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4865","thumbnail-size":"full","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=F0uq5gyqIf8","page-id":"4791","custom-url":"","custom-link-target":"_self","overlay-icon-type":"none","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"580px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"video-bg-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"#f2f2f2","background-image":"4867","background-image-style":"no-repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"70px","bottom":"75px","left":"77px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Watch The Presentation","caption":"Bookmarksgrove right at the coast","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"35px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>\n<p>of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her. powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of</p>\n","text-align":"left","font-size":"","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Story About Us","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/demo2/about-us/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"16px","right":"24px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"4px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#81ca41","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"20px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"620px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4946","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Services","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.","text-align":"center","font-size":"17px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"25px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View More Services","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"16px","right":"24px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"4px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#3a3a3a","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4852","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Code Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/code-optimization/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4858","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Seach Engine Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/search-engine-optimization/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4859","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4763","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Seach Engine Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/search-engine-marketing/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4853","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Monitoring Ranking","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/monitoring-ranking","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4854","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4781","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Target Strategy","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/target-strategy","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4855","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4785","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Nap Syndication","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/nap-syndication/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4856","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4787","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"SEO Support","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/seo-support/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4857","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4789","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Email Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/email-marketing/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4770","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"0px","left":"25px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Great Monitoring Tool","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove.","text-align":"left","font-size":"15px","padding-bottom":"10px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#3155a7","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Social Media Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia,<strong> there live the blind</strong> texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies. Nulla vitae elit libero, a pharetra augue. Donec id elit non mi porta gravida at","text-align":"left","font-size":"15px","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"16px","right":"24px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"4px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#3155a7","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"14px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4769","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4947","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4948","title":"Goal Discuss","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Conson antia, theree texts.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"70","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"45px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4949","title":"Strategy Planning","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Conson antia, theree texts.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"70","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"45px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4950","title":"Execution","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Conson antia, theree texts.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"70","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"45px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"4951","title":"Monitoring","caption":"","content":"Far far away, behind the word moun tains, far from the countries Vokalia and Conson antia, theree texts.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"20px","title-font-weight":"70","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"45px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#2a427a","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"CTA Purple"},"items":[{"template":"element","type":"call-to-action","value":{"id":"","class":"","title":"Interested in our service now?","caption":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live","button-text":"Request a free quote","button-link":"/seocrawler/demo2/free-quote/","button-link-target":"_self","style":"left-align-right-button","button-style":"solid","button-border-radius":"3px","title-size":"36px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"17px","caption-letter-spacing":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"770px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"What Clients Say?","title-left-icon":"","caption":"","tabs":[{"title":"John Doe","position":"Customer","content":"A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful.","image":"4875","image-img":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/testimonial-1.jpg","rating":""},{"title":"Jane Smith","position":"Web Marketing Analyst","content":"Donec id elit non mi porta gravida at eget metus. Maecenas faucibus mollis interdum. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum.","image":"4877","image-img":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/shutterstock_447504466.jpg","rating":""},{"title":"Paul Frank","position":"CEO Of Apple Corp.","content":"Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Donec sed odio dui. Vestibulum id ligula porta felis euismod semper.","image":"4876","image-img":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/shutterstock_342458267.jpg","rating":""}],"style":"center","column":"1","enable-quote":"disable","carousel":"enable","carousel-autoslide":"enable","carousel-navigation":"navigation","carousel-nav-style":"default","title-size":"33px","title-text-transform":"none","title-letter-spacing":"0px","caption-size":"16px","content-size":"20px","title-color":"","caption-color":"","quote-color":"","content-color":"","name-color":"","position-color":"","title-wrap-bottom-margin":"40px","content-bottom-padding":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f5f5f5","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"25px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"4883","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-1.png"},{"id":"4884","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-2.png"},{"id":"4885","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-3.png"},{"id":"4886","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-4.png"},{"id":"4887","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2016/06/banner-5-150x33.png"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"navigation","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Port Carousel"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"Case Studies","caption":"Far far away, behind the word mountains, far from the countries Vokalia and<br/> Consonantia, there live the blind texts. blind text by the name. ","caption-position":"bottom","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"33px","title-font-style":"","title-text-transform":"none","caption-size":"17px","caption-font-style":"normal","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"gdlr-core-plain-style"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"32px","right":"0px","bottom":"5px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/demo2/free-analysis/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"16px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#3155a7","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"/seocrawler/demo2/free-quote/","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"16px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"14px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"","padding-bottom":"0px","icon-color":"","divider-color":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4893","background-image-style":"repeat-x","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.14","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"20px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Service Plans","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"24px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"price-table","value":{"id":"","class":"","tabs":[{"icon":"icon_genius","image":"","image-img":"","title":"Basic Plan","caption":"Suitable For Small Business","price":"100","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"disable"},{"icon":"fa fa-star-o","image":"","image-img":"","title":"Advanced Plan","caption":"Suitable For Pro","price":"300","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"enable"},{"icon":"icon_lightbulb_alt","image":"","image-img":"","title":"Platinum Plan","caption":"Suitable For Enterprise","price":"500","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"disable"}],"price-prefix":"$","price-suffix":"/ MO","header-color":"#d16142","header-gradient-color":"#d16142","icon-color":"","title-color":"","caption-color":"#f8f8f8","price-background-color":"","price-prefix-color":"","price-text-color":"","price-suffix-color":"","content-background-color":"","content-color":"","content-border-color":"","button-text-color":"","button-background-color":"#d16142","button-background-gradient-color":"","a-header-color":"#3155a7","a-header-gradient-color":"#3155a7","a-icon-color":"","a-title-color":"","a-caption-color":"#f8f8f8","a-price-background-color":"","a-price-prefix-color":"","a-price-text-color":"","a-price-suffix-color":"","a-content-background-color":"","a-content-color":"","a-content-border-color":"","a-button-text-color":"","a-button-background-color":"#3155a7","a-button-background-gradient-color":"","padding-bottom":"30px"}}]}]}]';
				case 'homepage3': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#282828","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"3","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"45px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_genius","icon-style":"normal","image":"4935","title":"Big Data Analysis","caption":"","content":"The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious.","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"38px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"#43a351","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_star_alt","icon-style":"normal","image":"4935","title":"SEO Mobile Specialty","caption":"","content":"The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious.","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"38px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"#43a351","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"hp-1-form-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_easel","icon-style":"normal","image":"4935","title":"Social Network Monitoring","caption":"","content":"The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious.","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"38px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"15px","read-more-size":"14px","icon-color":"#43a351","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#2a427a","background-image":"4959","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"CTA HP3"},"items":[{"template":"element","type":"call-to-action","value":{"id":"","class":"","title":"Interested in our service now?","caption":"Far far away, behind the word mountains far from the countries Vokalia and <br/>Consonantia, there live","button-text":"Request a free quote","button-link":"/seocrawler/demo3/free-quote/","button-link-target":"_self","style":"left-align-right-button","button-style":"solid","button-border-radius":"3px","title-size":"36px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"17px","caption-letter-spacing":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4960","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"125px","right":"0px","bottom":"240px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"1200px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"What drives your website great results","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"45px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.","text-align":"center","font-size":"17px","padding-bottom":"55px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4961","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"24px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Page Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ffffff","icon-background-color":"","content-color":"#ffffff","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4962","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Internal Site Audit","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ffffff","icon-background-color":"","content-color":"#ffffff","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4963","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Content Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ffffff","icon-background-color":"","content-color":"#ffffff","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4964","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Technical SEO","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ffffff","icon-background-color":"","content-color":"#ffffff","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"-208px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4965","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4952","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Social Media Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia,<strong> there live the blind</strong> texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies. Nulla vitae elit libero, a pharetra augue. Donec id elit non mi porta.","text-align":"left","font-size":"16px","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"16px","right":"24px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"29px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"#43a351","text-hover-color":"#4c4c4c","background-color":"#3155a7","background-hover-color":"","background-gradient-color":"","border-color":"#43a351","border-hover-color":"#353535","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"16px","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4966","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"110px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4967","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"0px","left":"25px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Great Monitoring Tool","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove.","text-align":"left","font-size":"15px","padding-bottom":"10px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#43a351","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4968","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"HP3 Service"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"830px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"4851","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"5px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Services","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Dud","text-align":"center","font-size":"17px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4852","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Code Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/code-optimization/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4858","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Seach Engine Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/search-engine-optimization/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4859","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4763","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Seach Engine Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/search-engine-marketing/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4853","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Monitoring Ranking","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/monitoring-ranking","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4854","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4781","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Target Strategy","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/target-strategy","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4855","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4785","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Nap Syndication","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/nap-syndication/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4856","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4787","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"SEO Support","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/seo-support/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4857","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"4789","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom","overlay-icon-style":"on-hover","overlay-icon":"fa fa-external-link","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"22px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Email Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/seocrawler/email-marketing/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"15px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"#ff4800","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"15px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View More Services","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/demo3/our-services/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"16px","right":"24px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"4px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#494949","text-hover-color":"","background-color":"#ffffff","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"analysis-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4969","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"90px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Be on the top & Get more traffic  to your website","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language.","text-align":"left","font-size":"17px","padding-bottom":"25px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_cloud_alt","icon-hover":"","title":"Be on the top of Google","link-url":""},{"icon":"icon_clock_alt","icon-hover":"","title":"Save your time and let us handle it","link-url":""},{"icon":"icon_desktop","icon-hover":"","title":"Cros-devices ability","link-url":""},{"icon":"icon_star_alt","icon-hover":"","title":"Be rewarded by our services","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#43a351","icon-background-color":"","content-color":"#43a351","border-color":"","icon-size":"25px","content-size":"18px","list-bottom-margin":"24px","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"See Case Studies","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/demo3/portfolio-3-columns/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"16px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"border-radius":"4px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#111111","text-hover-color":"","background-color":"#3155a7","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"16px","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"analysis-height","centering-sync-height-content":"enable","background-type":"image","background-extending":"right","background-color":"","background-image":"4970","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.05","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"30px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"-50px","settings":"unlink"},"skin":"Contact form green"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Free SEO Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"icon","left-icon":"icon_genius","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"28px","title-font-size":"25px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"#43a351","title-color":"#43a351","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin":{"top":"-4px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4846","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"*We will get back to you within 3 days","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4971","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"2342","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"6302","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Port Carousel"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"32px","right":"0px","bottom":"5px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/seocrawler/demo3/free-analysis/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#3375cf","background-hover-color":"#4c82ce","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"/seocrawler/demo3/free-quote/","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#1a4580","background2-hover-color":"#445c7f","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","text-transform":"","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#43a351","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"65px","right":"0px","bottom":"25px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"4972","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2017/07/hp3-banner-1-150x150.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4973","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2017/07/hp3-banner-2-150x150.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4975","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2017/07/hp3-banner-4-150x150.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4976","thumbnail":"http://demo.goodlayers.com/seocrawler/wp-content/uploads/2017/07/hp3-banner-5-150x150.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"4","layout":"fitrows","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"navigation","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f5f5f5","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Recent Articles","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"element","type":"blog","value":{"id":"","class":"","category":["blog"],"tag":"","num-fetch":"8","prepend-sticky":"enable","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-column-with-frame","blog-full-alignment":"left","blog-list-with-frame":"disable","always-show-overlay-content":"disable","show-thumbnail":"enable","thumbnail-size":"Portfolio Thumbnail","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","item-size":"small","excerpt":"specify-number","excerpt-number":"20","blog-date-feature":"enable","meta-option":["date","author","category","comment-number"],"show-read-more":"enable","blog-title-font-size":"24px","blog-title-font-weight":"600","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","padding-bottom":"60px","title-align":"center","title-left-icon":"","title":"","caption":"","caption-position":"top","read-more-text":"","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"17px","caption-font-style":"normal","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"15px","title-carousel-nav-style":"gdlr-core-plain-style"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#3375cf","background-hover-color":"#4c82ce","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#1a4580","background2-hover-color":"#445c7f","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]';
				case 'homepage-marketing':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeIn","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"9","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"shape-divider","value":{"id":"","class":"","position":"bottom","shape":"curve-asymmetrical","custom-shape":"","inverted":"enable","flip":"disable","vflip":"disable","opacity":"","color":"#ffffff","width":"130","height":"","hide-this-item-in":"mobile"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"800px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"100px","right":"","bottom":"95px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"0px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We’re an agency that runs remarkably successful SEO campaigns","caption":"Technical and creative expertise","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#18181f","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#9face6","item-left-margin":"","caption-spaces":"20px","media-margin":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"100px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#9face6"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"100px","right":"","bottom":"145px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Get more traffic to your site","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#18181f","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Everyone wants to be on the first page, but not everyone deserves to be there. Your business, brand and website have to earn that right.<br /><br />Google now use over 200 signals in their algorithm for scoring and last year, there were over 540 quality improvements to their search algorithm alone.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#373737","margin-left":"","margin-right":"","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Our Work","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"33px","bottom":"17px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#9face6","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"flipbox","value":{"id":"","class":"","media-type":"image","icon":"fa fa-android","image":"4837","title":"SEO Consultancy","title-divider":"disable","caption":"","content":"<p>We help you define your SEO objectives &amp; develop a strategy with you. We analyse your website’s structure &amp; architecture.</p>","link-to":"custom-url","custom-image":"","video-url":"","link-url":"#","link-target":"_self","text-align":"center","icon-color":"","title-color":"#18181f","title-divider-color":"","caption-color":"#696969","content-color":"#696969","icon-size":"35px","title-size":"22px","title-font-weight":"500","caption-size":"16px","content-size":"16px","content-padding":{"top":"35px","right":"35px","bottom":"35px","left":"35px","settings":"unlink"},"padding-bottom":"30px","sync-height":"","centering-sync-height-content":"disable","background-color":"#ffffff","background-image":"","background-opacity":"0.62","border-type":"outer","border-color":"#e7e7e7","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-radius":"8px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"shadow-size":"","shadow-color":"","shadow-opacity":"0.2","b-media-type":"image","b-icon":"fa fa-android","b-image":"4838","b-title":"SEO Consultancy","b-title-divider":"disable","b-caption":"","b-content":"<p>We help you define your SEO objectives &amp; develop a strategy with you. We analyse your website’s structure &amp; architecture.</p>","b-text-align":"center","b-icon-color":"","b-title-color":"#ffffff","b-title-divider-color":"","b-caption-color":"#ffffff","b-content-color":"#ffffff","b-icon-size":"35px","b-title-size":"22px","b-title-font-weight":"500","b-caption-size":"16px","b-content-size":"16px","b-content-padding":{"top":"35px","right":"35px","bottom":"35px","left":"35px","settings":"link"},"b-background-color":"#9face6","b-background-image":"","b-background-opacity":"0.62","b-border-type":"outer","b-border-color":"","b-border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"b-border-radius":"8px","b-pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}},{"template":"element","type":"flipbox","value":{"id":"","class":"","media-type":"image","icon":"fa fa-android","image":"4839","title":"Link Building","title-divider":"disable","caption":"","content":"<p>We help you define your SEO objectives &amp; develop a strategy with you. We analyse your website’s structure &amp; architecture.</p>","link-to":"custom-url","custom-image":"","video-url":"","link-url":"#","link-target":"_self","text-align":"center","icon-color":"","title-color":"#18181f","title-divider-color":"","caption-color":"#696969","content-color":"#696969","icon-size":"35px","title-size":"22px","title-font-weight":"500","caption-size":"16px","content-size":"16px","content-padding":{"top":"35px","right":"35px","bottom":"35px","left":"35px","settings":"link"},"padding-bottom":"30px","sync-height":"","centering-sync-height-content":"disable","background-color":"#ffffff","background-image":"","background-opacity":"0.62","border-type":"outer","border-color":"#e7e7e7","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-radius":"8px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"shadow-size":"","shadow-color":"","shadow-opacity":"0.2","b-media-type":"image","b-icon":"fa fa-android","b-image":"4840","b-title":"Link Building","b-title-divider":"disable","b-caption":"","b-content":"<p>We help you define your SEO objectives &amp; develop a strategy with you. We analyse your website’s structure &amp; architecture.</p>","b-text-align":"center","b-icon-color":"","b-title-color":"#ffffff","b-title-divider-color":"","b-caption-color":"#ffffff","b-content-color":"#ffffff","b-icon-size":"35px","b-title-size":"22px","b-title-font-weight":"500","b-caption-size":"16px","b-content-size":"16px","b-content-padding":{"top":"35px","right":"35px","bottom":"35px","left":"35px","settings":"link"},"b-background-color":"#9face6","b-background-image":"","b-background-opacity":"0.62","b-border-type":"outer","b-border-color":"","b-border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"b-border-radius":"8px","b-pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"30px","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"flipbox","value":{"id":"","class":"","media-type":"image","icon":"fa fa-android","image":"4841","title":"Market Research","title-divider":"disable","caption":"","content":"<p>We help you define your SEO objectives &amp; develop a strategy with you. We analyse your website’s structure &amp; architecture.</p>","link-to":"custom-url","custom-image":"","video-url":"","link-url":"#","link-target":"_self","text-align":"center","icon-color":"","title-color":"#18181f","title-divider-color":"","caption-color":"#696969","content-color":"#696969","icon-size":"35px","title-size":"22px","title-font-weight":"500","caption-size":"16px","content-size":"16px","content-padding":{"top":"35px","right":"35px","bottom":"35px","left":"35px","settings":"link"},"padding-bottom":"30px","sync-height":"","centering-sync-height-content":"disable","background-color":"#ffffff","background-image":"","background-opacity":"0.62","border-type":"outer","border-color":"#e7e7e7","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-radius":"8px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"shadow-size":"","shadow-color":"","shadow-opacity":"0.2","b-media-type":"image","b-icon":"fa fa-android","b-image":"4842","b-title":"Market Research","b-title-divider":"disable","b-caption":"","b-content":"<p>We help you define your SEO objectives &amp; develop a strategy with you. We analyse your website’s structure &amp; architecture.</p>","b-text-align":"center","b-icon-color":"","b-title-color":"#ffffff","b-title-divider-color":"","b-caption-color":"#ffffff","b-content-color":"#ffffff","b-icon-size":"35px","b-title-size":"22px","b-title-font-weight":"500","b-caption-size":"16px","b-content-size":"16px","b-content-padding":{"top":"35px","right":"35px","bottom":"35px","left":"35px","settings":"link"},"b-background-color":"#9face6","b-background-image":"","b-background-opacity":"0.62","b-border-type":"outer","b-border-color":"","b-border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"b-border-radius":"8px","b-pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}},{"template":"element","type":"flipbox","value":{"id":"","class":"","media-type":"image","icon":"fa fa-android","image":"4843","title":"SEO Audit","title-divider":"disable","caption":"","content":"<p>We help you define your SEO objectives &amp; develop a strategy with you. We analyse your website’s structure &amp; architecture.</p>","link-to":"custom-url","custom-image":"","video-url":"","link-url":"#","link-target":"_self","text-align":"center","icon-color":"","title-color":"#18181f","title-divider-color":"","caption-color":"#696969","content-color":"#696969","icon-size":"35px","title-size":"22px","title-font-weight":"500","caption-size":"16px","content-size":"16px","content-padding":{"top":"35px","right":"35px","bottom":"35px","left":"35px","settings":"link"},"padding-bottom":"30px","sync-height":"","centering-sync-height-content":"disable","background-color":"#ffffff","background-image":"","background-opacity":"0.62","border-type":"outer","border-color":"#e7e7e7","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-radius":"8px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"shadow-size":"","shadow-color":"","shadow-opacity":"0.2","b-media-type":"image","b-icon":"fa fa-android","b-image":"4844","b-title":"SEO Audit","b-title-divider":"disable","b-caption":"","b-content":"<p>We help you define your SEO objectives &amp; develop a strategy with you. We analyse your website’s structure &amp; architecture.</p>","b-text-align":"center","b-icon-color":"","b-title-color":"#ffffff","b-title-divider-color":"","b-caption-color":"#ffffff","b-content-color":"#ffffff","b-icon-size":"35px","b-title-size":"22px","b-title-font-weight":"500","b-caption-size":"16px","b-content-size":"16px","b-content-padding":{"top":"35px","right":"35px","bottom":"35px","left":"35px","settings":"link"},"b-background-color":"#9face6","b-background-image":"","b-background-opacity":"0.62","b-border-type":"outer","b-border-color":"","b-border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"b-border-radius":"8px","b-pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6610","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"-120px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6530","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"4785","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"145px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"The creators of the famous website crawler and log file analyser tools","caption":"Search marketing agency","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#18181f","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#9face6","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We develop search strategies for large brands to small and medium sized enterprises. We\'re a team of technical and creative experts dedicated to smarter search engine marketing.<br /><br />Our web analytics consultancy service helps you understand your users and measure performance accurately across all platforms to make data informed decisions with confidence.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#373737","margin-left":"","margin-right":"","padding-bottom":"40px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"6511","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/10/right.png","icon":"","icon-hover":"","title":"Analitycs","caption":"","link-url":"","link-target":"_self"},{"image":"6511","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/10/right.png","icon":"","icon-hover":"","title":"Marketing","caption":"","link-url":"","link-target":"_self"},{"image":"6511","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/10/right.png","icon":"","icon-hover":"","title":"Management","caption":"","link-url":"","link-target":"_self"},{"image":"6511","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/10/right.png","icon":"","icon-hover":"","title":"SEO Tools","caption":"","link-url":"","link-target":"_self"}],"columns":"30","align":"left","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"#002e5b","caption-color":"","border-color":"","icon-size":"14px","content-size":"22px","content-font-weight":"500","content-text-transform":"none","content-letter-spacing":"","caption-size":"14px","caption-font-weight":"","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"","icon-right-margin":"","list-bottom-margin":"30px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6657","background-image-top-offset":"","background-image-bottom-offset":"50px","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"160px","t-right":"160px","b-right":"160px","b-left":"160px","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#e8e8e8","hover-border-color":"#","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"70px","right":"","bottom":"80px","left":"","settings":"unlink"},"margin":{"top":"25px","right":"25px","bottom":"25px","left":"25px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Marketing Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"137","animation-time":"","suffix":"+","divider":"disable","bottom-text":"Completed Sites","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"52px","number-font-weight":"600","bottom-text-size":"22px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"160px","t-right":"160px","b-right":"160px","b-left":"160px","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#e8e8e8","hover-border-color":"#","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"70px","right":"","bottom":"80px","left":"","settings":"unlink"},"margin":{"top":"25px","right":"25px","bottom":"25px","left":"25px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Marketing Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"1200","animation-time":"","suffix":"","divider":"disable","bottom-text":"Happy Customers","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"52px","number-font-weight":"600","bottom-text-size":"22px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"160px","t-right":"160px","b-right":"160px","b-left":"160px","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#e8e8e8","hover-border-color":"#","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"70px","right":"","bottom":"80px","left":"","settings":"unlink"},"margin":{"top":"25px","right":"25px","bottom":"25px","left":"25px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Marketing Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"11","animation-time":"","suffix":"k","divider":"disable","bottom-text":"Working Hours","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"52px","number-font-weight":"600","bottom-text-size":"22px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"160px","t-right":"160px","b-right":"160px","b-left":"160px","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#e8e8e8","hover-border-color":"#","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"70px","right":"","bottom":"80px","left":"","settings":"unlink"},"margin":{"top":"25px","right":"25px","bottom":"25px","left":"25px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Marketing Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"23","animation-time":"","suffix":"","divider":"disable","bottom-text":"Awards Winning","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"52px","number-font-weight":"600","bottom-text-size":"22px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6527","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6610","thumbnail-size":"full","z-index":"","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"6635","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are a New York based search marketing and digital agency","caption":"About Our Digital Advertising","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#18181f","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#74ebd5","item-left-margin":"","caption-spaces":"16px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We are a digital media strategy and campaign management agency, specializing in connecting purpose-driven campaign messages to customized audience segments.<br /><br />Our audience-centric approach to creating customized campaigns across display, search, social and rich-media channels allows our clients to achieve their digital advertising goals, reaching their target audience no matter where they are online.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#373737","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Discover","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"33px","bottom":"16px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#74ebd5","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"Discover","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"-80px","bottom":"0px","left":"-20px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6599","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"4785","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]},{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"73","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/techcom-150x70.png","link-to":"none","custom-image":"","video-url":"","page-id":"5","custom-url":"","custom-link-target":"_self"},{"id":"70","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/oneside-150x70.png","link-to":"none","custom-image":"","video-url":"","page-id":"5","custom-url":"","custom-link-target":"_self"},{"id":"71","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/the-found-150x70.png","link-to":"none","custom-image":"","video-url":"","page-id":"5","custom-url":"","custom-link-target":"_self"},{"id":"69","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/judson-150x70.png","link-to":"none","custom-image":"","video-url":"","page-id":"5","custom-url":"","custom-link-target":"_self"},{"id":"72","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/the-arc-150x70.png","link-to":"none","custom-image":"","video-url":"","page-id":"5","custom-url":"","custom-link-target":"_self"},{"id":"68","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/analy-150x70.png","link-to":"none","custom-image":"","video-url":"","page-id":"5","custom-url":"","custom-link-target":"_self"}],"random":"disable","pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid-no-space","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"6","layout":"fitrows","slider-navigation":"navigation","slider-bullet-style":"default","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","grid-slider-navigation":"navigation","carousel-bullet-style":"default","thumbnail-size":"full","slider-thumbnail-size":"medium","overlay-color":"","overlay-opacity":"","border-radius":"","image-bottom-margin":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#f6fbff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6664","background-image-top-offset":"","background-image-bottom-offset":"130px","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"bottom-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"800px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Check out what our customers have to say","caption":"We’re proud to still be working with many of the same people that hired us\nin our early days.","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"22px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#404146","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#7b7c7c","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","title-left-icon":"","caption":"","tabs":[{"title":"Stella Smith ","position":"Chief Technology Officer","content":"We started working about a year ago on our SEO campaign and now book marketing and training. Their insights have been invaluable to our marketing function.","image":"87","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/testimonial-1.jpg","rating":""},{"title":"Stella Smith ","position":"Chief Technology Officer","content":"We started working about a year ago on our SEO campaign and now book marketing and training. Their insights have been invaluable to our marketing function.","image":"97","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/10/home_3_testimonial_3.jpg","rating":""},{"title":"Stella Smith ","position":"Chief Technology Officer","content":"We started working about a year ago on our SEO campaign and now book marketing and training. Their insights have been invaluable to our marketing function.","image":"96","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/10/home_3_testimonial_2.jpg","rating":""},{"title":"Stella Smith ","position":"Chief Technology Officer","content":"We started working about a year ago on our SEO campaign and now book marketing and training. Their insights have been invaluable to our marketing function.","image":"87","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/testimonial-1.jpg","rating":""}],"style":"center-2","with-frame":"enable","column":"3","thumbnail-size":"thumbnail","enable-quote":"disable","left-quote-position":"left","quote-position":"bottom","rating-position":"left","rating-top-margin":"","carousel":"enable","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"none","carousel-nav-style":"default","carousel-bullet-style":"round gdlr-core-color-bullet","quote-size":"","quote-height":"","quote-top-margin":"","quote-bottom-margin":"","title-size":"16px","title-text-transform":"none","title-font-weight":"400","title-letter-spacing":"","content-size":"16px","content-font-style":"normal","content-font-weight":"400","content-letter-spacing":"","name-size":"14px","name-font-weight":"500","name-letter-spacing":"1px","name-text-transform":"uppercase","caption-size":"14px","position-font-style":"normal","position-font-weight":"500","rating-font-size":"","frame-border-size":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"frame-border-color":"#eaeaea","frame-hover-border-color":"#9dafe5","frame-border-radius":"8px","frame-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-shadow-color":"#f6fbff","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"","frame-hover-border-width":{"top":"0px","right":"0px","bottom":"6px","left":"0px","settings":"unlink"},"frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#9face6","frame-hover-shadow-opacity":"0.2","title-color":"","caption-color":"","quote-color":"","content-color":"#696969","name-color":"#222222","position-color":"#696969","star-rating-color":"","thumbnail-width":"","caption-spaces":"","title-wrap-bottom-margin":"","content-bottom-padding":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"130px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"10px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"View some of our featured works","caption":"Our Latest Projects","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#18181f","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#9face6","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>View some of our case studies below. We will work to deliver that strategy by building out your existing campaigns, or establishing accounts at new networks. We develop search strategies for all-sized enterprises.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#373737","margin-left":"","margin-right":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"149px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"right","full-width-button":"disable","button-padding":{"top":"10px","right":"35px","bottom":"12px","left":"35px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"enable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#777777","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#d3d3d3","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"11px","text-font-weight":"700","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","view-all-works-button":"disable","view-all-works-text":"View All Works","view-all-works-link":"","portfolio-style":"modern","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-title":"enable","enable-portfolio-tag":"enable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title-icon","column-size":"20","thumbnail-size":"Portfolio Long","enable-thumbnail-zoom-on-hover":"disable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"disable","carousel-start-at":"","carousel-scrolling-item-amount":"1","carousel-navigation":"navigation-outer","carousel-navigation-align":"center","carousel-navigation-left-icon":"icon-arrow-left-circle","carousel-navigation-right-icon":"icon-arrow-right-circle","carousel-navigation-size":"36px","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"default","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","filter-font-size":"","filter-font-weight":"","filter-letter-spacing":"","filter-text-transform":"uppercase","portfolio-title-font-size":"","portfolio-title-font-weight":"","portfolio-title-letter-spacing":"","portfolio-title-text-transform":"uppercase","portfolio-tag-font-size":"","portfolio-tag-font-style":"","portfolio-tag-text-transform":"","portfolio-hover-title-font-size":"18px","portfolio-hover-title-font-weight":"600","portfolio-hover-title-letter-spacing":"0px","portfolio-hover-title-text-transform":"none","filterer-top-margin":"","filterer-bottom-margin":"","portfolio-frame-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"portfolio-border-radius":"","portfolio-frame-border-size":"","portfolio-frame-border-color":"","portfolio-frame-hover-border-color":"","portfolio-item-bottom-margin":"","portfolio-title-bottom-margin":"","pagination-top-margin":"","padding-bottom":"60px","overlay-color":"","overlay-opacity":"","frame-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-shadow-color":"#9face6","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}},{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free Seo Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"14px","right":"35px","bottom":"17px","left":"35px","settings":"unlink"},"border-radius":"25px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#9face6","background-hover-color":"","background-gradient-color":"","border-color":"#777777","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6663","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"4774","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"t-left":"","t-right":"","b-right":"","b-left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"250px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"10px","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"110px","right":"40px","bottom":"45px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Let\'s Get in Touch","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"50px","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#ffffff","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>If you have a project in need of a sophisticated digital advertising campaign, we’d love to hear from you!</p>\n","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"22px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#ffffff","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get Started","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"27px","bottom":"17px","left":"27px","settings":"unlink"},"border-radius":"25px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#9face6","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#ffffff","background-hover-color":"","background-gradient-color":"","border-color":"#777777","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"600","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]}]';
				case 'homepage-seostrategy':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6698","background-image-top-offset":"50px","background-image-bottom-offset":"","mobile-background-image":"6710","background-image-style":"cover","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"120px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"20px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"-250px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6642","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"6635","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"150px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Are you frustrated with your <span style=\"color: #f9ada0;\">SEO results</span> and marketing online? ","caption":"Search Engine Optimization Services","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#18181f","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#f9ada0","item-left-margin":"","caption-spaces":"15px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"100px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"30px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#f9ada0"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We’ll identify your performance gaps and build an Search Engine Optimization action plan for immediate results and a sustained growth path. We’re an SEO -first team – it’s in our DNA. We believe that 20% of actions drive 80% of results, so we focus on what will move the needle in our SEO services.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#373737","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"33px","bottom":"17px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#f9ada0","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"Watch Video","button2-link-to":"lb-video","button2-custom-image":"","button2-video-url":"https://www.youtube.com/watch?v=7e90gBu4pas","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"left","button2-icon":"arrow_triangle-right_alt2","button2-padding":{"top":"15px","right":"10px","bottom":"15px","left":"20px","settings":"unlink"},"border2-radius":"25px","button2-background":"transparent","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"#18181f","icon2-color":"#f9ada0","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"35px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Marketing Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"137","animation-time":"","suffix":"+","divider":"disable","bottom-text":"Completed Sites","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"52px","number-font-weight":"600","bottom-text-size":"22px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"10px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Marketing Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"1200","animation-time":"","suffix":"","divider":"disable","bottom-text":"Happy Customers","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"52px","number-font-weight":"600","bottom-text-size":"22px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"10px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Marketing Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"11","animation-time":"","suffix":"k","divider":"disable","bottom-text":"Completed Sites","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"52px","number-font-weight":"600","bottom-text-size":"22px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"10px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Marketing Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"23","animation-time":"","suffix":"","divider":"disable","bottom-text":"Awards Winning","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"52px","number-font-weight":"600","bottom-text-size":"22px","bottom-text-font-weight":"500","bottom-text-transform":"none","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Strategy Accordion"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are a <span style=\"color: #9face6;\">digital marketing agency</span> helping challenger brands","caption":"Experience to optimize your website","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#18181f","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#9face6","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"100px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"45px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#9face6"}},{"template":"element","type":"accordion","value":{"id":"","class":"","tabs":[{"head-text":"","title":"We make sure to perform a thorough backlink analysis tools","content":"An accordion content areaSearch engine optimization is the process by which one optimizes their webpage through various methods in order for search engines to favor their website in search engine results."},{"head-text":"","title":"We x-ray your website using advanced SEO ","content":"Search engine optimization is the process by which one optimizes their webpage through various methods in order for search engines to favor their website in search engine results."},{"head-text":"","title":"Out team offers effective keyword search strategies","content":"Search engine optimization is the process by which one optimizes their webpage through various methods in order for search engines to favor their website in search engine results."}],"active":"1","allow-closing-all-tabs":"disable","style":"background-title-icon","align":"left","icon-position":"right","padding-bottom":"30px","title-font-size":"17px","title-font-weight":"400","title-letter-spacing":"0px","title-text-transform":"none","title-padding":{"top":"15px","right":"","bottom":"15px","left":"","settings":"unlink"}}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Discover","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"36px","bottom":"17px","left":"36px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#9face6","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"left","button2-icon":"fa5r fa5-play-circle","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"transparent","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"#18181f","icon2-color":"#f9ada0","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"-50px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"50px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6643","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"6635","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6704","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Column SEO"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"700px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Stand out from your competitors with unique, and<span style=\"color: #b3d89c;\"> fully-responsive website</span>","caption":"An expert digital marketing agency","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#18181f","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#b3d89c","item-left-margin":"","caption-spaces":"15px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"100px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#b3d89c"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"hidden","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"","frame-hover-shadow-size":{"x":"0px","y":"2px","size":"50px","settings":"unlink"},"frame-hover-shadow-color":"#9face6","frame-hover-shadow-opacity":"0.15","padding":{"top":"20px","right":"20px","bottom":"65px","left":"20px","settings":"unlink"},"margin":{"top":"","right":"15px","bottom":"40px","left":"15px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6644","character":"","title":"SEO Consultancy","caption":"","caption-position":"bottom","content":"<p>We help you define your SEO objectives &amp; develop a strategy with you. We analyse your website’s structure &amp; architecture.</p>","read-more-text":"","read-more-link":"","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-long-arrow-right","style":"center_icon-top","icon-size":"30px","title-size":"22px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"12px","right":"","bottom":"5px","left":""},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"20px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"}}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"#9face6","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"500","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"20px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"hidden","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"","frame-hover-shadow-size":{"x":"0px","y":"2px","size":"50px","settings":"unlink"},"frame-hover-shadow-color":"#9face6","frame-hover-shadow-opacity":"0.15","padding":{"top":"20px","right":"20px","bottom":"65px","left":"20px","settings":"unlink"},"margin":{"top":"","right":"15px","bottom":"40px","left":"15px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6645","character":"","title":"Google Adsense","caption":"","caption-position":"bottom","content":"<p>We help you define your SEO objectives &amp; develop a strategy with you. We analyse your website’s structure &amp; architecture.</p>","read-more-text":"","read-more-link":"","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-long-arrow-right","style":"center_icon-top","icon-size":"30px","title-size":"22px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"13px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"12px","right":"","bottom":"5px","left":""},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"20px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"#9face6","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"500","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"20px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"hidden","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"","frame-hover-shadow-size":{"x":"0px","y":"2px","size":"50px","settings":"unlink"},"frame-hover-shadow-color":"#9face6","frame-hover-shadow-opacity":"0.15","padding":{"top":"20px","right":"20px","bottom":"65px","left":"20px","settings":"unlink"},"margin":{"top":"","right":"15px","bottom":"40px","left":"15px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6646","character":"","title":"Content Strategy","caption":"","caption-position":"bottom","content":"<p>We help you define your SEO objectives &amp; develop a strategy with you. We analyse your website’s structure &amp; architecture.</p>","read-more-text":"","read-more-link":"","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-long-arrow-right","style":"center_icon-top","icon-size":"30px","title-size":"22px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"13px","read-more-font-weight":"500","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"12px","right":"","bottom":"5px","left":""},"media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"20px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"#9face6","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"500","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"20px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"element","type":"image","value":{"id":"","class":"","image":"6610","thumbnail-size":"full","z-index":"","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"6635","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6710","background-image-top-offset":"","background-image-bottom-offset":"140px","mobile-background-image":"","background-image-style":"cover","background-image-position":"bottom-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"-60px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"View some of our featured case studies below","caption":"Our latest Project","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#18181f","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#9face6","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"100px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"30px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#9face6"}}]},{"template":"wrapper","type":"column","column":"30"},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"skin":"Port Carousel"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","view-all-works-button":"disable","view-all-works-text":"View All Works","view-all-works-link":"","portfolio-style":"modern","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-title":"enable","enable-portfolio-tag":"enable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title-tag-slide","column-size":"20","thumbnail-size":"Personnel Square","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-start-at":"","carousel-scrolling-item-amount":"1","carousel-navigation":"navigation-top","carousel-navigation-align":"right","carousel-navigation-left-icon":"arrow_left","carousel-navigation-right-icon":"arrow_right","carousel-navigation-size":"39px","carousel-navigation-margin":"60px","carousel-navigation-icon-margin":"5px","carousel-bullet-style":"cylinder-left","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","filter-font-size":"","filter-font-weight":"","filter-letter-spacing":"","filter-text-transform":"uppercase","portfolio-title-font-size":"","portfolio-title-font-weight":"","portfolio-title-letter-spacing":"","portfolio-title-text-transform":"uppercase","portfolio-tag-font-size":"14px","portfolio-tag-font-style":"normal","portfolio-tag-text-transform":"uppercase","portfolio-hover-title-font-size":"20px","portfolio-hover-title-font-weight":"500","portfolio-hover-title-letter-spacing":"0px","portfolio-hover-title-text-transform":"none","filterer-top-margin":"","filterer-bottom-margin":"","portfolio-frame-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"portfolio-border-radius":"8px","portfolio-frame-border-size":"","portfolio-frame-border-color":"","portfolio-frame-hover-border-color":"","portfolio-item-bottom-margin":"","portfolio-title-bottom-margin":"","pagination-top-margin":"","padding-bottom":"30px","overlay-color":"#9face6","overlay-opacity":"","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6610","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"6635","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"40px","bottom":"0px","left":"-200px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6649","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"6635","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"160px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"80px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Proven track record of delivering <span style=\"color: #9face6;\">digital marketing results</span>","caption":"We work with your team","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#18181f","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#9face6","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"100px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"35px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#9face6"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We start with designing your ad campaigns based on competitive keyword research analysis, and then we optimize the campaigns as they run through bid management, A/B testing and other methods. We maintain ongoing campaign management to ensure the success of your ads.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#373737","margin-left":"","margin-right":"","padding-bottom":"10px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"","icon-hover":"","title":"Campaign design ","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Keyword research ","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Technical seo audit","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Content strategy","caption":"","link-url":"","link-target":"_self"}],"columns":"30","align":"left","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"#373737","caption-color":"#373737","border-color":"","icon-size":"14px","content-size":"22px","content-font-weight":"500","content-text-transform":"none","content-letter-spacing":"","caption-size":"14px","caption-font-weight":"","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"","icon-right-margin":"","list-bottom-margin":"10px","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get Started","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"33px","bottom":"17px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#9face6","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"left","button2-icon":"fa5r fa5-play-circle","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"transparent","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"#18181f","icon2-color":"#f9ada0","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"73","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/techcom-150x70.png"},{"id":"70","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/oneside-150x70.png"},{"id":"71","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/the-found-150x70.png"},{"id":"69","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/judson-150x70.png"},{"id":"72","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/the-arc-150x70.png"},{"id":"68","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/analy-150x70.png"}],"random":"disable","pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid-no-space","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"6","layout":"fitrows","slider-navigation":"navigation","slider-bullet-style":"default","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","grid-slider-navigation":"navigation","carousel-bullet-style":"default","thumbnail-size":"full","slider-thumbnail-size":"medium","overlay-color":"","overlay-opacity":"","border-radius":"","image-bottom-margin":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6712","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"bottom-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"125px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"40px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"-60px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Check out what our customers have to say","caption":"Our Happy Clients","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#18181f","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#f9ada0","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"100px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"30px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#f9ada0"}}]},{"template":"wrapper","type":"column","column":"30"},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","title-left-icon":"","caption":"","tabs":[{"title":"Stella Smith ","position":"Chief Technology Officer","content":"“We started working with this digital agency about a year ago on our SEO campaign, and now book marketing and training. Their insights have been invaluable to our marketing function and our online business. With agency’s help, our rankings have gone from good to great and we’re getting found and closing more (new!) clients through search.”","image":"87","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/testimonial-1.jpg","rating":"10"},{"title":"Jane Smith ","position":"Chief Technology Officer","content":"“We started working with this digital agency about a year ago on our SEO campaign, and now book marketing and training. Their insights have been invaluable to our marketing function and our online business. With agency’s help, our rankings have gone from good to great and we’re getting found and closing more (new!) clients through search.”","image":"97","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/10/home_3_testimonial_3.jpg","rating":"10"},{"title":"Thomas Smith ","position":"Chief Technology Officer","content":"“We started working with this digital agency about a year ago on our SEO campaign, and now book marketing and training. Their insights have been invaluable to our marketing function and our online business. With agency’s help, our rankings have gone from good to great and we’re getting found and closing more (new!) clients through search.”","image":"96","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/10/home_3_testimonial_2.jpg","rating":"10"},{"title":"Stella Smith ","position":"Chief Technology Officer","content":"“We started working with this digital agency about a year ago on our SEO campaign, and now book marketing and training. Their insights have been invaluable to our marketing function and our online business. With agency’s help, our rankings have gone from good to great and we’re getting found and closing more (new!) clients through search.”","image":"87","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/testimonial-1.jpg","rating":"10"}],"style":"left","with-frame":"enable","column":"2","thumbnail-size":"full","enable-quote":"disable","left-quote-position":"left","quote-position":"bottom","rating-position":"right","rating-top-margin":"","carousel":"enable","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"navigation-top","carousel-navigation-align":"right","carousel-navigation-left-icon":"arrow_left","carousel-navigation-right-icon":"arrow_right","carousel-navigation-size":"39px","carousel-navigation-margin":"60px","carousel-navigation-icon-margin":"5px","carousel-nav-style":"default","carousel-bullet-style":"round gdlr-core-color-bullet","quote-size":"","quote-height":"","quote-top-margin":"","quote-bottom-margin":"","title-size":"28px","title-text-transform":"uppercase","title-font-weight":"","title-letter-spacing":"","content-size":"16px","content-font-style":"normal","content-font-weight":"400","content-letter-spacing":"","name-size":"14px","name-font-weight":"500","name-letter-spacing":"1px","name-text-transform":"uppercase","caption-size":"14px","position-font-style":"normal","position-font-weight":"500","rating-font-size":"","frame-border-size":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"frame-border-color":"#e5e5e5","frame-hover-border-color":"#ffffff","frame-border-radius":"8px","frame-shadow-size":{"x":"","y":"","size":"","settings":"unlink"},"frame-shadow-color":"","frame-shadow-opacity":"0.15","enable-move-up-shadow-effect":"enable","move-up-effect-length":"","frame-hover-border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"frame-hover-shadow-size":{"x":"","y":"10px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#9face6","frame-hover-shadow-opacity":"0.2","title-color":"","caption-color":"","quote-color":"","content-color":"#696969","name-color":"#222222","position-color":"#696969","star-rating-color":"","thumbnail-width":"","caption-spaces":"","title-wrap-bottom-margin":"","content-bottom-padding":"","padding-bottom":"0px"}}]}]}]';
				case 'homepage-startup':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#242636","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-padding":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"main-content","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"75px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"900px","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We have helped brands optimise their search results and thus increased their exposure","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#18181f","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","media-margin":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"100px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"40px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#f2617a"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"720px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Everyone wants to be on the first page, but not everyone deserves to be there. Your business, brand and website have to earn that right.</p>","text-align":"center","apply-the-content-filter":"enable","enable-p-space":"enable","font-size":"20px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#373737","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"35px","right":"35px","bottom":"35px","left":"35px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"","frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#242635","frame-hover-shadow-opacity":"0.15","padding":{"top":"40px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"14","character":"","title":"Market Research","caption":"","caption-position":"bottom","content":"<p>We help you define your SEO objectives &amp; develop a strategy with you. We analyse your website’s structure &amp; architectur</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"22px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"35px","right":"35px","bottom":"35px","left":"35px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"","frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#242635","frame-hover-shadow-opacity":"0.15","padding":{"top":"40px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"91","character":"","title":"SEO Audit","caption":"","caption-position":"bottom","content":"<p>We help you define your SEO objectives &amp; develop a strategy with you. We analyse your website’s structure &amp; architectur</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"22px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"enable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"35px","right":"35px","bottom":"35px","left":"35px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"","frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#242635","frame-hover-shadow-opacity":"0.15","padding":{"top":"40px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"92","character":"","title":"Link Building","caption":"","caption-position":"bottom","content":"<p>We help you define your SEO objectives &amp; develop a strategy with you. We analyse your website’s structure &amp; architectur</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"22px","title-font-weight":"500","title-letter-spacing":"","title-text-transform":"none","caption-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f9f9f9","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"Height Digital","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"22","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"Height Digital","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"100px","right":"150px","bottom":"70px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"50px","bottom":"","left":"","settings":"unlink"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-padding":{"top":"","right":"50px","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Digital marketing and advertising","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#404146","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We believe that establishing a close relationship with our clients from the get-go is the key to success.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"22px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#404146","margin-left":"","margin-right":"","padding-bottom":"20px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"30","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/icon-list1.png","icon":"","icon-hover":"","title":"Digital Strategy","caption":"Lead Generation & Conversion Rate Optimisation","link-url":"","link-target":"_self"},{"image":"31","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/icon-list-2.png","icon":"","icon-hover":"","title":"Analytics Configuration","caption":"Lead Generation & Conversion Rate Optimisation","link-url":"","link-target":"_self"},{"image":"32","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/icon-list-3.png","icon":"","icon-hover":"","title":"Google Tag Manager","caption":"Lead Generation & Conversion Rate Optimisation","link-url":"","link-target":"_self"}],"columns":"60","align":"left","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"#404146","caption-color":"#373737","border-color":"","icon-size":"14px","content-size":"22px","content-font-weight":"500","content-text-transform":"none","content-letter-spacing":"","caption-size":"16px","caption-font-weight":"400","caption-text-transform":"none","caption-letter-spacing":"0px","image-max-width":"","icon-top-margin":"9px","icon-right-margin":"27px","list-bottom-margin":"30px","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"13px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#f2617a","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#ffffff","background-hover-color":"","background-gradient-color":"","border-color":"#f2617a","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"4744","background-image-top-offset":"","background-image-bottom-offset":"55px","mobile-background-image":"109","background-image-style":"no-repeat","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"105px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are a New York based search marketing and digital agency","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#18181f","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We are a digital media strategy and campaign management agency, specializing in connecting purpose-driven campaign messages to customized audience segments.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"22px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#696969","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"skill-bar","value":{"id":"","class":"","bar-size":"small","bar-type":"round","tabs":[{"heading-text":"UX Design","icon":"","percent":"80","bar-text":""},{"heading-text":"Development","icon":"","percent":"70","bar-text":""},{"heading-text":"Search Engine Optimisation","icon":"","percent":"90","bar-text":""},{"heading-text":"Mobile Applications","icon":"","percent":"70","bar-text":""}],"heading-text-color":"#373737","icon-color":"","percent-color":"#f2617a","bar-filled-color":"#f2617a","bar-background-color":"#cccccc","padding-bottom":"30px"}}]},{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"73","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/techcom-150x70.png"},{"id":"70","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/oneside-150x70.png"},{"id":"71","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/the-found-150x70.png"},{"id":"69","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/judson-150x70.png"},{"id":"72","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/the-arc-150x70.png"},{"id":"68","thumbnail":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/analy-150x70.png"}],"random":"disable","pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid-no-space","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"6","layout":"fitrows","slider-navigation":"navigation","slider-bullet-style":"default","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","grid-slider-navigation":"navigation","carousel-bullet-style":"default","thumbnail-size":"full","slider-thumbnail-size":"medium","overlay-color":"","overlay-opacity":"","border-radius":"","image-bottom-margin":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#f7f9fa","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"100px","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"64px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"50","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"View some of our featured works","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#404146","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","media-margin":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>View some of our case studies below. We will work to deliver that strategy by building out your existing campaigns, or establishing accounts at new networks. We develop search strategies for all-sized enterprises.</p>","text-align":"left","apply-the-content-filter":"enable","enable-p-space":"enable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#404146","margin-left":"","margin-right":"","padding-bottom":"20px"}}]},{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"100px","right":"","bottom":"40px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"0px","right":"","bottom":"26px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"enable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#404146","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#bbbbbb","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"enable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"#404146","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"#bbbbbb","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"11px","text-font-weight":"700","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","view-all-works-button":"disable","view-all-works-text":"View All Works","view-all-works-link":"","portfolio-style":"modern","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-title":"enable","enable-portfolio-tag":"enable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title-icon","column-size":"20","thumbnail-size":"Personnel Square","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"disable","carousel-start-at":"","carousel-scrolling-item-amount":"1","carousel-navigation":"navigation-outer","carousel-navigation-align":"center","carousel-navigation-left-icon":"icon-arrow-left-circle","carousel-navigation-right-icon":"icon-arrow-right-circle","carousel-navigation-size":"36px","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"default","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","filter-font-size":"","filter-font-weight":"","filter-letter-spacing":"","filter-text-transform":"uppercase","portfolio-title-font-size":"","portfolio-title-font-weight":"","portfolio-title-letter-spacing":"","portfolio-title-text-transform":"uppercase","portfolio-tag-font-size":"","portfolio-tag-font-style":"","portfolio-tag-text-transform":"","portfolio-hover-title-font-size":"17px","portfolio-hover-title-font-weight":"600","portfolio-hover-title-letter-spacing":"0px","portfolio-hover-title-text-transform":"none","filterer-top-margin":"","filterer-bottom-margin":"","portfolio-frame-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"portfolio-border-radius":"8px","portfolio-frame-border-size":"","portfolio-frame-border-color":"","portfolio-frame-hover-border-color":"","portfolio-item-bottom-margin":"","portfolio-title-bottom-margin":"","pagination-top-margin":"","padding-bottom":"0px","overlay-color":"#242635","overlay-opacity":"0.8","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free Seo Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#f2617a","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"600","text-letter-spacing":"","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"75","background-image-top-offset":"","background-image-bottom-offset":"100px","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"-170px","left":"0px","settings":"unlink"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"730px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"25px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Check out what our customers have to say","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#404146","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"35px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"100px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"35px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#f2617a"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We’re proud to still be working with many of the same people that hired us in our early days.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"22px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#404146","margin-left":"","margin-right":"","padding-bottom":"30px"}}]},{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","title-left-icon":"","caption":"","tabs":[{"title":"Stella Smith","position":"Chief Technology Officer","content":"“We started working with this digital agency about a year ago on our SEO campaign, and now book marketing and training. Their insights have been invaluable to our marketing function and our online business. With agency’s help, our rankings have gone from good to great and we’re getting found and closing more (new!) clients through search.”","image":"87","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/testimonial-1.jpg","rating":"10"},{"title":"John Smith ","position":"Chief Technology Officer","content":"“We started working with this digital agency about a year ago on our SEO campaign, and now book marketing and training. Their insights have been invaluable to our marketing function and our online business. With agency’s help, our rankings have gone from good to great and we’re getting found and closing more (new!) clients through search.”","image":"96","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/10/home_3_testimonial_2.jpg","rating":"10"},{"title":"Jennet Jones","position":"Chief Technology Officer","content":"“We started working with this digital agency about a year ago on our SEO campaign, and now book marketing and training. Their insights have been invaluable to our marketing function and our online business. With agency’s help, our rankings have gone from good to great and we’re getting found and closing more (new!) clients through search.”","image":"97","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/10/home_3_testimonial_3.jpg","rating":"10"},{"title":"Alphy Hike","position":"Chief Technology Officer","content":"“We started working with this digital agency about a year ago on our SEO campaign, and now book marketing and training. Their insights have been invaluable to our marketing function and our online business. With agency’s help, our rankings have gone from good to great and we’re getting found and closing more (new!) clients through search.”","image":"87","image-img":"https://demo.goodlayers.com/seocrawler/homepages/startup/wp-content/uploads/sites/2/2019/09/testimonial-1.jpg","rating":"10"}],"style":"left","with-frame":"enable","column":"2","thumbnail-size":"thumbnail","enable-quote":"disable","left-quote-position":"left","quote-position":"bottom","rating-position":"right","rating-top-margin":"","carousel":"enable","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-nav-style":"default","carousel-bullet-style":"round2 gdlr-core-border-color-bullet","quote-size":"","quote-height":"","quote-top-margin":"","quote-bottom-margin":"","title-size":"28px","title-text-transform":"uppercase","title-font-weight":"","title-letter-spacing":"","content-size":"16px","content-font-style":"normal","content-font-weight":"400","content-letter-spacing":"","name-size":"14px","name-font-weight":"500","name-letter-spacing":"1px","name-text-transform":"uppercase","caption-size":"14px","position-font-style":"normal","position-font-weight":"500","rating-font-size":"","frame-border-size":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"frame-border-color":"#e8e8e8","frame-hover-border-color":"#ffffff","frame-border-radius":"8px","frame-shadow-size":{"x":"","y":"","size":"","settings":"unlink"},"frame-shadow-color":"","frame-shadow-opacity":"0.15","enable-move-up-shadow-effect":"enable","move-up-effect-length":"","frame-hover-border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"unlink"},"frame-hover-shadow-size":{"x":"","y":"15px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#0a0a0a","frame-hover-shadow-opacity":"0.15","title-color":"","caption-color":"","quote-color":"","content-color":"#696969","name-color":"#222222","position-color":"#696969","star-rating-color":"","thumbnail-width":"","caption-spaces":"","title-wrap-bottom-margin":"","content-bottom-padding":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"81","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"5px","t-right":"5px","b-right":"5px","b-left":"5px","settings":"link"},"parallax-speed":"","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"105px","right":"","bottom":"115px","left":"90px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"40px","bottom":"70px","left":"40px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Request a free quote!","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"50px","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"22px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#ffffff","item-left-margin":"","caption-spaces":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>If you have a project in need of a sophisticated digital <br />advertising campaign, we’d love to hear from you!</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"22px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#ffffff","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get Started","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"33px","bottom":"17px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#f2617a","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f7f9fa","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"50","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"","right":"","bottom":"60px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"20px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Latest news and our insights","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"22px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#404146","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#ffffff","item-left-margin":"","caption-spaces":"0px","media-margin":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Get the latest news and our insights on Marketing, SEO, Branding,<br />Design, Development, App and much more...</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#404146","margin-left":"","margin-right":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"75px","right":"","bottom":"40px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"10px","right":"","bottom":"10px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Visit Blog","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"enable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"404146","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#bbbbbb","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"enable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"#404146","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"#bbbbbb","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"11px","text-font-weight":"700","text-letter-spacing":"2px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"element","type":"blog","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","prepend-sticky":"enable","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-column-with-frame","blog-full-style":"style-1","blog-side-thumbnail-style":"style-1","blog-column-style":"style-4","blog-image-style":"style-1","blog-widget-style":"style-1","blog-full-alignment":"left","blog-image-alignment":"center","blog-list-with-frame":"disable","always-show-overlay-content":"disable","blog-image-thumbnail-overlay":"none","blog-image-thumbnail-overlay-opacity":"0.4","blog-image-thumbnail-overlay-color":"#000000","show-thumbnail":"enable","thumbnail-size":"Personnel Square","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"carousel","carousel-scrolling-item-amount":"1","carousel-autoslide":"disable","carousel-navigation":"navigation-outer","carousel-navigation-align":"center","carousel-navigation-left-icon":"icon-arrow-left-circle","carousel-navigation-right-icon":"icon-arrow-right-circle","carousel-navigation-size":"36px","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"default","blog-widget-column":"60","blog-widget-bottom-divider":"disable","item-size":"small","excerpt":"specify-number","excerpt-number":"15","blog-image-excerpt-number":"0","blog-date-feature":"enable","meta-option":["date","category","tag"],"show-read-more":"disable","read-more-button-text":"","filterer-bottom-margin":"","blog-title-font-size":"18px","blog-title-font-weight":"500","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","category-background-color":"","frame-shadow-size":{"x":"","y":"","size":"","settings":"unlink"},"frame-shadow-color":"","frame-shadow-opacity":"","enable-move-up-shadow-effect":"enable","move-up-effect-length":"","frame-hover-shadow-size":{"x":"","y":"10px","size":"35px","settings":"unlink"},"frame-hover-shadow-color":"#212121","frame-hover-shadow-opacity":"0.09","blog-border-radius":"9px","blog-frame-border-size":"1px","blog-frame-border-color":"#ededed","blog-frame-hover-border-color":"#ffffff","blog-frame-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"blog-image-overlay-content-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin-bottom":"","padding-bottom":"70px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]';
				case 'code-optimization': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4738","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"345px","right":"0px","bottom":"135px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Code Optimization","caption":"We are SEO Crawler","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"90px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"30px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About This Service","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents.</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Aenean lacinia bibendum nulla sed consectetur. Donec id elit non mi porta gravida at eget metus.lacinia bibendum nulla sed consectetur. Praesent commodo.</p>","text-align":"left","font-size":"19px","padding-bottom":"10px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"92px","padding-bottom":"30px","icon-color":"","divider-color":"#191919"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"20px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4741","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#33a8cf","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4743","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"105px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are a team of experts","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet morn ings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed inmoment; and yet I feel that I never was a</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>the moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4744","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Big Data Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4745","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"SEO Mobile Specialty","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4746","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Best Keyword Ranking","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4747","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Better Conversion","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"","padding-bottom":"0px","icon-color":"","divider-color":""}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4749","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Port Carousel"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4750","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"2342","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"6302","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Feel free to talk to us","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"100px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"#","youtube":"","dribbble":"","behance":"","instagram":"#","snapchat":"","text-align":"left","icon-size":"16px","with-text":"disable","text-size":"15px","icon-color":"#232323","icon-space":"20px","padding-bottom":"19px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>The moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ]<strong>Email</strong> <span style=\"margin-left: 15px;\">Sales@GoodLayers.com</span></span></p>\n<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Call Now!</strong> <span style=\"margin-left: 15px;\">+1-3454-5678-77</span></span></p>\n","text-align":"left","font-size":"16px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4751","padding-bottom":"30px"}}]}]}]';
				case 'email-marketing': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4660","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"195px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"960px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4775","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"120px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Email Marketing","caption":"Service by SEO Crawler","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"60px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"30px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. ","text-align":"center","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"35px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"1010px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"20px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4757","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4773","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"70px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"About This Service","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"37px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"35px","icon-color":"","divider-color":"#262626"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage of my trees, and but a few stray gleams steal into the inner sanctuary.","text-align":"center","font-size":"16px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#33a8cf","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4743","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"105px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are a team of experts","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet morn ings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed inmoment; and yet I feel that I never was a","text-align":"left","font-size":"16px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"the moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.","text-align":"left","font-size":"16px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"805px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"What drives your website great results","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"82px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>","text-align":"center","font-size":"17px","padding-bottom":"60px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4731","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"24px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Page Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4732","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Internal Site Audit","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4733","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Content Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4734","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Technical SEO","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"1320px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#e85431","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4777","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Keyword Search","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#eeaf29","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4778","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Competitive Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#3e55c8","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4779","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Link Building","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#353535","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"10px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4780","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"32px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Web Marketing Analytics","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"25px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"4749","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Port Carousel"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4750","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"2342","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"6302","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Feel free to talk to us","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"100px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"#","youtube":"","dribbble":"","behance":"","instagram":"#","snapchat":"","text-align":"left","icon-size":"16px","with-text":"disable","text-size":"15px","icon-color":"#232323","icon-space":"20px","padding-bottom":"19px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>The moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Email</strong> <span style=\"margin-left: 15px;\">Sales@GoodLayers.com</span></span></p>\n<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Call Now!</strong> <span style=\"margin-left: 15px;\">+1-3454-5678-77</span></span></p>\n","text-align":"left","font-size":"16px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4751","padding-bottom":"30px"}}]}]}]';
				case 'seo-support': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4660","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"195px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"960px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4677","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"120px","right":"0px","bottom":"220px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"SEO Support","caption":"Service by SEO Crawler","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"65px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"30px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. ","text-align":"center","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"-210px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4661","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"55px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4743","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Trusted by big organizations","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"34px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet morn ings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed inmoment; and yet I feel that I never was a</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>the moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4770","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"140px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Great Monitoring Tool","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies. Nulla vitae elit libero, a pharetra augue. Donec id elit non mi porta gravida at","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"140px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Social Media Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies. Nulla vitae elit libero, a pharetra augue. Donec id elit non mi porta gravida at","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4769","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4744","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Big Data Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4745","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"SEO Mobile Specialty","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4746","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Best Keyword Ranking","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4747","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Better Conversion","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4750","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"2342","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"6302","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"1320px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4758","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Keyword Search","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4759","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Competitive Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4760","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Link Building","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"10px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4761","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"32px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Web Marketing Analytics","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4772","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"64px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"1010px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"35px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About This Service","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"37px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is .a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind.","text-align":"center","font-size":"16px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#33a8cf","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#333333","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"25px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Feel free to talk to us","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"100px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"#","youtube":"","dribbble":"","behance":"","instagram":"#","snapchat":"","text-align":"left","icon-size":"16px","with-text":"disable","text-size":"15px","icon-color":"#232323","icon-space":"20px","padding-bottom":"19px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>The moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Email</strong> <span style=\"margin-left: 15px;\">Sales@GoodLayers.com</span></span></p>\n<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Call Now!</strong> <span style=\"margin-left: 15px;\">+1-3454-5678-77</span></span></p>\n","text-align":"left","font-size":"16px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4751","padding-bottom":"30px"}}]}]}]';
				case 'nap-syndication': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4660","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"195px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"1030px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4756","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"105px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Nap Syndication","caption":"Service by SEO Crawler","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"66px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"30px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"4757","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. ","text-align":"center","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"95px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"805px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"What drives your website great results","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"34px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"82px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>","text-align":"center","font-size":"17px","padding-bottom":"60px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4731","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"24px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Page Optimization","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4732","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Internal Site Audit","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4733","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Content Marketing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4734","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4724","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Technical SEO","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Internal Link Structuring","link-url":""},{"icon":"icon_check","icon-hover":"","title":"HTML Code Cleanup","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Website Content Writing","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Content Optimization","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ff4800","icon-background-color":"","content-color":"#676767","border-color":"","icon-size":"15px","content-size":"14px","list-bottom-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4771","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"2342","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"6302","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"55px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"1010px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"35px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About This Service","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"37px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is .a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind.","text-align":"center","font-size":"16px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#33a8cf","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4770","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"140px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Great Monitoring Tool","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies. Nulla vitae elit libero, a pharetra augue. Donec id elit non mi porta gravida at","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"140px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Social Media Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies. Nulla vitae elit libero, a pharetra augue. Donec id elit non mi porta gravida at","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4769","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"1320px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#e85431","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4777","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Keyword Search","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#eeaf29","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4778","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Competitive Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#3e55c8","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4779","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Link Building","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#353535","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"15px","bottom":"10px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4780","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4754","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"32px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Web Marketing Analytics","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mounta ins, far from the countries Vokalia and Conson antia, there live the blind texts.","text-align":"center","font-size":"14px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#333333","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"25px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Feel free to talk to us","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"100px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"#","youtube":"","dribbble":"","behance":"","instagram":"#","snapchat":"","text-align":"left","icon-size":"16px","with-text":"disable","text-size":"15px","icon-color":"#232323","icon-space":"20px","padding-bottom":"19px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>The moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Email</strong> <span style=\"margin-left: 15px;\">Sales@GoodLayers.com</span></span></p>\n<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Call Now!</strong> <span style=\"margin-left: 15px;\">+1-3454-5678-77</span></span></p>\n","text-align":"left","font-size":"16px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4751","padding-bottom":"30px"}}]}]}]';
				case 'target-strategy': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4738","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"265px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4783","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4781","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Target Strategy","caption":"We are SEO Crawler","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"90px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"30px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4743","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"105px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are a team of experts","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet morn ings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed inmoment; and yet I feel that I never was a</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>the moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"20px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4741","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"40px","right":"0px","bottom":"0px","left":"40px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About This Service","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. </p>","text-align":"left","font-size":"15px","padding-bottom":"5px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Aenean lacinia bibendum nulla sed consectetur. Donec id elit non mi porta gravida at eget metus.","text-align":"left","font-size":"19px","padding-bottom":"10px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"92px","padding-bottom":"30px","icon-color":"","divider-color":"#191919"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#33a8cf","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4762","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"2342","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"1000","end-number":"6302","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Optimized Websites","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"14","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Years Of Services","top-icon-size":"30px","top-text-size":"16px","number-size":"59px","bottom-text-size":"17px","bottom-text-transform":"uppercase","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4744","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Big Data Analysis","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4745","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"SEO Mobile Specialty","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4746","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Best Keyword Ranking","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4747","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4737","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Better Conversion","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"17px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","font-size":"15px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4784","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"680px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. blind text by the name.</p>","text-align":"center","font-size":"17px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","column-size":"20","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"16px","portfolio-title-font-weight":"500","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-icon":"","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Feel free to talk to us","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"100px","padding-bottom":"40px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"#","youtube":"","dribbble":"","behance":"","instagram":"#","snapchat":"","text-align":"left","icon-size":"16px","with-text":"disable","text-size":"15px","icon-color":"#232323","icon-space":"20px","padding-bottom":"19px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>The moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.</p>","text-align":"left","font-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Email</strong> <span style=\"margin-left: 15px;\">Sales@GoodLayers.com</span></span></p>\n<p><span style=\"color: #ff4800;\">[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"5px\" ] <strong>Call Now!</strong> <span style=\"margin-left: 15px;\">+1-3454-5678-77</span></span></p>\n","text-align":"left","font-size":"16px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"4751","padding-bottom":"30px"}}]}]}]';
				case 'monitoring-ranking': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4660","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"195px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"960px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4775","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"120px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark Port"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Monitoring Ranking","caption":"Service by SEO Crawler","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"60px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"30px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. ","text-align":"center","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"55px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"1010px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"35px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"4776","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"4773","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"70px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"About This Service","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"37px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"80px","padding-bottom":"27px","icon-color":"","divider-color":"#ff4800"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is .a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind.","text-align":"center","font-size":"16px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Free SEO Analysis","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#33a8cf","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Request a free quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"fa fa-long-arrow-right","button2-padding":{"top":"15px","right":"26px","bottom":"15px","left":"31px","settings":"unlink"},"border2-radius":"4px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"#81ca41","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"13px","icon-size":"14px","button2-left-margin":"20px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"4743","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"105px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are a team of experts","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet morn ings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed inmoment; and yet I feel that I never was a","text-align":"left","font-size":"16px","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"the moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage.","text-align":"left","font-size":"16px","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"1320px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#e85431","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"