<?php

defined('ABSPATH') || exit;

use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Form\Component as Form;
use \UtillzCore\Inc\Src\Listing\Listing;
use \UtillzCore\Inc\Src\User;

$request = Request::instance();
$user = User::instance();
$userdata = $user->get_userdata();
$listing = new Listing( $request->get('listing_id') );
$form = new Form( Form::Storage_Field );

$reviewed = get_comments([
    'post_id' => $listing->id,
    'user_id' => get_current_user_id(),
    'parent' => 0,
]);

$ratings = Ucore()->jsoning( 'ulz_review_ratings', $listing->type->id );

?>

<?php if( ! $listing->type->get('ulz_multiple_reviews') && $reviewed ): ?>
    <div class="ulz-modal-container ulz-scrollbar">
        <span class="ulz--icon">
            <div class="ulz-text-center">
                <i class="fas fa-check"></i>
                <p><?php esc_html_e( 'You already sent your review.', 'utillz-core' ); ?></p>
            </div>
        </span>
    </div>
    <?php return; ?>
<?php endif; ?>

<?php if( $listing->post->post_author == $user->id ): ?>
    <div class="ulz-modal-container ulz-scrollbar">
        <span class="ulz--icon">
            <div class="ulz-text-center">
                <i class="material-icons">highlight_off</i>
                <p><?php esc_html_e( 'You can\'t review your own listing', 'utillz-core' ); ?></p>
            </div>
        </span>
    </div>
    <?php return; ?>
<?php endif; ?>

<div class="ulz-modal-container ulz-scrollbar">
    <div class="ulz-reviews-form">
        <form class="ulz-form" autocomplete="off">
            <div class="ulz-grid">

                <?php if( $listing->type->get('ulz_enable_review_ratings') && $ratings ): ?>

                    <div class="ulz-col-12">
                        <h4 class="ulz--title"><?php esc_html_e( 'Rate your experience', 'utillz-core' ); ?></h4>
                    </div>

                    <div class="ulz-form-group ulz-col-">
                        <div class="ulz-ratings ulz-grid">
                            <?php foreach( $ratings as $key => $rating ): ?>
                                <div class="ulz-col-6 ulz-col-sm-12">
                                    <div class="ulz-rating">
                                        <div class="ulz-rating-name">
                                            <p><?php echo esc_attr( $rating->fields->name ); ?></p>
                                        </div>
                                        <div class="ulz-rating-stars">
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                        </div>
                                        <input type="hidden" name="ratings[<?php echo esc_attr( $rating->fields->key ); ?>]">
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>

                <?php endif; ?>

                <div class="ulz-col-12">
                    <h4 class="ulz--title"><?php esc_html_e( 'Leave your review', 'utillz-core' ); ?></h4>
                </div>

                <?php

                    $form->render([
                        'type' => 'hidden',
                        'id' => 'listing_id',
                        'value' => $request->get('listing_id'),
                    ]);

                    $form->render([
                        'type' => 'textarea',
                        'id' => 'comment',
                        // 'name' => esc_html__( 'Comment', 'utillz-core' ),
                    ]);

                ?>

                <?php if( $listing->type->get('ulz_enable_review_media') ): ?>

                    <div class="ulz-col-12">
                        <h4 class="ulz--title"><?php esc_html_e( 'Add media gallery', 'utillz-core' ); ?></h4>
                    </div>

                    <?php

                        $form->render([
                            'type' => 'upload',
                            'id' => 'gallery',
                            'multiple_upload' => true,
                            'display_info' => false,
                        ]);

                    ?>

                <?php endif; ?>

            </div>
        </form>

    </div>

    <span class="ulz--icon ulz-success ulz-none">
        <div class="ulz-text-center">
            <i class="fas fa-check"></i>
            <p><?php esc_html_e( 'Your review was sent successfully', 'utillz-core' ); ?></p>
        </div>
    </span>

</div>

<div class="ulz-modal-footer ulz--top-border ulz-text-center">
    <a href="#" class="ulz-button ulz-button-accent ulz-modal-button" id="ulz-review-submit">
        <span><?php esc_html_e( 'Submit Review', 'utillz-core' ); ?></span>
        <?php Ucore()->preloader(); ?>
    </a>
</div>
