<?php

defined('ABSPATH') || exit;

global $ulz_conversation;

$messages = $ulz_conversation->get_messages();
$receiver_userdata = get_userdata( $ulz_conversation->receiver_id );

?>

<div class="ulz-modal-container ulz-scrollbar">
    <div class="ulz-messages">
        <?php if( ! empty( $messages ) && is_array( $messages ) ): ?>
            <?php $last_date = null; ?>
            <?php foreach( $messages as $message ): ?>
                <?php $message_date = date_i18n( 'd-m-Y', strtotime( $message->created_at ) ); ?>
                <?php $is_me = get_current_user_id() == $message->sender_id; ?>
                <?php $usr = get_userdata( $message->sender_id ); ?>
                <?php if( $message_date !== $last_date ): ?>
                    <div class="ulz-message-date">
                        <div class="ulz--date">
                            <?php echo date_i18n( get_option('date_format'), strtotime( $message->created_at ) ); ?>
                        </div>
                    </div>
                    <?php $last_date = $message_date; ?>
                <?php endif; ?>
                <div class="ulz-message ulz-message-<?php echo $is_me ? 'me' : 'not-me'; ?>">

                    <div class="ulz--inner">
                        <div class="ulz--image">
                            <?php $user = new \UtillzCore\Inc\Src\User( $message->sender_id ); ?>
                            <?php $user_avatar = $user->get_avatar(); ?>
                            <?php if( $user_avatar ): ?>
                                <img src="<?php echo esc_url( $user_avatar ); ?>" alt="">
                            <?php else: ?>
                                <?php echo Ucore()->dummy( 'person', 'material-icons', 100, '#f1f1f1' ); ?>
                            <?php endif; ?>
                        </div>
                        <div class="ulz--content">
                            <div class="ulz--time">
                                <?php $offset = get_option('gmt_offset') * HOUR_IN_SECONDS; ?>
                                <?php echo date_i18n( get_option('time_format'), strtotime( $message->created_utc ) + $offset ); ?>
                            </div>
                            <div class="ulz--text">
                                <?php
                                    echo wp_kses( wpautop( stripslashes( $message->text ) ), [
                                        'br' => [],
                                        'p' => [],
                                        'u' => [],
                                        'strong' => []
                                    ]);
                                ?>
                            </div>
                        </div>
                    </div>

                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p class="ulz-text-center ulz-mb-0 ulz-mt-2"><?php esc_html_e( 'No messages', 'utillz-core' ); ?></p>
        <?php endif; ?>
    </div>
</div>

<div class="ulz-modal-footer ulz--top-border ulz-text-center">
    <div class="ulz-conversation-input">
        <div class="ulz-message-footer">
            <input type="hidden" id="ulz_message_conversation_id" value="<?php echo (int) $ulz_conversation->id; ?>">
            <?php if( $ulz_conversation->listing ): ?>
                <input type="hidden" id="ulz_message_listing_id" value="<?php echo (int) $ulz_conversation->listing->id; ?>">
            <?php else: ?>
                <input type="hidden" id="ulz_message_direct_user_id" value="<?php echo (int) $ulz_conversation->receiver_id; ?>">
            <?php endif; ?>
            <textarea id="ulz_message" name="ulz_message" value="" placeholder="<?php esc_html_e( 'Enter your message here ...', 'utillz-core' ); ?>"></textarea>
            <span class="ulz--button" data-action="send-message">
                <i class="fas fa-paper-plane"></i>
            </span>
        </div>
    </div>
</div>
