<?php
    $enable_google_auth = get_option('ulz_enable_google_auth');
    $enable_facebook_auth = get_option('ulz_enable_facebook_auth');
    $enable_standard_role = get_option('ulz_enable_standard_role');
    $enable_signup_phone = get_option('ulz_enable_signup_phone');
    $enable_signup_terms = get_option('ulz_enable_signup_terms');
    $signup_terms_text = get_option('ulz_signup_terms_text');
?>

<div class="ulz-modal-container">

    <?php if( get_option( 'users_can_register' ) ): ?>
        <div class="ulz-signin-tabs">
            <ul>
                <li class="ulz-active" data-for="sign-in" data-label="<?php esc_html_e( 'Sign in', 'utillz-core' ); ?>"><a href="#"><?php esc_html_e( 'Sign in', 'utillz-core' ); ?></a></li>
                <li data-for="create-account" data-label="<?php esc_html_e( 'Create account', 'utillz-core' ); ?>"><a href="#"><?php esc_html_e( 'Create account', 'utillz-core' ); ?></a></li>
            </ul>
        </div>
    <?php endif; ?>

    <form class="ulz-form ulz-signin-section ulz-active" data-id="sign-in" autocomplete="off">

        <?php if( get_option( 'users_can_register' ) ): ?>
            <?php if( $enable_google_auth || $enable_facebook_auth ): ?>

                <div class="ulz-signin-social">
                    <ul>
                        <?php if( $enable_google_auth ): ?>
                            <li>
                                <a href="#" class="ulz-button ulz--gg" data-action="sign-in-google">
                                    <span><?php esc_html_e( 'Continue with Google', 'utillz-core' ); ?></span>
                                    <?php Ucore()->preloader(); ?>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if( $enable_facebook_auth ): ?>
                            <li>
                                <a href="#" class="ulz-button ulz--fb" data-action="sign-in-facebook">
                                    <span><?php esc_html_e( 'Continue with Facebook', 'utillz-core' ); ?></span>
                                    <?php Ucore()->preloader(); ?>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>

                <div class="ulz-signin-or">
                    <span><?php esc_html_e( 'OR', 'utillz-core' ); ?></span>
                </div>

            <?php endif; ?>
        <?php endif; ?>

        <div class="ulz-grid">
            <!-- fix browser autocomplete -->
            <div style="position:absolute;z-index:-1;opacity:0;">
                <input type="text" name="username">
                <input type="password" name="password">
            </div>
            <!-- // fix browser autocomplete -->
            <div class="ulz-form-group ulz-col-12">
                <input type="text" name="user_email" value="<?php echo esc_html( apply_filters('utillz/login/user_email', '' ) ); ?>" placeholder="<?php esc_html_e( 'Username or email', 'utillz-core' ); ?>">
            </div>
            <div class="ulz-form-group ulz-col-12">
                <input type="password" name="user_password" value="<?php echo esc_html( apply_filters('utillz/login/user_password', '' ) ); ?>" placeholder="<?php esc_html_e( 'Password', 'utillz-core' ); ?>">
            </div>
            <div class="ulz-form-group ulz-inline-group ulz-col-12">
                <button type="submit" class="ulz-button ulz-button-accent ulz-block ulz-w-100 ulz-modal-button">
                    <span><?php esc_html_e( 'Sign in', 'utillz-core' ); ?></span>
                    <?php Ucore()->preloader(); ?>
                </button>
            </div>
            <div class="ulz-signin-errors">
                <!-- output -->
            </div>
            <div class="ulz-form-group ulz-col-12 ulz-text-center">
                <p class="ulz-mb-0">
                    <a href="#" data-for="reset-password" class="ulz-lost-pass-link" data-label="<?php esc_html_e( 'Reset password', 'utillz-core' ); ?>">
                        <i class="fas fa-unlock ulz-mr-1"></i><?php esc_html_e( 'Lost your password?', 'utillz-core' ); ?>
                    </a>
                </p>
            </div>
        </div>
    </form>

    <?php if( get_option( 'users_can_register' ) ): ?>
        <form class="ulz-form ulz-signin-section" data-id="create-account">

            <input type="submit" value="" class="ulz-none">

            <?php if( $enable_standard_role ): ?>
                <div class="ulz-standard-role">
                    <input type="hidden" name="role" value="customer">
                    <ul class="ulz-no-select">
                        <li>
                            <a href="#" data-role="customer">
                                <span><?php esc_html_e( 'Customer', 'utillz-core' ); ?></span>
                            </a>
                        </li>
                        <li>
                            <a href="#" data-role="business">
                                <span><?php esc_html_e( 'Business', 'utillz-core' ); ?></span>
                            </a>
                        </li>
                    </ul>
                </div>
            <?php endif; ?>

            <div class="ulz-signin-container<?php if( $enable_standard_role ) { echo ' ulz-none'; } ?>">
                <div class="ulz-signin-social">
                    <ul>
                        <?php if( $enable_google_auth ): ?>
                            <li>
                                <a href="#" class="ulz-button ulz--gg" data-action="sign-in-google">
                                    <span><?php esc_html_e( 'Continue with Google', 'utillz-core' ); ?></span>
                                    <?php Ucore()->preloader(); ?>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if( $enable_facebook_auth ): ?>
                            <li>
                                <a href="#" class="ulz-button ulz--fb" data-action="sign-in-facebook">
                                    <span><?php esc_html_e( 'Continue with Facebook', 'utillz-core' ); ?></span>
                                    <?php Ucore()->preloader(); ?>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>

                <div class="ulz-signin-or">
                    <span><?php esc_html_e( 'OR', 'utillz-core' ); ?></span>
                </div>

                <div class="ulz-grid">

                    <div class="ulz-form-group ulz-col-12">
                        <input type="text" name="username" value="" placeholder="<?php esc_html_e( 'Username', 'utillz-core' ); ?>">
                    </div>

                    <div class="ulz-form-group <?php echo boolval( $enable_signup_phone ) ? 'ulz-col-6 ulz-col-sm-12' : 'ulz-col-12'; ?>">
                        <input type="text" name="email" value="" placeholder="<?php esc_html_e( 'Email', 'utillz-core' ); ?>">
                    </div>

                    <?php if( $enable_signup_phone ): ?>
                        <div class="ulz-form-group ulz-col-6 ulz-col-sm-12">
                            <input type="text" name="phone" value="" placeholder="<?php esc_html_e( 'Phone number', 'utillz-core' ); ?>">
                        </div>
                    <?php endif; ?>

                    <div class="ulz-form-group ulz-col-6 ulz-col-sm-12">
                        <input type="text" name="first_name" value="" placeholder="<?php esc_html_e( 'First name', 'utillz-core' ); ?>">
                    </div>
                    <div class="ulz-form-group ulz-col-6 ulz-col-sm-12">
                        <input type="text" name="last_name" value="" placeholder="<?php esc_html_e( 'Last name', 'utillz-core' ); ?>">
                    </div>
                    <?php if( get_option('ulz_enable_standard_pass') ): ?>
                        <div class="ulz-form-group ulz-col-6 ulz-col-sm-12">
                            <input type="password" name="password" value="" placeholder="<?php esc_html_e( 'Password', 'utillz-core' ); ?>">
                        </div>
                        <div class="ulz-form-group ulz-col-6 ulz-col-sm-12">
                            <input type="password" name="repeat_password" value="" placeholder="<?php esc_html_e( 'Repeat password', 'utillz-core' ); ?>">
                        </div>
                    <?php endif; ?>

                    <?php
                    // $enable_signup_terms = get_option('ulz_enable_signup_terms');
                    // $signup_terms_text = get_option('ulz_signup_terms_text');
                    ?>

                    <?php if( $enable_signup_terms ): ?>
                        <div class="ulz-form-group ulz-col-12">
                            <label class="ulz-checkbox ulz-no-select ulz-mt-0">
                                <input type="checkbox" value="1" name="terms">
                                <span class="ulz--toggle ulz-transition"></span>
                                <span class="ulz--text ulz--collect"><?php echo wp_kses_post( html_entity_decode( Ucore()->format_url( $signup_terms_text ) ) ); ?></span>
                            </label>
                        </div>
                    <?php endif; ?>

                    <div class="ulz-form-group ulz-inline-group ulz-col-12">
                        <button type="submit" class="ulz-button ulz-button-accent ulz-block ulz-w-100 ulz-modal-button">
                            <span><?php esc_html_e( 'Create account', 'utillz-core' ); ?></span>
                            <?php Ucore()->preloader(); ?>
                        </button>
                    </div>
                    <div class="ulz-signin-errors">
                        <!-- output -->
                    </div>
                    <div class="ulz-signin-success">
                        <?php esc_html_e( 'Your account has been created. Please check your email for more details.', 'utillz-core' ); ?>
                    </div>
                    <?php if( ! get_option('ulz_enable_standard_pass') ): ?>
                    <div class="ulz-form-group ulz-col-12 ulz-text-center">
                        <p class="ulz-mb-0"><?php esc_html_e( 'A password will be e-mailed to you', 'utillz-core' ); ?></p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </form>
    <?php endif; ?>

    <form class="ulz-form ulz-signin-section" data-id="reset-password">
        <input type="submit" value="" class="ulz-none">
        <div class="ulz-grid">
            <div class="ulz-form-group ulz-col-12">
                <p><?php esc_html_e( 'Please enter your email address. You will receive a link to create a new password via email.', 'utillz-core' ); ?></p>
                <input type="text" name="email" value="" placeholder="<?php esc_html_e( 'Email', 'utillz-core' ); ?>">
            </div>
            <div class="ulz-form-group ulz-inline-group ulz-col-12">
                <button type="submit" class="ulz-button ulz-button-accent ulz-block ulz-w-100 ulz-modal-button">
                    <span><?php esc_html_e( 'Reset password', 'utillz-core' ); ?></span>
                    <?php Ucore()->preloader(); ?>
                </button>
            </div>
            <div class="ulz-signin-errors">
                <!-- output -->
            </div>
            <div class="ulz-signin-success">
                <?php esc_html_e( 'Please check your email for more details.', 'utillz-core' ); ?>
            </div>
        </div>
    </form>
</div>

<div class="ulz-modal-footer ulz--top-border ulz-text-center">
    <a href="#" class="ulz-button ulz-width-100 ulz-button-accent ulz--large ulz-modal-button" data-action="">
        <span><?php esc_html_e( 'Sign in', 'utillz-core' ); ?></span>
        <?php Ucore()->preloader(); ?>
    </a>
</div>
