<?php

defined('ABSPATH') || exit;

global $ulz_explore;

$pagination_type = $ulz_explore->get_pagination_type();
$is_last = $ulz_explore->query->posts->max_num_pages <= $ulz_explore->query->page;

?>

<?php if( $pagination_type == 'more' || $pagination_type == 'infinity' ): ?>

    <div class="ulz-load-more"<?php if( $pagination_type == 'infinity' ): ?> data-action="infinity-scroll"<?php endif; ?>>
        <a href="#" class="ulz-button ulz--large<?php if( $is_last ) { echo ' ulz--disabled'; } ?>"<?php if( ! $is_last ): ?> data-action="load-more"<?php endif; ?> data-page="<?php echo (int) $ulz_explore->query->page; ?>">
            <?php if( ! $is_last ): ?>
                <span><?php esc_html_e('Load more', 'utillz-core'); ?></span>
            <?php else: ?>
                <span><?php esc_html_e('Nothing else to load', 'utillz-core'); ?></span>
            <?php endif; ?>
            <?php Ucore()->preloader(); ?>
        </a>
    </div>

<?php else: ?>

    <div class="ulz-paging">
        <?php


            if( get_post_type() == 'ulz_collection' ) {
                $base = get_permalink();
            }else{
                $base = Ucore()->get_explore_page_url();
            }

            echo Ucore()->pagination([
                'base' => add_query_arg( [ 'onpage' => '%#%' ], $base ),
                'format' => '?onpage=%#%',
                'current' => $ulz_explore->query()->page,
                'total' => $ulz_explore->query()->posts->max_num_pages,
            ]);

        ?>
    </div>

<?php endif; ?>
