<?php

defined('ABSPATH') || exit;

global $ulz_show_tags;
$ulz_show_tags = true;

$request = \UtillzCore\Inc\Src\Request\Request::instance();
$page = $request->has('onpage') ? $request->get('onpage') : 1;
$posts_per_page = 12;
$offset = ( $page - 1 ) * $posts_per_page;

$collections = new \WP_Query([
    'post_type' => 'ulz_collection',
    'post_status' => 'publish',
    'posts_per_page' => $posts_per_page,
    'offset' => $offset,
]);

?>

<?php if( $collections->have_posts() ): ?>

    <div class="ulz-collections ulz-collections--stack">
        <div class="ulz--inner">
            <?php while( $collections->have_posts() ) : $collections->the_post(); ?>
                <?php get_template_part( 'templates/collection', apply_filters('utillz/page/collections/template', '' ) ); ?>
            <?php endwhile; wp_reset_postdata(); ?>
        </div>
    </div>

    <?php if( $collections->max_num_pages > 1 ): ?>
        <div class="ulz-paging">
            <?php
                echo Ucore()->pagination([
                    'format' => '?onpage=%#%',
                    'current' => $page,
                    'total' => $collections->max_num_pages,
                ]);
            ?>
        </div>
    <?php endif; ?>

<?php else: ?>
    <p><strong><?php esc_html_e( 'No collections were found', 'utillz-enhance' ) ?></strong></p>
<?php endif; ?>
