<?php

$pre_defined = Ucore()->get_pre_defined();

?>

<div class="ulz-outer">
    <div class="ulz-modal ulz-modal-field-ids" data-id="field-ids">
        <?php Ucore()->the_template('modals/close'); ?>
        <div class="ulz-modal-heading ulz--border">
            <h4 class="ulz--title"><?php esc_html_e( 'Field ids', 'utillz-core' ); ?></h4>
        </div>
        <div class="ulz-modal-content">
            <div class="ulz-modal-container ulz-scrollbar">
                <p>
                    <?php esc_html_e('You can use different ids to retrieve specific information. Use the ids you defined in the custom fields, or the pre-defined.', 'utillz-core'); ?>
                </p>
                <p>
                    <u><?php esc_html_e('Custom fields', 'utillz-core'); ?></u>:
                </p>
                <?php
                    if( get_post_type() == 'ulz_listing_type' ) {
                        global $pagenow;
                        if( $pagenow == 'post.php' ) {
                            echo '<ul>';
                                foreach( Ucore()->jsoning( 'ulz_fields' ) as $k => $item ) {
                                    if( ! isset( $item->fields->key ) || in_array( $item->fields->key, $pre_defined ) ) {
                                        continue;
                                    }
                                    ?><li><?php echo esc_attr( Ucore()->unprefix( $item->fields->key ) ); ?></li><?php
                                }
                            echo '</ul>';
                        }
                    }
                ?>
                <p>
                    <u><?php esc_html_e('Pre-defined fields', 'utillz-core'); ?></u>:
                </p>
                <ul>
                    <?php echo '<li>' . implode( '</li><li>', $pre_defined ) . '</li>'; ?>
                </ul>
            </div>
        </div>
    </div>
</div>
