<?php

use \UtillzCore\Inc\Src\Listing\Listing;

defined('ABSPATH') || exit;

global $post;

class Panel {
    private $form;

    public function getForm() {
        return $this->form;
    }
}

// In your code
$panel = \UtillzCore\Inc\Src\Admin\Panel::instance();
$form = $panel->getForm();

$listing = new Listing( Ucore()->get('ulz_listing_id') );

$action_type = $listing->type->get_action_type('report');
$report_fields = [];

if( isset( $action_type->fields->fields ) && $action_type->fields->fields ) {
    foreach( $action_type->fields->fields as $field ) {
        $report_fields[ $field->fields->key ] = $field->fields->name;
    }
}

?>

<div class="ulz-panel ulz-outer">
    <div class="ulz-section">
        <div class="ulz-form ulz-grid">
            <?php

                if( $report_fields ) {
                    $form->render([
                        'type' => 'radio',
                        'id' => 'ulz_report_reason',
                        'options' => $report_fields,
                        'class' => [ 'ulz-mb-0' ]
                    ]);
                }else{
                    echo '<p class="ulz-mb-0">' . esc_html__('No report fields were found. Please edit your report action type to add some.', 'utillz-core') . '</p>';
                }

            ?>
        </div>
    </div>
</div>
