<?php

defined('ABSPATH') || exit;

use \UtillzCore\Inc\Src\Form\Component as Form;

global $comment;

$form = new Form( Form::Storage_Comment );

$listing_type_id = Ucore()->get( 'ulz_listing_type', $comment->comment_post_ID );
$ratings = Ucore()->jsoning( 'ulz_review_ratings', $listing_type_id );
$comment_ratings = get_comment_meta( $comment->comment_ID, 'ulz_ratings', true );
$comment_review_average = get_comment_meta( $comment->comment_ID, 'ulz_rating_average', true );

?>

<div class="ulz-panel ulz-outer">
    <div class="ulz-section">
        <div class="ulz-form">

            <table class="ulz-table ulz-mb-3">
                <thead>
                    <tr>
                        <th><?php esc_html_e( 'Comment details', 'utillz-core' ); ?></th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?php esc_html_e( 'Average review score', 'utillz-core' ); ?></td>
                        <td><?php echo number_format( floatval( $comment_review_average ), 2 ); ?></td>
                    </tr>
                </tbody>
            </table>

            <?php

                wp_nonce_field( 'utillz_comment', 'utillz_review_comment_nonce' );

                if( $ratings ) {
                    foreach( $ratings as $key => $rating ) {

                        $comment_rating_value = 0;
                        if( array_key_exists( $rating->fields->key, $comment_ratings ) ) {
                            $comment_rating_value = (int) $comment_ratings[ $rating->fields->key ];
                        }

                        $field = $form->create([
                            'type' => 'number',
                            'id' => sprintf( 'rating_%s', $rating->fields->key ),
                            'name' => $rating->fields->name,
                            'input_type' => 'stepper',
                            'format' => '%s',
                            'min' => 0,
                            'max' => 5,
                        ]);

                        $field->props->value = $comment_rating_value;
                        echo $field->get();

                    }
                }else{
                    $form->render([
                        'type' => 'heading',
                        'description' => esc_html__('No review criteria were found', 'utillz-core'),
                    ]);
                }

                $form->render([
                    'type' => 'upload',
                    'id' => 'gallery',
                    'name' => esc_html__( 'Media', 'utillz-core' ),
                    'multiple_upload' => true,
                ]);

            ?>

            <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                <button type="submit" class="ulz-button ulz--large">
                    <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                </button>
            </div>

        </div>
    </div>
</div>
