<?php

namespace UtillzCore\Inc\Utils;

use \UtillzCore\Inc\Src\Notification\Base as Notification;

class Notify {

    use \UtillzCore\Inc\Src\Traits\Singleton;

    /*protected function get_namespace( $id ) {

        $namespace = sprintf( '\UtillzCore\Inc\Src\Notification\Notifications\%s', str_replace( '-', '_', $id ) );

        if( class_exists( $namespace ) ) {
            return $namespace;
        }

        return null;

    }*/

    /*
     * attempt to notify through channels
     *
     */
    public function distribute( $id, $args, $params = [] ) {

        $notifications = Notification::get_notifications();
        $id = str_replace( '_', '-', $id );

        if( array_key_exists( $id, $notifications ) ) {
            $notification = new $notifications[ $id ]( $args, $params );
            $notification->send();
        }

    }

    /*
     * get user current active site notifications
     *
     */
    public function get_active_site( $user_id = null ) {

        global $wpdb;

        if( is_null( $user_id ) ) {
            $user_id = get_current_user_id();
        }

        // check if user exists
        if( get_userdata( $user_id ) === false ) {
            return;
        }

        return $wpdb->get_var( $wpdb->prepare("
            SELECT COUNT(*)
            FROM {$wpdb->prefix}utillz_notifications
            WHERE user_id = %d
            AND active = 1
        ", $user_id ) );

    }

    /*
     * get user latest site notifications
     *
     */
    public function get_latest_site( $page = 1, $user_id = null, $num = 10, $active = false ) {

        global $wpdb;

        if( is_null( $user_id ) ) {
            $user_id = get_current_user_id();
        }

        // check if user exists
        if( get_userdata( $user_id ) === false ) {
            return [];
        }

        $notifications = Notification::get_notifications();

        $active_sql = $active ? 'AND active = 1' : '';

        $results = $wpdb->get_results( $wpdb->prepare("
            SELECT *,
            CONVERT_TZ( created_at, @@session.time_zone, '+00:00' ) AS `created_utc`
            FROM {$wpdb->prefix}utillz_notifications
            WHERE user_id = %d
            $active_sql
            ORDER BY created_at DESC
            LIMIT $num
            OFFSET " . ( ( $page - 1 ) * $num ) . "
        ", $user_id ), OBJECT );

        $found = $wpdb->get_var( $wpdb->prepare("
            SELECT COUNT(*)
            FROM {$wpdb->prefix}utillz_notifications
            WHERE user_id = %d
            $active_sql
            ORDER BY created_at DESC
        ", $user_id ) );

        $site = [];

        foreach( $results as &$row ) {

            // get message content
            if( array_key_exists( $row->code, $notifications ) ) {
                $notification = new $notifications[ $row->code ]( $row );
                $site[] = (object) array_merge( $notification->get_site(), [
                    'active' => $row->active,
                    'created_at' => $row->created_at,
                    'created_utc' => $row->created_utc
                ]);
            }

        }

        return (object) [
            'site' => $site,
            'found' => (int) $found,
        ];

    }

    public function mark_site_as_read( $user_id = null ) {

        global $wpdb;

        if( is_null( $user_id ) ) {
            $user_id = get_current_user_id();
        }

        // check if user exists
        if( get_userdata( $user_id ) === false ) {
            return;
        }

        $results = $wpdb->query(
            $wpdb->prepare("
                    UPDATE {$wpdb->prefix}utillz_notifications SET active = 0 WHERE user_id = %d
                ",
                $user_id
            )
        );

    }

    public function clear_all_notification($user_id = null) {
    global $wpdb;

    if (is_null($user_id)) {
        $user_id = get_current_user_id();
    }

    // Check if user exists
    if (get_userdata($user_id) === false) {
        return;
    }

    $table_name = $wpdb->prefix . 'utillz_notifications';

    // Delete all notifications for the specified user from the table
    $wpdb->delete($table_name, array('user_id' => $user_id));
}

}
