<?php

namespace UtillzCore\Inc\Src\Woocommerce\Products;

use \UtillzCore\Inc\Src\Traits\Singleton;

class Init {

    use Singleton;

    function __construct() {

        add_action( 'init', [ $this, 'register_packages' ] );

        // wc register products types
        add_filter( 'product_type_selector', [ $this, 'add_type' ] );

        // wc product meta template
        add_action( 'woocommerce_product_options_general_product_data', array( $this, 'product_data' ) );

        // wc save product data
        add_action( 'woocommerce_process_product_meta_listing_plan', array( $this, 'save_listing_plan_data' ) );
        add_action( 'woocommerce_process_product_meta_listing_promotion', array( $this, 'save_listing_promotion_data' ) );

    }

    public function register_packages() {

        if( class_exists('WC_Product') ) {
            require UTILLZ_CORE_PATH . 'inc/src/woocommerce/products/wc-product-listing-plan.php';
            require UTILLZ_CORE_PATH . 'inc/src/woocommerce/products/wc-product-listing-promotion.php';
            require UTILLZ_CORE_PATH . 'inc/src/woocommerce/products/wc-product-listing-purchase.php';
        }

        if( class_exists('WC_Product_Subscription') ) {
            require UTILLZ_CORE_PATH . 'inc/src/woocommerce/products/wc-product-listing-subscription-plan.php';
        }

    }

    public function add_type( $types ) {

        $types['listing_plan'] = esc_html__( 'Listing Plan', 'utillz-core' );
        $types['listing_promotion'] = esc_html__( 'Listing Promotion', 'utillz-core' );
        $types['listing_purchase'] = esc_html__( 'Listing Purchase', 'utillz-core' );

        if( class_exists('WC_Product_Subscription') ) {
            $types['listing_subscription_plan'] = esc_html__( 'Listing Subscription Plan', 'utillz-core' );
        }

        return $types;

    }

    public function product_data() {

        Ucore()->the_template('admin/woocommerce/product-listing-plan');
        Ucore()->the_template('admin/woocommerce/product-listing-promotion');
        Ucore()->the_template('admin/woocommerce/product-listing-purchase');

        if( class_exists('WC_Product_Subscription') ) {
            Ucore()->the_template('admin/woocommerce/product-listing-subscription-plan');
        }

	}

    public function save_listing_plan_data( $post_id ) {

        global $wpdb;

		$meta_save = [
			'_ulz_plan_duration',
			'_ulz_plan_limit',
			'_ulz_plan_priority',
			'_ulz_plan_disable_repeat_purchase',
		];

        $data = (object) Ucore()->sanitize( $_POST );
		foreach( $meta_save as $meta_key ) {
			update_post_meta( $post_id, $meta_key, isset( $data->{$meta_key} ) ? $data->{$meta_key} : '' );
		}

	}

    public function save_listing_promotion_data( $post_id ) {

        global $wpdb;

		$meta_save = [
			'_ulz_promotion_duration',
			'_ulz_promotion_priority',
		];

        $data = (object) Ucore()->sanitize( $_POST );

		foreach( $meta_save as $meta_key ) {
			update_post_meta( $post_id, $meta_key, isset( $data->{$meta_key} ) ? $data->{$meta_key} : '' );
		}

    }

}
