<?php

namespace UtillzCore\Inc\Src\Woocommerce\Account;

use \UtillzCore\Inc\Src\Form\Component as Form;
use \UtillzCore\Inc\Src\Wallet;
use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Traits\Singleton;

class Account {

    use Singleton;

    public $pages = [];

    function __construct() {

        add_action('init', [ $this, 'actions' ]);
        add_action('init', [ $this, 'add_endpoints' ]);

        add_action('utillz/account/actions', [ $this, 'account_actions' ]);
        add_action('utillz/account/notifications/update', [ $this, 'account_notifications_update' ]);

        add_filter('woocommerce_account_menu_items', [ $this, 'new_menu_items' ]);
        add_action('woocommerce_after_my_account', [ $this, 'account_dashboard' ]);


    }

    public function actions() {
        do_action('utillz/account/actions');
    }

    public function account_dashboard() {
        Ucore()->the_template('account/dashboard/dashboard');
    }

    public function add_page( $page ) {
        $this->pages[ $page['endpoint'] ] = $page;
    }

    public function new_menu_items( $items ) {

		$logout = $items['customer-logout'];
		unset( $items['customer-logout'] );

		$items += array_column( array_filter( $this->pages, function( $page ) {
			return $page['show_in_menu'];
		}), 'title', 'endpoint');

		$items['customer-logout'] = $logout;

		foreach( $items as $key => $item ) {

            if ( in_array( $key, array_keys( $this->pages ) ) ) {
				$items[ $key ] = $this->pages[ $key ];
			}

            $nav_menu_items = self::get_nav_menu_items();
            if( isset( $nav_menu_items[ $key ] ) ) {
                $items[ $key ] = $nav_menu_items[ $key ];
            }

		}

		$items = $this->sort_by_prop( $items, 'order' );
        $output = [];

		foreach( $items as $key => $item ) {
			if ( is_array( $item ) && ! empty( $item['title'] ) ) {
				$output[ $key ] = $item['title'];
			}
		}

		return $output;

    }

    public function sort_by_prop( $array, $prop_name, $reverse = false ) {

		$sorted = [];

		foreach ( $array as $itemKey => $item ) {

            if ( ! is_array( $item ) ) {
				$item = [ 'title' => $item, 'order' => 25, 'endpoint' => $itemKey ];
			}

			if ( ! isset( $item[ $prop_name ] ) ) {
				$item[ $prop_name ] = 25;
			}

			if ( ! isset( $item[ 'endpoint' ] ) ) {
				$item[ 'endpoint' ] = $itemKey;
			}

			$sorted[ $item[ $prop_name ] ][] = $item;

		}

		$reverse ? krsort( $sorted ) : ksort( $sorted );

		$result = [];
		foreach ( $sorted as $sub_array ) foreach ( $sub_array as $item ) {
			$result[ $item['endpoint'] ] = $item;
		}

		return $result;
	}

    public function add_endpoints() {

		foreach( $this->pages as $page ) {

			add_rewrite_endpoint( $page['endpoint'], EP_ROOT | EP_PAGES );

			add_action(
				sprintf( 'woocommerce_account_%s_endpoint', $page['endpoint'] ),
				function() use ( $page ) {

                    global $post, $wpdb;

                    do_action( 'utillz/account/actions' );

                    $request = Request::instance();

                    if( $request->has('action') ) {

                        switch( $request->get('action') ) {
                            case 'cancel_payout':

                                if( apply_filters( 'utillz/account/payout/enable_cancellation', true ) ) {

                                    if( ! wp_verify_nonce( $request->get('_wpnonce'), 'utillz_account_cancel_payout' ) ) {
                                        return;
                                    }

                                    $payout_id = (int) $request->get('id');

                                    if( $payout_id ) {

                                        $payout = $wpdb->get_row( $wpdb->prepare("
                                            SELECT *
                                            FROM {$wpdb->prefix}utillz_wallet_payouts
                                            WHERE id = %d
                                            and status = 'pending'
                                            AND user_id = %d
                                            LIMIT 1
                                        ", $payout_id, get_current_user_id() ), OBJECT );

                                        if( $payout ) {

                                            // add to owner wallet
                                            $wallet = new Wallet( $payout->user_id );
                                            $wallet->add_funds( $payout->amount, null, 'canceled_payout' );

                                            // delete payout row
                                            $wpdb->delete( $wpdb->prefix . 'utillz_wallet_payouts', [ 'id' => $payout->id ] );

                                        }

                                    }
                                }

                            Ucore()->the_template( $page['template'] );
                            break;

                        }

                    }else{

                        Ucore()->the_template( $page['template'] );

                    }
				}
			);
		}
	}

	static function get_listings() {
        $request = Request::instance();
        $page = $request->has('onpage') ? $request->get('onpage') : 1;
        
        // Check if 'ulz_filter_listing_type' key exists in $_GET
        $type_lis = isset($_GET['ulz_filter_listing_type']) ? $_GET['ulz_filter_listing_type'] : null;
        $post_status = isset($_GET['ulz_filter_listing_status']) ? $_GET['ulz_filter_listing_status'] : null;
        
        $posts_per_page = 12;

        $args = array(
            'post_type' => 'ulz_listing',
            'post_status' => $post_status,
            'author' => get_current_user_id(),
            'posts_per_page' => $posts_per_page,
            'offset' => ( $page - 1 ) * $posts_per_page,
            'meta_key' => 'ulz_listing_type',
            'meta_value' => $type_lis, // Assign $type_lis which may be null
        );

        return new \WP_Query($args);
    }


    static function get_entries( $type = 'ingoing' ) {

        $request = Request::instance();
        $page = $request->has('onpage') ? $request->get('onpage') : 1;
        $posts_per_page = 12;

        $args = [
            'post_type' => 'ulz_entry',
            'post_status' => [ 'publish', 'pending', 'pending_payment', 'declined'/*, 'cancelled'*/ ],
            'posts_per_page' => $posts_per_page,
            'offset' => ( $page - 1 ) * $posts_per_page,
        ];

        // outgoing
        if( $type == 'outgoing' ) {
            $args['meta_query'] = [
                [
                    'key' => 'ulz_request_user_id',
                    'value' => get_current_user_id(),
                    'compare' => '=',
                ]
            ];
        }
        // ingoing
        else{
            $args['author'] = get_current_user_id();
        }

        return new \WP_Query( $args );

    }

    static public function account_actions() {

        $request = Request::instance();

        if( $request->has('action') ) {
            switch( $request->get('action') ) {
                case 'delete_listing':

                    do_action('utillz/account/lising/before_delete');

                    // security
                    if( wp_verify_nonce( $request->get('_wpnonce'), 'utillz_account_listing_action' ) ) {
                        $post = get_post( (int) $request->get('id') );

                        // delete only own items
                        if( $post && $post->post_author == get_current_user_id() ) {

                            // only listing post types
                            if( get_post_type( $post->ID ) == 'ulz_listing' ) {
                                wp_trash_post( $post->ID );
                            }
                        }
                    }
					
					   if( class_exists('woocommerce') ) {
                        wp_redirect( wc_get_account_endpoint_url('listings') );
                        exit;
                    }
					       
                 case 'listing_status_change':
                        // security
                        if( wp_verify_nonce( $request->get('_wpnonce'), 'utillz_account_listing_action_status' ) ) {
                            $post = get_post( (int) $request->get('id') );
    
                            // status change only own items
                            if( $post and $post->post_author == get_current_user_id() ) {
    
                                // only listing post types

                                $listing_status = $request->get('status');
                               
                                if( get_post_type( $post->ID ) == 'ulz_listing' ) {

                                    if($listing_status == "publish"){
                                        if (isset($_POST['post_date'])) {
        $post_date = $_POST['post_date'];
    } else {
        $post_date = current_time('mysql'); // Use current time if post_date is not set
    }

    $update_listing_status = array(
        'post_type' => 'ulz_listing',
        'ID' => $post->ID,
        'post_status' => 'pending_listing',
        'edit_date' => true,
        'post_date' => $post_date
    );

    wp_update_post($update_listing_status);
                                }else{
                                $update_listing_status = array(
                                'post_type' => 'ulz_listing',
                                'ID' => $post->ID,
                                'post_status' => 'publish',
                                'edit_date' => true,
                                );

                    if (isset($_POST['post_date'])) {
                    $update_listing_status['post_date'] = $_POST['post_date'];
                    }

                        wp_update_post($update_listing_status);
                                }
                                  
                                }
                            }
                        }
                 
                         if( class_exists('woocommerce') ) {
                        wp_redirect( wc_get_account_endpoint_url('listings') );
                        exit;
                    }

                    break;
            }
        }

    }

    public function account_notifications_update() {

        if( isset( $_POST ) && is_array( $_POST ) ) {
            foreach( $_POST as $field_id => $field_value ) {
                if( strpos( $field_id, 'ulz_is_user_notification_' ) === 0 ) {
                    update_user_meta( get_current_user_id(), $field_id, ! $field_value );
                }
            }
        }

    }

    public static function get_nav_menu_items() {

        return apply_filters('utillz/account/new-menu-items', [
            'dashboard' => [
                'title' => esc_html__('Dashboard', 'utillz-core'),
                'order' => 1
            ],
            'listings' => [
                'title' => esc_html__('Listings', 'utillz-core'),
                'order' => 4
            ],
            'entries' => [
                'title' => esc_html__('Entries', 'utillz-core'),
                'order' => 5
            ],
            'assets' => [
                'title' => esc_html__('Assets', 'utillz-core'),
                'order' => 6
            ],
            'messages' => [
                'title' => esc_html__('Messages', 'utillz-core'),
                'order' => 7
            ],
            'payouts' => [
                'title' => esc_html__('Payouts', 'utillz-core'),
                'order' => 8
            ],
            'notification-settings' => [
                'title' => esc_html__('Notifications', 'utillz-core'),
                'order' => 9
            ],
        ]);

    }

    public static function get_nav_menu_icons() {

        return apply_filters('utillz/account/navigation/icons', [
        	'dashboard' => 'dashboard',
        	'listings' => 'place',
        	'messages' => 'chat',
        	'entries' => 'add_circle',
        	'downloads' => 'file_download',
        	'payouts' => 'account_balance_wallet',
        	'notification-settings' => 'notifications',
        	'orders' => 'library_add_check',
        	'downloads' => 'download',
        	'subscriptions' => 'hourglass_top',
        	'payment-methods' => 'payments',
        	'edit-address' => 'business',
        	'edit-account' => 'style',
        	'customer-logout' => 'lock',
        ]);

    }

    public static function get_account_title() {

        global $wp_query;

        foreach( self::get_nav_menu_items() as $nav_key => $nav_menu_item ) {
            if( isset( $wp_query->query_vars[ $nav_key ] ) ) {
                return $nav_menu_item['title'];
            }
        }

    }

}