<?php

namespace UtillzCore\Inc\Src\Submission;

use \UtillzCore\Inc\Src\Listing_Type\Listing_Type;
use \UtillzCore\Inc\Src\Explore\Explore;
use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Traits\Singleton;

class Submission {

    public $request;
    public $component;

    public $id;
    public $listing_type;

    public $tabs;

    function __construct( $id = null ) {

        global $ulz_explore;

        $this->request = Request::instance();
        $this->component = new Component();

        // type passed
        if( $id ) {
            $this->id = $id;
        }
        // type from request
        elseif( ! $this->request->is_empty('type') ) {
            $this->id = $this->request->get('type');
        }
        // get single type
        elseif( $ulz_explore->total_types == 1 ) {
            $this->id = $ulz_explore->type->id;
        }

        $this->listing_type = new Listing_Type( $this->id );

        // not a valid listing type, redirect somewhere safe
        if( Ucore()->is_submission() && $ulz_explore->request->has('type') && ! $this->listing_type->id ) {
            $submission_page = Ucore()->get_submission_page_url();
            die( wp_redirect( $submission_page ? $submission_page : get_home_url() ) );
        }

        $this->tabs = $this->component->tabs(
            Ucore()->jsoning( 'ulz_fields', $this->listing_type->id )
        );

    }

    public function is_missing_type() {

        global $ulz_explore;
        return $ulz_explore->total_types > 1 && $ulz_explore->request->is_empty('type');

    }

    public function get_listing_types() {

        return new \WP_Query([
            'post_status' => 'publish',
            'post_type' => 'ulz_listing_type',
            'posts_per_page' => 10
        ]);

    }

}
