<?php

namespace UtillzCore\Inc\Src\Submission\Modules\Select_Plan;

use \UtillzCore\Inc\Src\Submission\Modules\Module;
use \UtillzCore\Inc\Src\Request\Custom_Request;
use \UtillzCore\Inc\Src\Validation;
use \UtillzCore\Inc\Src\Woocommerce\Packages\Plan;

class Select_Plan extends Module {

    public function controller() {

        global $ulz_submission;

        return [
            'products' => $ulz_submission->listing_type->get_wc_packages(),
            'strings' => (object) [
                'select_plan' => esc_html__('Select a plan', 'utillz-core'),
                'most_popular' => esc_html__('Most popular', 'utillz-core'),
                'unlimited' => esc_html__('Unlimited submissions available', 'utillz-core'),
                'available_submission' => esc_html__('%s submission available', 'utillz-core'),
                'available_submissions' => esc_html__('%s submissions available', 'utillz-core'),
                'owned' => esc_html__('Plan owned', 'utillz-core'),
                'no_packages' => esc_html__('There are no packages available for this listing type', 'utillz-core'),
            ]
        ];

    }

    public function validation() {

        $request = new Custom_Request('input');

        $validation = new Validation();
		$response = $validation->validate( $request->params, [
            'ulz_plan' => 'required'
        ]);

        if( $response->success ) {

            $plan = new Plan( $request->get('ulz_plan') );

            if( $plan->is_limit_reached() ) {
                wp_send_json([
                    'success' => false,
                    'errors' => [
                        'ulz_plan' => esc_html__( 'The plan limit has been reached', 'utillz-core' )
                    ]
                ]);
            }

        }else{
            $response->errors['ulz_plan'] = esc_html__( 'Please select a plan', 'utillz-core' );
        }

        return $response;

    }

}
