<?php

namespace UtillzCore\Inc\Src\Submission;

use \UtillzCore\Inc\Src\Traits\Singleton;
use \UtillzCore\Inc\Extensions\Component\Component as Main_Component;

class Component extends Main_Component {

    use Singleton;

    public function tabs( $items ) {

        $current_tab_key = 0;

        if( ! isset( $items[0] ) || $items[0]->template->id !== 'tab' ) {
            $tabs = [
                $current_tab_key => [
                    'title' => apply_filters( 'utillz/submission/tab-general-text', esc_html__( 'General', 'utillz-core' ) ),
                    'icon' => apply_filters( 'utillz/submission/tab-general-icon', [
                        (object) [
                            'set' => 'material-icons',
                            'icon' => 'text_fields',
                        ]
                    ]),
                    'content' => []
                ]
            ];
        }

        foreach( $items as $item ) {
            if( $item->template->id == 'tab' ) {
                $current_tab_key++;
                $tabs[ $current_tab_key ]['title'] = $item->fields->{ $item->template->heading };
                $tabs[ $current_tab_key ]['icon'] = isset( $item->fields->icon ) ? $item->fields->icon : null;
                continue;
            }
            $tabs[ $current_tab_key ]['content'][] = $item;
        }

        return $tabs;

    }

}
