@if( is_array( $items ) && ! empty( $items ) )
    <div class="ulz-mod-listing ulz-mod-listing-menu" data-type="menu">
        @if( ! empty( $name ) )
            <h4>{{ $name }}</h4>
        @endif
        <div class="ulz-price-menu">
            @if( count( $items ) > 1 )
                <div class="ulz--tabs">
                    <ul>
                        @foreach( $items as $section_key => $section )
                            <li class="{{ $section_key == 0 ? 'ulz-active' : '' }}">
                                <a href="#">
                                    {{ $section->fields->name }}
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="ulz--sections">
                @foreach( $items as $section_key => $section )
                    <section class="ulz--section{{ $section_key == 0 ? ' ulz-active' : '' }}">
                        @if( $section->fields->items )
                            <ul>
                                @foreach( $section->fields->items as $item )
                                    @if( ! $item->fields->name ) @continue @endif
                                    <li class="{{ $item->fields->focus ? 'ulz--is-focus' : '' }}">
                                        @if( $item->fields->focus )
                                            <span class="ulz--focus">{{ $item->fields->focus }}</span>
                                        @endif
                                        <div class="ulz--heading">
                                            <div class="ulz--name">
                                                <h4>{{ $item->fields->name }}</h4>
                                            </div>
                                            <span class="ulz--price ulz-font-heading">
                                                {!! is_numeric( $item->fields->price ) ? Ucore()->format_price( $item->fields->price ) : $item->fields->price !!}
                                            </span>
                                        </div>
                                        @if( $item->fields->description )
                                            <div class="ulz--description">{{ $item->fields->description }}</div>
                                        @endif
                                    </li>
                                @endforeach
                            </ul>
                        @endif
                    </section>
                @endforeach
            </div>
        </div>
    </div>
@endif
