<?php

namespace UtillzCore\Inc\Src\Listing\Modules\Location;

use \UtillzCore\Inc\Src\Listing\Modules\Module;

class Location extends Module {

    public function controller() {

        $listing_type_id = Ucore()->get( 'ulz_listing_type' );

        $set = $icon = '';
        $icon_data = json_decode( Ucore()->get( 'ulz_icon', $listing_type_id ) );
        if( isset( $icon_data[0] ) ) {
            $set = $icon_data[0]->set;
            $icon = $icon_data[0]->icon;
        }

        return array_merge(
            [
                'show_address' => false,
            ],
            (array) $this->props,
            [
                'api_key' => ! empty( get_option('ulz_mapbox_access_token') ),
                'lat' => esc_attr( Ucore()->get('ulz_location__lat') ),
                'lng' => esc_attr( Ucore()->get('ulz_location__lng') ),
                'address' => esc_attr( Ucore()->get('ulz_location__address') ),
                'set' => $set,
                'icon' => $icon,
                'strings' => (object) [
                    'not_specified' => esc_html__('Location not specified', 'utillz-core'),
                    'no_api' => esc_html__('The map can\'t be loaded, please configure your map provider', 'utillz-core'),
                ]
            ]
        );

    }

}
