<?php

namespace UtillzCore\Inc\Src\Listing\Action\Modules\Purchase;

use \UtillzCore\Inc\Src\Listing\Action\Modules\Module;

class Purchase extends Module {

    public function wrapper() {
        return '<div class="ulz-mod-action ulz-mod-action-%1$s ulz-ajaxing" data-type="%1$s">%2$s</div>';
    }

    public function controller() {

        global $ulz_listing;

        $addon_label = $ulz_listing->type->get('ulz_addon_label');

        return array_merge( (array) $this->props, [
            'listing' => $ulz_listing,
            'price' => $ulz_listing->get_pricing(),
            'component' => $this->component,
            'allow_addons' => $ulz_listing->type->get('ulz_allow_addons'),
            'addon_label' => $addon_label ? $addon_label : esc_html__( 'Select services', 'utillz-core' ),
            'strings' => (object) [
                'label' => esc_html__( 'Purchase', 'utillz-core' )
            ]
        ]);

    }

}
