<?php

namespace UtillzCore\Inc\Src\Listing\Action\Modules\Location;

use \UtillzCore\Inc\Src\User;
use \UtillzCore\Inc\Src\Listing\Action\Modules\Module;

class Location extends Module {

    public function controller() {

        global $ulz_listing;

        $set = $icon = '';
        $icon_data = json_decode( $ulz_listing->type->get('ulz_icon') );
        if( isset( $icon_data[0] ) ) {
            $set = $icon_data[0]->set;
            $icon = $icon_data[0]->icon;
        }

        return array_merge( (array) $this->props, [
            'api_key' => ! empty( get_option('ulz_mapbox_access_token') ),
            'listing' => $ulz_listing,
            'lat' => $ulz_listing->get('ulz_location__lat'),
            'lng' => $ulz_listing->get('ulz_location__lng'),
            'set' => $set,
            'icon' => $icon,
            'strings' => (object) [
                'not_specified' => esc_html__('Location not specified', 'utillz-core'),
                'no_api' => esc_html__('The map can\'t be loaded, please configure your map provider', 'utillz-core'),
            ]
        ]);

    }

}
