<div class="ulz-mod-action ulz-mod-action-{{ $type }}" data-type="{{ $type }}">
    <div class="ulz-action-location">

        @if( $lat && $lng )

            <div class="ulz-action-map-holder">
                <div class="ulz-action-map" data-lat="{{ $lat }}" data-lng="{{ $lng }}">
                    @if( ! $api_key )
                        <span class="ulz-none">{{ $strings->no_api }}</span>
                    @endif
                </div>

                <div class="ulz-map-zoom">
                    <a href="#" class="ulz--zoom-in" data-action="explore-map-zoom-in"><i class="fas fa-plus"></i></a>
                    <a href="#" class="ulz--zoom-out" data-action="explore-map-zoom-out"><i class="fas fa-minus"></i></a>
                </div>
            </div>

            @if( $fields )
                <div class="ulz-bullets">
                    <ul>
                        @foreach( $fields as $field )

                            @php
                                $field_value = $listing->get( $field->fields->id )
                            @endphp

                            @if( $field_value )
                                <li>

                                    @if( isset( $field->fields->icon[0] ) )
                                        {!! utillz_core()->icon->get( $field->fields->icon[0]->icon, $field->fields->icon[0]->set ) !!}
                                    @endif

                                    @switch( $field->fields->type )

                                        @case('address')
                                            <a href="{{ add_query_arg([ 'api' => 1, 'query' => urlencode( esc_html( $field_value ) )], 'https://www.google.com/maps/search/' ) }}" target="_blank">
                                                {{ str_replace( '{field}', $field_value, $field->fields->format ) }}
                                            </a>
                                            @break

                                        @case('url')
                                            <a href="{{ esc_url( str_replace( '{field}', $field_value, $field->fields->format ) ) }}" target="_blank">
                                                @if( isset( $field->fields->type_url_label ) && ! empty( $field->fields->type_url_label ) )
                                                    {{ $field->fields->type_url_label }}
                                                @else
                                                    {{ str_replace( '{field}', $field_value, $field->fields->format ) }}
                                                @endif
                                            </a>
                                            @break

                                        @case('phone')
                                            <a href="tel:{{ $field_value }}" target="_blank">
                                                {{ str_replace( '{field}', $field_value, $field->fields->format ) }}
                                            </a>
                                            @break

                                        @case('email')
                                            <a href="mailto:{{ $field_value }}" target="_blank">
                                                {{ str_replace( '{field}', $field_value, $field->fields->format ) }}
                                            </a>
                                            @break

                                        @case('price')
                                            <span>
                                                {!! str_replace( '{field}', Ucore()->format_price( $field_value ), $item->fields->format ) !!}
                                            </span>
                                            @break

                                        @default
                                            <span>
                                                {{ str_replace( '{field}', $field_value, $field->fields->format ) }}
                                            </span>

                                    @endswitch

                                </li>
                            @endif

                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="ulz--marker ulz-none">
                <span class="ulz-mod-listing-marker">
                    {!! utillz_core()->icon->get( $icon, $set ) !!}
                </span>
            </div>

        @else

            <div class="ulz--empty">
                <i class="fas fa-map-marker-alt"></i>
                <p>{{ $strings->not_specified }}</p>
            </div>

        @endif

    </div>
</div>
