<?php

use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Form\Component as Form;
use \UtillzCore\Inc\Src\Form\Modules\Icon\Icon;

$request = Request::instance();
$form = new Form( Form::Storage_Field );

$set = $request->get('set');
if( empty( $set ) ) {
    $set = 'font-awesome';
}

?>

<div class="ulz-modal-container ulz-scrollbar">

    <div class="ulz-icon-content ulz-no-select">
        <div class="ulz--sidebar">
            <div class="ulz-radio-fieldset">

                <input type="hidden" name="set" value="<?php echo esc_attr( $set ); ?>">
                <input type="hidden" name="icon" value="<?php echo esc_attr( $request->get('icon') ); ?>">

                <?php $i = 0; foreach( Icon::get_sets() as $key => $name ): ?>
                    <label class="ulz-radio">
                        <input type="radio" name="ulz_icon_set" value="<?php echo esc_attr( $key ); ?>"<?php if( $set == $key ) { echo ' checked="checked"'; } ?>>
                        <i class="ulz-transition"></i>
                        <span><?php echo esc_html( $name ); ?></span>
                    </label>
                <?php $i++;endforeach; ?>

            </div>
        </div>
        <div class="ulz--content">

            <div class="ulz--header">

                <div class="ulz-form">
                    <div class="ulz-grid">

                        <?php

                            $form->render([
                                'type' => 'text',
                                'id' => 's',
                                'autocomplete' => 'off',
                                'class' => ['ulz-mb-0'],
                                'placeholder' => esc_html__('Search by icon ..', 'utillz-core')
                            ]);

                        ?>

                    </div>
                </div>

            </div>

            <div class="ulz--list">
                <p class="ulz--results" data-text="<?php echo esc_html__('%s matching results', 'utillz-core'); ?>"></p>
                <ul>
                    <?php echo implode( '', Icon::get_icons( $set, $request->get('icon') ) ); ?>
                </ul>
            </div>

        </div>
    </div>

</div>

<div class="ulz-modal-footer ulz--top-border ulz-text-center">
    <a href="#" class="ulz-button ulz-button-accent ulz-modal-button" data-action="icon-save">
        <span><?php esc_html_e( 'Select icon and close', 'utillz-core' ); ?></span>
        <?php Ucore()->preloader(); ?>
    </a>
</div>
