<?php

namespace UtillzCore\Inc\Src\Form\Modules\Collection;

use \UtillzCore\Inc\Src\Form\Modules\Module;

class Collection extends Module {

    public function before_construct() {
        $this->defaults += [
            'options' => [],
            'allow_empty' => false
        ];
    }

    public function after_build() {

        $this->id = 'ulz_collection';
        $this->props->id = 'ulz_collection';
        $this->props->single = false;

        $options = [];

        $query = new \WP_Query([
            'post_type' => 'ulz_collection',
            'status' => [ 'publish' ],
            'posts_per_page' => -1,
        ]);

        foreach( $query->posts as $collection ) {
            $options[ $collection->ID ] = $collection->post_title;
        }

        $this->props->options = $options;

    }

    public function wrapper() {
        return $this->template();
    }

    public function controller() {

        return [
            'props' => (array) $this->props,
            'component' => $this->component
        ];

    }

}
