@include('label.index')

<div class="ulz-checklist -x{{ $columns }}{{ $limit_height ? ' ulz--has-more' : '' }}">
    <div class="ulz--inner">
        <div class="ulz--content">
            @if( is_array( $options ) )
                @foreach ( $options as $option_key => $option_name )
                    <label class='ulz-checkbox ulz-no-select'>
                        <input type='checkbox' name="{{ $id }}[]" value="{{ $option_key }}" {{ ( is_array( $value ) && in_array( $option_key, $value ) ) ? 'checked' : '' }}>
                        <span class='ulz--toggle ulz-transition'></span>
                        @if( is_array( $option_name ) )
                            <span class="ulz--text ulz-flex ulz-space-between">
                                <span class="ulz-flex-1 ulz--collect">
                                    {{ $option_name[0] }}
                                </span>
                                <span class="ulz-ml-1 ulz-no-wrap">
                                    <strong>{!! $option_name[1] !!}</strong>
                                </span>
                            </span>
                        @else
                            <span class="ulz--text ulz--collect">{{ $option_name }}</span>
                        @endif
                    </label>
                @endforeach
            @endif
        </div>
        @if( $limit_height )
            <span class="ulz--shadow"></span>
            <div class="ulz--more">
                <a href="#">{{ $strings->show }}</a>
            </div>
        @endif
    </div>
</div>

{{-- fix for empty inputs in post --}}
<input name="{{ $id }}[]" type="hidden" value="" disabled>
