<?php

namespace UtillzCore\Inc\Src\Entry\Modules\Purchase;

use \UtillzCore\Inc\Src\Entry\Modules\Module;
use \UtillzCore\Inc\Src\Listing\Listing;
use \UtillzCore\Inc\Src\User;
use \UtillzCore\Inc\Src\Request\Request;

class Purchase extends Module {

    protected function get_data() {

        // entry
        $entry_id = get_the_ID();
        // listing
        $listing = new Listing( Ucore()->get('ulz_listing') );
        // user entry
        $user_entry_id = Ucore()->get('ulz_request_user_id');
        $user_entry_data = get_userdata( $user_entry_id );
        // user listing
        $user_listing_id = get_post_field( 'post_author', $entry_id );
        $user_listing_data = get_userdata( $user_listing_id );

        return [
            'form'                      => $this->component->form,
            'listing'                   => $listing,
            'user_entry_id'             => $user_entry_id,
            'user_entry_data'           => $user_entry_data,
            'user_listing_id'           => $user_listing_id,
            'user_listing_data'         => $user_listing_data,
            'date'                      => get_the_date( sprintf('%s %s', get_option('date_format'), get_option('time_format') ), $entry_id ),
            'order_id'                  => Ucore()->get('ulz_order_id'),
            'pricing'                   => json_decode( Ucore()->get('ulz_pricing') ),
        ];
    }

    protected function get_strings() {
        return [
            'general'               => esc_html__('General details', 'utillz-core'),
            'entry_user'            => esc_html__('User', 'utillz-core'),
            'entry_type_label'      => esc_html__('Entry type', 'utillz-core'),
            'entry_type'            => esc_html__('Purchase', 'utillz-core'),
            'listing'               => esc_html__('Listing', 'utillz-core'),
            'listing_author'        => esc_html__('Listing author', 'utillz-core'),
            'user'                  => esc_html__('User', 'utillz-core'),
            'order'                 => esc_html__('Order', 'utillz-core'),
            'date'                  => esc_html__('Date', 'utillz-core'),
            'purchase'              => esc_html__('Purchase', 'utillz-core'),
            'purchased_by'          => esc_html__('Purchased by', 'utillz-core'),
            'pricing_details'       => esc_html__('Pricing details', 'utillz-core'),
            'base_price'            => esc_html__('Base price', 'utillz-core'),
            'service_fee'           => esc_html__('Service fee', 'utillz-core'),
            'extra_service_total'   => esc_html__('Extra services total', 'utillz-core'),
            'payment'               => esc_html__('Payment', 'utillz-core'),
            'total'                 => esc_html__('Total', 'utillz-core'),
            'processing'            => esc_html__('Processing', 'utillz-core'),
        ];
    }

    public function admin() {
        return array_merge( (array) $this->props, $this->get_data(), [
            'strings' => (object) array_merge( $this->get_strings(), [])
        ]);
    }

    public function controller() {
        return array_merge( (array) $this->props, $this->get_data(), [
            'strings' => (object) array_merge( $this->get_strings(), [])
        ]);
    }

}
