<table class="ulz-table">
    @if( isset( $user_entry_data->display_name ) )
        <thead>
            <tr>
                <th>{{ $strings->general }}</th>
                <th>&nbsp;</th>
            </tr>
        </thead>
    @endif
    <tbody>
        <tr>
            <td>{{ $strings->entry_type_label }}</td>
            <td>{{ $strings->entry_type }}</td>
        </tr>
        <tr>
            <td>{{ $strings->listing }}</td>
            <td><a href="{{ get_edit_post_link( $listing->id ) }}">{{ $listing->get('post_title') }}</a></td>
        </tr>
        <tr>
            <td>{{ $strings->listing_author }}</td>
            <td><a href="{{ get_edit_user_link( $user_listing_id ) }}">{{ $user_listing_data->display_name }}</a></td>
        </tr>
        <tr>
            <td>{{ $strings->entry_user }}</td>
            <td><a href="{{ get_edit_user_link( $user_entry_id ) }}">{{ $user_entry_data->display_name }}</a></td>
        </tr>
        @if( $order_id )
            <tr>
                <td>{{ $strings->order }}</td>
                <td><a href="{{ get_edit_post_link( $order_id ) }}">#{{ $order_id }}</a></td>
            </tr>
        @endif
        @if( $listing->type->get('ulz_allow_pricing') && ! empty( $pricing ) )
            @if( isset( $pricing->base ) )
                <tr>
                    <td>{{ $strings->base_price }}:</td>
                    <td>{!! Ucore()->format_price( $pricing->base ) !!}</td>
                </tr>
            @endif
            @if( isset( $pricing->service_fee ) && ! empty( $pricing->service_fee ) )
                <tr>
                    <td>{{ $strings->service_fee }}:</td>
                    <td>{!! Ucore()->format_price( $pricing->service_fee ) !!}</td>
                </tr>
            @endif
            @if( isset( $pricing->extras ) && ! empty( $pricing->extras ) )
                @foreach( $pricing->extras as $extra )
                    <tr>
                        <td>{{ $extra->name }}:</td>
                        <td>
                            {!! Ucore()->format_price( $extra->price ) !!}
                        </td>
                    </tr>
                @endforeach
            @endif
            @if( isset( $pricing->addons ) && ! empty( $pricing->addons ) )
                @foreach( $pricing->addons as $addon )
                    <tr>
                        <td>{{ $addon->name }}:</td>
                        <td>
                            {!! Ucore()->format_price( $addon->price ) !!}
                        </td>
                    </tr>
                @endforeach
            @endif
            @if( isset( $pricing->extras_total ) && ! empty( $pricing->extras_total ) )
                <tr>
                    <td>{{ $strings->extra_service_total }}:</td>
                    <td>{!! Ucore()->format_price( $pricing->extras_total ) !!}</td>
                </tr>
            @endif
            @if( isset( $pricing->payment ) && isset( $pricing->payment_processing_name ) )
                <tr>
                    <td>{{ $strings->payment }}:</td>
                    <td>{{ $pricing->payment_processing_name }}</td>
                </tr>
            @endif
            @if( isset( $pricing->total ) )
                <tr>
                    <td>{{ $strings->total }}</td>
                    <td>{!! Ucore()->format_price( $pricing->total ) !!}</td>
                </tr>
            @endif
            @if( isset( $pricing->processing ) )
                <tr>
                    <td>{{ $strings->processing }}</td>
                    <td>{!! Ucore()->format_price( $pricing->processing ) !!}</td>
                </tr>
            @endif
        @endif
    </tbody>
</table>
