<?php

namespace UtillzCore\Inc\Src\Admin;

use \UtillzCore\Inc\Src\Form\Component as Form;
use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Listing\Listing;
use \UtillzCore\Inc\Src\Listing_Type\Listing_Type;

class Metabox {

    use \UtillzCore\Inc\Src\Traits\Singleton;

    function __construct() {

        // metabox
        add_action( 'add_meta_boxes' , [ $this, 'register_meta_boxes' ] );
        // metabox comments
        add_action( 'add_meta_boxes_comment' , [ $this, 'register_meta_boxes_comment' ] );
        // metabox user
        // add_action( 'edit_user_profile', [ $this, 'register_meta_boxes_user' ] );
        add_action( 'personal_options', [ $this, 'register_meta_boxes_user' ] );

        // save metabox
        add_action( 'save_post', [ $this, 'update_listing_type' ], 10, 3 );
        add_action( 'save_post', [ $this, 'update_listing' ], 10, 3 );
        add_action( 'save_post', [ $this, 'update_search_form' ], 10, 3 );
        add_action( 'save_post', [ $this, 'update_entry' ], 10, 3 );
        add_action( 'save_post', [ $this, 'update_page' ], 10, 3 );
        add_action( 'save_post', [ $this, 'update_post' ], 10, 3 );
        add_action( 'save_post', [ $this, 'update_report' ], 10, 3 );
        add_action( 'save_post', [ $this, 'update_collection' ], 10, 3 );

        // save comment metabox
        add_action( 'edit_comment', [ $this, 'update_comment' ], 1, 2 );
        add_action( 'comment_post', [ $this, 'update_comment' ], 1, 2 );

        // save user metabox
        add_action( 'personal_options_update', [ $this, 'update_user' ] );
        add_action( 'edit_user_profile_update', [ $this, 'update_user' ] );

        // preserve tab on save
        add_filter( 'redirect_post_location', [ $this, 'update_listing_type_anchor' ] );

        // panel init
        add_action( 'load-post.php', [ $this, 'init_panel' ] );
        add_action( 'load-post-new.php', [ $this, 'init_panel' ] );
        add_action( 'load-comment.php', [ $this, 'init_panel' ] );
        add_action( 'load-comment-new.php', [ $this, 'init_panel' ] );

    }

    function init_panel() {
        Panel::instance();
    }

    function register_meta_boxes() {

        // listing types
        add_meta_box(
            'ulz-listing-type-options',
            _x( 'Listing Type Options', 'Listing type options in wp-admin', 'utillz-core' ),
            [ $this, 'meta_boxes_listing_type' ],
            'ulz_listing_type'
        );

        // listings
        add_meta_box(
            'ulz-listing-options',
            _x( 'Listing Options', 'Listing options in wp-admin', 'utillz-core' ),
            [ $this, 'meta_boxes_listing' ],
            'ulz_listing'
        );

        // listings side
        add_meta_box(
            'ulz-listing-side-options',
            _x( 'Listing Options', 'Listing sidebar options in wp-admin', 'utillz-core' ),
            [ $this, 'meta_boxes_listing_side' ],
            'ulz_listing',
            'side',
            'default'
        );

        // search forms
        add_meta_box(
            'ulz-search-form-options',
            _x( 'Search Form', 'Search form options in wp-admin', 'utillz-core' ),
            [ $this, 'meta_boxes_search_form' ],
            'ulz_search_form'
        );

        // plans
        add_meta_box(
            'ulz-plan-options',
            _x( 'Plan', 'Plan options in wp-admin', 'utillz-core' ),
            [ $this, 'meta_boxes_plan' ],
            'ulz_plan'
        );

        // promotion
        add_meta_box(
            'ulz-promotion-options',
            _x( 'Promotion', 'Plan options in wp-admin', 'utillz-core' ),
            [ $this, 'meta_boxes_promotion' ],
            'ulz_promotion'
        );

        // conversation
        add_meta_box(
            'ulz-conversation-options',
            _x( 'Conversation', 'Conversation options in wp-admin', 'utillz-core' ),
            [ $this, 'meta_boxes_conversation' ],
            'ulz_conversation'
        );

        // entry
        add_meta_box(
            'ulz-entry-options',
            _x( 'Entry', 'Entries options in wp-admin', 'utillz-core' ),
            [ $this, 'meta_boxes_entry' ],
            'ulz_entry'
        );

        // report
        add_meta_box(
            'ulz-report-options',
            _x( 'Report', 'Report options in wp-admin', 'utillz-core' ),
            [ $this, 'meta_boxes_report' ],
            'ulz_report'
        );

        // collections
        add_meta_box(
            'ulz-collection-options',
            _x( 'Collection', 'Collection options in wp-admin', 'utillz-core' ),
            [ $this, 'meta_boxes_collection' ],
            'ulz_collection'
        );

    }

    function register_meta_boxes_comment( $comment ) {

        // check user capabilities
		if ( ! current_user_can( 'edit_comment', $comment->comment_ID ) ) {
			return;
		}

		// only in listing comments
		if ( get_post_type( $comment->comment_post_ID ) !== 'ulz_listing' ) {
			return;
		}

		// only top level comments
		if ( 0 !== intval( $comment->comment_parent ) ) {
			return;
		}

        add_meta_box(
            'ulz-comments-options',
            __( 'Listing Review', 'utillz-core' ),
            [ $this, 'meta_boxes_comments' ],
            'comment',
            'normal'
        );

    }

    function register_meta_boxes_user( $user ) {

        global $ulz_user;
        $ulz_user = $user;

        Ucore()->the_template('admin/metabox/user');

    }

    static function meta_boxes_listing_type( $post ) {
        Ucore()->the_template('admin/metabox/listing-type');
    }

    static function meta_boxes_listing( $post ) {
        Ucore()->the_template('admin/metabox/listing');
    }

    static function meta_boxes_listing_side( $post ) {
        Ucore()->the_template('admin/metabox/listing-side');
    }

    static function meta_boxes_search_form( $post ) {
        Ucore()->the_template('admin/metabox/search-form');
    }

    static function meta_boxes_plan( $post ) {
        Ucore()->the_template('admin/metabox/plan');
    }

    static function meta_boxes_promotion( $post ) {
        Ucore()->the_template('admin/metabox/promotion');
    }

    static function meta_boxes_conversation( $post ) {
        Ucore()->the_template('admin/metabox/conversation');
    }

    static function meta_boxes_entry( $post ) {
        Ucore()->the_template('admin/metabox/entry');
    }

    static function meta_boxes_report( $post ) {
        Ucore()->the_template('admin/metabox/report');
    }

    static function meta_boxes_collection( $post ) {
        Ucore()->the_template('admin/metabox/collection');
    }

    static function meta_boxes_comments( $comment ) {
        Ucore()->the_template('admin/metabox/comment');
    }

    static function update_listing_type( $post_id ) {

        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        }

        if( get_post_type( $post_id ) == 'ulz_listing_type' && isset( $_POST ) && ! empty( $_POST ) ) {

            foreach( $_POST as $id => $value ) {
                if( substr( $id, 0, 4 ) == 'ulz_' ) {

                    delete_post_meta( $post_id, $id );

                    // array
                    if( is_array( $value ) ) {
                        foreach( $value as $val ) {
                            add_post_meta( $post_id, $id, $val );
                        }
                    }
                    // single
                    else{
                        delete_post_meta( $post_id, $id );
                        update_post_meta( $post_id, $id, $value );
                    }
                }
            }
        }
    }

    static function update_collection( $post_id ) {

        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        }

        if( get_post_type( $post_id ) == 'ulz_collection' && isset( $_POST ) && ! empty( $_POST ) ) {
            foreach( $_POST as $id => $value ) {

                // reset collection\'s listings
                if( $id == 'ulz_listings' ) {

                    $listings = new \WP_Query([
                        'post_type' => 'ulz_listing',
                        'fields' => 'ids',
                        'meta_query' => [
                            'relation' => 'AND',
                            [
                                'key' => 'ulz_collection',
                                'value' => get_the_ID(),
                                'compare' => '='
                            ]
                        ]
                    ]);

                    // old listings
                    foreach( $listings->posts as $old_listing_id ) {
                        delete_post_meta( $old_listing_id, 'ulz_collection', $post_id );
                    }

                    // new listings
                    foreach( $value as $new_listing_id ) {
                        add_post_meta( $new_listing_id, 'ulz_collection', $post_id );
                    }

                    continue;

                }

                // update meta fields
                if( substr( $id, 0, 4 ) == 'ulz_' ) {

                    delete_post_meta( $post_id, $id );

                    // array
                    if( is_array( $value ) ) {
                        foreach( $value as $val ) {
                            add_post_meta( $post_id, $id, $val );
                        }
                    }
                    // single
                    else{
                        delete_post_meta( $post_id, $id );
                        update_post_meta( $post_id, $id, $value );
                    }
                }
            }
        }
    }

    static function update_search_form( $post_id ) {

        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        }

        if( get_post_type( $post_id ) == 'ulz_search_form' && isset( $_POST ) && ! empty( $_POST ) ) {

            foreach( $_POST as $id => $value ) {
                if( substr( $id, 0, 4 ) == 'ulz_' ) {

                    delete_post_meta( $post_id, $id );

                    // array
                    if( is_array( $value ) ) {
                        foreach( $value as $val ) {
                            add_post_meta( $post_id, $id, $val );
                        }
                    }
                    // single
                    else{
                        delete_post_meta( $post_id, $id );
                        update_post_meta( $post_id, $id, $value );
                    }
                }
            }
        }
    }

    static function update_page( $post_id ) {

        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        }

        if( get_post_type( $post_id ) == 'page' && isset( $_POST ) && ! empty( $_POST ) ) {

            foreach( $_POST as $id => $value ) {
                if( substr( $id, 0, 4 ) == 'ulz_' ) {

                    delete_post_meta( $post_id, $id );

                    // array
                    if( is_array( $value ) ) {
                        foreach( $value as $val ) {
                            add_post_meta( $post_id, $id, $val );
                        }
                    }
                    // single
                    else{
                        delete_post_meta( $post_id, $id );
                        update_post_meta( $post_id, $id, $value );
                    }
                }
            }
        }
    }

    static function update_post( $post_id ) {

        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        }

        if( get_post_type( $post_id ) == 'post' && isset( $_POST ) && ! empty( $_POST ) ) {

            foreach( $_POST as $id => $value ) {
                if( substr( $id, 0, 4 ) == 'ulz_' ) {

                    delete_post_meta( $post_id, $id );

                    // array
                    if( is_array( $value ) ) {
                        foreach( $value as $val ) {
                            add_post_meta( $post_id, $id, $val );
                        }
                    }
                    // single
                    else{
                        delete_post_meta( $post_id, $id );
                        update_post_meta( $post_id, $id, $value );
                    }
                }
            }
        }
    }

    static function update_report( $post_id ) {

        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        }

        if( get_post_type( $post_id ) == 'ulz_report' && isset( $_POST ) && ! empty( $_POST ) ) {

            foreach( $_POST as $id => $value ) {
                if( substr( $id, 0, 4 ) == 'ulz_' ) {

                    delete_post_meta( $post_id, $id );

                    // array
                    if( is_array( $value ) ) {
                        foreach( $value as $val ) {
                            add_post_meta( $post_id, $id, $val );
                        }
                    }
                    // single
                    else{
                        delete_post_meta( $post_id, $id );
                        update_post_meta( $post_id, $id, $value );
                    }
                }
            }
        }
    }

    static function is_valid_date( $time, $format = 'Y-m-d' ) {

        $date_format = date('Y-m-d');
        $d = \DateTime::createFromFormat( "Y-m-d {$format}", "{$date_format} {$time}" );
        return $d && $d->format( $format ) == $time;

    }

    static function update_listing( $post_id, $post, $update ) {

        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        }

        if ( ! $update ) {
            return;
        }

        if( get_post_type( $post_id ) == 'ulz_listing' && isset( $_POST ) && ! empty( $_POST ) ) {

            $form = new Form( Form::Storage_Request );
            $request = Request::instance();
            $listing_type = new Listing_Type( Ucore()->get( 'ulz_listing_type', $post_id ) );

            /*
             * update priority
             *
             */
            if( $request->has('ulz_priority_selection') ) {

                update_post_meta( $post_id, 'ulz_priority_selection', $request->get('ulz_priority_selection') );
                update_post_meta( $post_id, 'ulz_priority_custom', $request->get('ulz_priority_custom') );

                $priority = 0;

                switch( $request->get('ulz_priority_selection') ) {
                    case 'normal':
                        $priority = 0; break;
                    case 'featured':
                        $priority = 1; break;
                    case 'promoted':
                        $priority = 2; break;
                    case 'custom':
                        $priority = (int) $request->get('ulz_priority_custom'); break;
                }

                update_post_meta( $post_id, 'ulz_priority', $priority );

            }

            /*
             * update expiration
             *
             */
            if( ! $request->is_empty('ulz_enable_listing_expiration') ) {

                $exp = $request->get('ulz_listing_expiration');

                if( is_array( $exp ) ) {

                    $exp = (object) $exp;

                    if(
                        isset( $exp->month ) &&
                        isset( $exp->day ) &&
                        isset( $exp->year ) &&
                        isset( $exp->hour ) &&
                        isset( $exp->minute )
                    ) {

                        if( self::is_valid_date( sprintf( '%s-%s-%s %s:%s', $exp->year, sprintf('%02d', $exp->month ), sprintf('%02d', $exp->day), sprintf('%02d', $exp->hour), sprintf('%02d', $exp->minute) ), 'Y-m-d H:i' ) ) {

                            $timezone = new \DateTimeZone( wp_timezone_string() );
                            $datetime = new \DateTime( sprintf( '%s-%s-%s %s:%s', $exp->year,sprintf('%02d', $exp->month ), sprintf('%02d', $exp->day), sprintf('%02d', $exp->hour), sprintf('%02d', $exp->minute) ), $timezone );
                            $datetime->setTimezone( new \DateTimeZone('GMT') );

                            update_post_meta( $post_id, 'ulz_listing_expires', $datetime->format('Y-m-d H:i') );

                        }
                    }
                }

            }
            // revert expiration
            elseif( $request->get('ulz_remove_listing_expiration') ) {
                delete_post_meta( $post_id, 'ulz_listing_expires' );
            }

            /*
             * static fields
             *
             */
            $static_fields = [
    			'ulz_price',
    			'ulz_extra_pricing',
    			'ulz_addons',
            ];

            foreach( $static_fields as $static_field ) {
                if( $request->has( $static_field ) ) {
                    update_post_meta( $post_id, $static_field, $request->get( $static_field ) );
                }
            }

            /*
             * update fields
             *
             */
            $items = Ucore()->jsoning( 'ulz_fields', Ucore()->get('ulz_listing_type') );

            if( ! $items ) { $items = []; }

            $items = array_merge( $items, [
                (object) [
                    'template' => (object) [
                        'id' => 'select'
                    ],
                    'fields' => (object) [
                        'key' => 'ulz_listing_type'
                    ],
                ]
            ]);

            foreach( $items as $item ) {

                // prefix custom field ids
                if( isset( $item->fields->key ) ) {
                    $item->fields->key = Ucore()->prefix( $item->fields->key );
                }

                $field = $form->create( $item );
                $id = $field->props->id;

                if( isset( $_POST[ $id ] ) ) {

                    $value = $field->props->value;
                    $value = $field->before_save( $post_id, $value );

                    delete_post_meta( $post_id, $id );

                    if( ! empty( $value ) ) {
                        // array
                        if( is_array( $value ) ) {
                            foreach( $value as $val ) {
                                add_post_meta( $post_id, $id, $val );
                            }
                        }
                        // single
                        else{
                            update_post_meta( $post_id, $id, $value );
                        }
                    }

                    $field->after_save( $post_id, $value );

                }
            }
        }
    }

    static function update_entry( $post_id, $post, $update ) {

        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        }

        if ( ! $update ) {
            return;
        }

        if( get_post_type( $post_id ) == 'ulz_entry' && isset( $_POST ) && ! empty( $_POST ) ) {

            $listing_id = Ucore()->get('ulz_listing', $post_id );

            if( ! $listing_id ) {
                return;
            }

            $request = Request::instance();
            $form = new Form( Form::Storage_Request );
            $listing = new Listing( $listing_id );

    		$items = Ucore()->jsoning( 'ulz_action_type_application_fields', $listing->type->id );

            foreach( $items as $item ) {

				$field = $form->create(
					Ucore()->prefix_item( $item )
				);

                $id = $field->props->id;

                if( $request->has( $id ) ) {

                    $value = $field->props->value;
                    $value = $field->before_save( $post_id, $value );

                    // array
                    if( is_array( $value ) ) {
                        delete_post_meta( $post_id, $id );
                        foreach( $value as $val ) {
                            add_post_meta( $post_id, $id, $val );
                        }
                    }
                    // single
                    else{
                        update_post_meta( $post_id, $id, $value );
                    }

                    $field->after_save( $post_id, $value );

                }

    		}
        }
    }

    function update_listing_type_anchor( $location ) {

        if( $_POST['post_type'] == 'ulz_listing_type' ) {
            if( isset( $_POST['utillz_current_tab'] ) ) {
                return $location . '#' . esc_attr( $_POST['utillz_current_tab'] );
            }
        }

        return $location;

    }

    function update_comment( $comment_id, $data ) {

        if ( ! current_user_can( 'edit_comment', $comment_id ) || ( isset( $data['comment_parent'] ) && $data['comment_parent'] ) ) {
			return $comment_id;
		}

        if ( ! isset( $_POST['utillz_review_comment_nonce'] ) || ! wp_verify_nonce( $_POST['utillz_review_comment_nonce'], 'utillz_comment' ) ) {
			return $comment_id;
		}

        $request = Request::instance();
        $listing = new Listing( $data['comment_post_ID'] );

        if( ! $listing->id ) {
            return;
        }

        if( isset( $_POST ) && ! empty( $_POST ) ) {

            $review_ratings = Ucore()->jsoning( 'ulz_review_ratings', $listing->type->id );

            // add ratings
            $comment_ratings = [];
            foreach( $review_ratings as $review_rating ) {
                $comment_ratings[ $review_rating->fields->key ] = $request->get( sprintf( 'ulz_rating_%s', $review_rating->fields->key ) );
            }

            update_comment_meta( $comment_id, 'ulz_ratings', $comment_ratings );

            if( $review_ratings ) {
                $sum = $count = 0;
                foreach( $review_ratings as $review_rating ) {
                    if( $review_rating->fields->key && isset( $_POST[ sprintf( 'ulz_rating_%s', $review_rating->fields->key ) ] ) ) {
                        $rating_value = $_POST[ sprintf( 'ulz_rating_%s', $review_rating->fields->key ) ];
                        if( (int) $rating_value > 0 ) {
                            $sum += (int) $rating_value;
                            $count++;
                        }
                    }
                }
                if( $count > 0 ) {
                    update_comment_meta( $comment_id, 'ulz_rating_average', number_format( $sum / $count, 2 ) );
                }
            }

            // add gallery
            if( ! $request->is_empty('ulz_gallery') ) {
                $gallery = $request->get('ulz_gallery');
                // TODO: improve this with after_save
                update_comment_meta( $comment_id, 'ulz_gallery', is_array( $gallery ) ? json_encode( $gallery ) : $gallery );
            }
        }

    }

    public function update_user( $user_id ) {

        if ( ! current_user_can( 'edit_user', $user_id ) ) {
            return;
        }

        update_user_meta( $user_id, 'ulz_role', sanitize_text_field( $_POST['ulz_role'] ) );

    }

}
