<?php

namespace UtillzCore\Inc\Src\Admin;

use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Wallet;

class Import {

    use \UtillzCore\Inc\Src\Traits\Singleton;

    function __construct() {

        // add import page to ulz_listing
        add_action( 'admin_menu' , [ $this, 'add_submenu_page' ] );

    }

    public function enqueue_menu_scripts() {
        Panel::instance();
    }

    public function add_submenu_page() {

        add_action( sprintf( 'load-%s',
            add_submenu_page(
                'edit.php?post_type=ulz_listing_type', // parent slug
                esc_html__('Demo Import', 'utillz-core'), // page title
                esc_html__('Demo Import', 'utillz-core'), // menu title
                'manage_options', // capability
                'ulz_import', // menu slug
                [ $this, 'import_page_output' ]
            )),
            [ $this, 'enqueue_menu_scripts' ]
        );

    }

    public function import_page_output() {

        Ucore()->the_template('admin/import/import');

    }

    static function generate_image( $postdata = [] ) {

		$image_colors = apply_filters('utillz/import/image-colors', [
			[
				'background' => '111',
				'color' => '333',
			],
			[
				'background' => '222',
				'color' => '444',
			],
			[
				'background' => '333',
				'color' => '555',
			],
		]);

		$image_sizes = apply_filters('utillz/import/image-sizes', [
			[
				'width' => 1920,
				'height' => 1080,
			],
			[
				'width' => 1080,
				'height' => 1080,
			],
			[
				'width' => 1080,
				'height' => 1920,
			],
		]);

		$rand = rand( 0, 2 );
		$image_color = $image_colors[ mt_rand( 0, 2 ) ];
		$image_size = $image_sizes[ mt_rand( 0, 2 ) ];

		// query imported images with same size
		$query = new \WP_Query([
			'post_type' => 'attachment',
			'post_status' => 'any',
			'posts_per_page' => 1,
			'meta_query' => [
				'relation' => 'AND',
				[
					'key' => 'ulz_imported_attachment',
					'value' => true,
					'compare' => '=',
				],
				[
					'key' => 'ulz_attachment_size',
					'value' => "{$image_size['width']}x{$image_size['height']}-{$image_color['background']}-{$image_color['color']}",
					'compare' => '=',
				],
			],
		]);

		// use existing attachment with same size
		if( $query->found_posts ) {
			$post_id = $query->posts[0]->ID;
		}
		// import the attachment
		else{

            $importer = self::wp_importer();

			$remote_url = sprintf(
				'https://via.placeholder.com/%sx%s/%s/%s.jpg',
				$image_size['width'],
				$image_size['height'],
				$image_color['background'],
				$image_color['color']
			);

			$post_id = $importer->process_attachment( $postdata, $remote_url );

			// set flag for imported attachment
			if( ! is_wp_error( $post_id ) ) {
				add_post_meta( $post_id, 'ulz_imported_attachment', true );
				add_post_meta( $post_id, 'ulz_attachment_size', "{$image_size['width']}x{$image_size['height']}-{$image_color['background']}-{$image_color['color']}" );
			}
		}

		return (object) [
			'id' => $post_id,
			'image_size' => $image_size,
			'image_color' => $image_color
		];

	}

    static function wp_importer() {

        require_once( UTILLZ_CORE_PATH . 'inc/lib/wordpress-importer/wordpress-importer.php' );

        $wp_importer = new \WP_UTILLZ_Import();
        $wp_importer->fetch_attachments = true;

		return $wp_importer;

    }

}
