<?php

namespace UtillzCore\Inc\Src\Admin\Http\Endpoints;

use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Wallet;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Endpoint_Payout extends Endpoint {

	public $action = 'utillz-action-payout';

    public function action() {

		do_action('utillz/account/payout/before_request');

		global $wpdb;

		$request = Request::instance();
		$wallet = new Wallet();
		$data = (object) Ucore()->sanitize( $_POST );

		$enable_payouts = get_option( 'ulz_enable_payouts', false );
		$payout_methods = get_option( 'ulz_payout_methods', [] );
		$min_payout = (float) get_option( 'ulz_min_payout', 0 );

		if( ! $enable_payouts ) {
			return;
		}

		if( ! in_array( $data->method, $payout_methods ) ) {
			wp_send_json([
				'success' => false,
				'errors' => [
					'method' => esc_html__( 'Select payout method', 'utillz-core' )
				]
			]);
		}

		// check amount availability
		if( (float) $data->amount > $wallet->get_balance() ) {
			wp_send_json([
				'success' => false,
				'errors' => [
					'amount' => esc_html__( 'Not enough funds', 'utillz-core' )
				]
			]);
		}

		if( (float) $data->amount <= 0 ) {
			wp_send_json([
				'success' => false,
				'errors' => [
					'amount' => esc_html__( 'Must be a positive number', 'utillz-core' )
				]
			]);
		}

		if( $min_payout > 0 && (float) $data->amount < $min_payout ) {
			wp_send_json([
				'success' => false,
				'errors' => [
					'amount' => sprintf( esc_html__( 'The minimum payout amount is %s', 'utillz-core' ), Ucore()->format_price( $min_payout ) )
				]
			]);
		}

		$terms = [
			'amount' => 'required|numeric',
			'method' => 'required'
		];

		switch( $data->method ) {
			case 'paypal':

				$terms = array_merge( $terms, [
					'paypal_email' => 'required|email'
				]);

				break;

			case 'bank_transfer':

				$terms = array_merge( $terms, [
					'bank_account_name' => 'required',
					// 'bank_account_number' => 'required',
					'bank_iban' => 'required',
					'bank_bic' => 'required',
					'bank_name' => 'required',
					// 'bank_routing_number' => 'required',
				]);

				break;

		}

		$validation = new \UtillzCore\Inc\Src\Validation();
		$response = $validation->validate( $data, $terms );

		if( $response->success ) {

			$address = [];

			switch( $data->method ) {

				case 'paypal':

					$address = serialize([
						'paypal_email' => $data->paypal_email,
					]);

					break;

				case 'bank_transfer':

					$address = serialize([
						'bank_account_name' => $data->bank_account_name,
						'bank_account_number' => $data->bank_account_number,
						'bank_iban' => $data->bank_iban,
						'bank_bic' => $data->bank_bic,
						'bank_name' => $data->bank_name,
						'bank_routing_number' => $data->bank_routing_number,
					]);

					break;

			}

			// $wallet->add_to_balance( $data->amount * -1 );
			$wallet->add_funds( $data->amount * -1, null, 'payout' );

			$wpdb->insert( $wpdb->prefix . 'utillz_wallet_payouts', [
				'user_id' => get_current_user_id(),
				'amount' => floatval( $data->amount ),
				'payment_method' => $data->method,
				'address' => $address,
				'status' => 'pending',
			]);

		}

		wp_send_json( $response );

	}

}
