<?php

namespace UtillzCore\Inc\Extensions\Component;

use \UtillzCore\Inc\Extensions\Blade\Blade;
use \UtillzCore\Inc\Src\Error;

class Component {

    public $create;

    public function create( $props ) {

        // props from template item
        if( is_object( $props ) ) {
            $props = $this->extract( $props );
        }

        $ref = new \ReflectionClass( $this );
        $ref_name = $ref->getNamespaceName();
        $type = str_replace( '-', '_', $props['type'] );

        // external
        $namespaced_ext = sprintf( '%1$s\%2$s', str_replace( 'UtillzCore\\Inc\\Src\\', 'UtillzEnhance\\Inc\\Components\\', $ref_name ), $type );
        if( class_exists( $namespaced_ext ) ) {
            return new $namespaced_ext( $props, $this );
        }
        // internal
        $namespaced_int = sprintf( '%1$s\modules\%2$s\%2$s', $ref_name, $type );
        if( class_exists( $namespaced_int ) ) {
            return new $namespaced_int( $props, $this );
        }

        return new Error( sprintf( 'The module %s was not found!', $props['type'] ) );

    }

    public function render( $props ) {

        $module = $this->create( $props );

        if( ! Ucore()->is_error( $module ) ) {
            echo $module->get();
        }else{
            echo '<div class="ulz-form-group ulz-col-12">' . $module->get_error() . '</div>';
        }

    }

    /*
     * TODO: move items to class
     *
     */
    public function extract( $item ) {

        $props = array_merge( (array) $item->fields, [
            'type' => isset( $item->fields->choice ) ? $item->fields->choice : $item->template->id,
        ]);

        if( isset( $item->fields->multiple ) && $item->fields->multiple == true && ! isset( $item->fields->value ) ) {
            $props['value'] = [];
        }

        if( isset( $item->fields->key ) ) {
            $props['id'] = $item->fields->key;
            unset( $props['key'] );
        }

        return $props;

    }

    public function extract_ids( $items ) {

        $ids = [];

        foreach( $items as $item ) {
            if( isset( $item->fields->id ) ) {
                $ids[] = $item->fields->id;
            }
        }

        return $ids;

    }

}
