<?php
/**
 *
 * @author     Gaviasthemes Team     
 * @copyright  Copyright (C) 2024 Gaviasthemes. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 * 
 */

?>
	</div><!--end page content-->
	
</div><!-- End page -->

	<footer id="wp-footer" class="clearfix">
		<?php 
			$footer_id = apply_filters('constix_get_footer_layout', null );
			if($footer_id && class_exists('GVA_Layout_Frontend')){
				echo '<div class="footer-main">' . GVA_Layout_Frontend::getInstance()->element_display($footer_id) . '</div>';
			}
		?>
		<?php if(constix_get_option('copyright_default', 'yes') == 'yes'){ ?>
			<div class="copyright">
				<div class="container">
					<div class="copyright-content">
							<div class="row">
								<div class="col-sm-12 col-xs-12">
									<?php 
										if(!empty($copyright)){ 
											echo esc_html($copyright);
										}else{
											echo esc_html__('Copyright 2024 - Company - All rights reserved. Powered by WordPress.', 'constix');
										}
									?>
								</div>
							</div>	
						</div>	
				</div>
			</div>
		<?php } ?>	

	</footer>
	
	<div id="gva-overlay"></div>
	<?php do_action( 'constix_offcanvas_mobile' ); ?>
	<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="blur-svg">
	   <defs>
	      <filter id="blur-filter">
	         <feGaussianBlur stdDeviation="3"></feGaussianBlur>
	      </filter>
	    </defs>
	</svg>

	<div class="contact-icon__single">
		<ul class="contact-icon__list">
			<?php 
				$contact_email = constix_get_option('contact_email', '');
				$contact_phone = constix_get_option('contact_phone', '');
				$contact_location = constix_get_option('contact_location_text', '');
				$contact_location_link = constix_get_option('contact_location_link', '');
				if($contact_email){
					echo '<li>';
						echo '<a class="contact-icon__email contact-icon__item" href="mailto:' . esc_attr($contact_email) . '">';
							echo '<span class="contact-icon__icon"><i class="cicon-email-4"></i></span>';
						 	echo '<span class="contact-icon__text">' . esc_attr($contact_email) . '</span>';
						echo '</a>'; 
					echo '</li>';
				}
				if($contact_phone){
					echo '<li>';
						echo '<a class="contact-icon__phone contact-icon__item" href="tel:' . esc_attr($contact_phone) . '">';
							echo '<span class="contact-icon__icon"><i class="cicon-telephone-1"></i></span>';
						 	echo '<span class="contact-icon__text">' . esc_attr($contact_phone) . '</span>';
						echo '</a>';
					echo '</li>';
				}
				if($contact_location){
					echo '<li>';
						echo '<a class="contact-icon__location contact-icon__item" href="' . esc_attr($contact_location_link) . '">';
							echo '<span class="contact-icon__icon"><i class="cicon-maps-and-flags"></i></span>';
						 	echo '<span class="contact-icon__text">' . esc_attr($contact_location) . '</span>';
						echo '</a>'; 
					echo '</li>';
				}
			?>
		</ul>
	</div>

<?php wp_footer(); ?>

</body>
</html>