<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* WindowsMalwareOverview File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Solid_Backups\Strauss\Beta\Microsoft\Graph\Model;
/**
* WindowsMalwareOverview class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class WindowsMalwareOverview extends Entity
{

    /**
    * Gets the malwareCategorySummary
    * Count of devices per malware category
    *
    * @return WindowsMalwareCategoryCount The malwareCategorySummary
    */
    public function getMalwareCategorySummary()
    {
        if (array_key_exists("malwareCategorySummary", $this->_propDict)) {
            if (is_a($this->_propDict["malwareCategorySummary"], "Solid_Backups\Strauss\Beta\Microsoft\Graph\Model\WindowsMalwareCategoryCount")) {
                return $this->_propDict["malwareCategorySummary"];
            } else {
                $this->_propDict["malwareCategorySummary"] = new WindowsMalwareCategoryCount($this->_propDict["malwareCategorySummary"]);
                return $this->_propDict["malwareCategorySummary"];
            }
        }
        return null;
    }

    /**
    * Sets the malwareCategorySummary
    * Count of devices per malware category
    *
    * @param WindowsMalwareCategoryCount $val The value to assign to the malwareCategorySummary
    *
    * @return WindowsMalwareOverview The WindowsMalwareOverview
    */
    public function setMalwareCategorySummary($val)
    {
        $this->_propDict["malwareCategorySummary"] = $val;
         return $this;
    }
    /**
    * Gets the malwareDetectedDeviceCount
    * Count of devices with malware detected in the last 30 days
    *
    * @return int The malwareDetectedDeviceCount
    */
    public function getMalwareDetectedDeviceCount()
    {
        if (array_key_exists("malwareDetectedDeviceCount", $this->_propDict)) {
            return $this->_propDict["malwareDetectedDeviceCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the malwareDetectedDeviceCount
    * Count of devices with malware detected in the last 30 days
    *
    * @param int $val The value of the malwareDetectedDeviceCount
    *
    * @return WindowsMalwareOverview
    */
    public function setMalwareDetectedDeviceCount($val)
    {
        $this->_propDict["malwareDetectedDeviceCount"] = $val;
        return $this;
    }

    /**
    * Gets the malwareExecutionStateSummary
    * Count of devices per malware execution state
    *
    * @return WindowsMalwareExecutionStateCount The malwareExecutionStateSummary
    */
    public function getMalwareExecutionStateSummary()
    {
        if (array_key_exists("malwareExecutionStateSummary", $this->_propDict)) {
            if (is_a($this->_propDict["malwareExecutionStateSummary"], "Solid_Backups\Strauss\Beta\Microsoft\Graph\Model\WindowsMalwareExecutionStateCount")) {
                return $this->_propDict["malwareExecutionStateSummary"];
            } else {
                $this->_propDict["malwareExecutionStateSummary"] = new WindowsMalwareExecutionStateCount($this->_propDict["malwareExecutionStateSummary"]);
                return $this->_propDict["malwareExecutionStateSummary"];
            }
        }
        return null;
    }

    /**
    * Sets the malwareExecutionStateSummary
    * Count of devices per malware execution state
    *
    * @param WindowsMalwareExecutionStateCount $val The value to assign to the malwareExecutionStateSummary
    *
    * @return WindowsMalwareOverview The WindowsMalwareOverview
    */
    public function setMalwareExecutionStateSummary($val)
    {
        $this->_propDict["malwareExecutionStateSummary"] = $val;
         return $this;
    }

    /**
    * Gets the malwareNameSummary
    * Count of devices per malware
    *
    * @return WindowsMalwareNameCount The malwareNameSummary
    */
    public function getMalwareNameSummary()
    {
        if (array_key_exists("malwareNameSummary", $this->_propDict)) {
            if (is_a($this->_propDict["malwareNameSummary"], "Solid_Backups\Strauss\Beta\Microsoft\Graph\Model\WindowsMalwareNameCount")) {
                return $this->_propDict["malwareNameSummary"];
            } else {
                $this->_propDict["malwareNameSummary"] = new WindowsMalwareNameCount($this->_propDict["malwareNameSummary"]);
                return $this->_propDict["malwareNameSummary"];
            }
        }
        return null;
    }

    /**
    * Sets the malwareNameSummary
    * Count of devices per malware
    *
    * @param WindowsMalwareNameCount $val The value to assign to the malwareNameSummary
    *
    * @return WindowsMalwareOverview The WindowsMalwareOverview
    */
    public function setMalwareNameSummary($val)
    {
        $this->_propDict["malwareNameSummary"] = $val;
         return $this;
    }

    /**
    * Gets the malwareSeveritySummary
    * Count of active malware per malware severity
    *
    * @return WindowsMalwareSeverityCount The malwareSeveritySummary
    */
    public function getMalwareSeveritySummary()
    {
        if (array_key_exists("malwareSeveritySummary", $this->_propDict)) {
            if (is_a($this->_propDict["malwareSeveritySummary"], "Solid_Backups\Strauss\Beta\Microsoft\Graph\Model\WindowsMalwareSeverityCount")) {
                return $this->_propDict["malwareSeveritySummary"];
            } else {
                $this->_propDict["malwareSeveritySummary"] = new WindowsMalwareSeverityCount($this->_propDict["malwareSeveritySummary"]);
                return $this->_propDict["malwareSeveritySummary"];
            }
        }
        return null;
    }

    /**
    * Sets the malwareSeveritySummary
    * Count of active malware per malware severity
    *
    * @param WindowsMalwareSeverityCount $val The value to assign to the malwareSeveritySummary
    *
    * @return WindowsMalwareOverview The WindowsMalwareOverview
    */
    public function setMalwareSeveritySummary($val)
    {
        $this->_propDict["malwareSeveritySummary"] = $val;
         return $this;
    }

    /**
    * Gets the malwareStateSummary
    * Count of devices per malware state
    *
    * @return WindowsMalwareStateCount The malwareStateSummary
    */
    public function getMalwareStateSummary()
    {
        if (array_key_exists("malwareStateSummary", $this->_propDict)) {
            if (is_a($this->_propDict["malwareStateSummary"], "Solid_Backups\Strauss\Beta\Microsoft\Graph\Model\WindowsMalwareStateCount")) {
                return $this->_propDict["malwareStateSummary"];
            } else {
                $this->_propDict["malwareStateSummary"] = new WindowsMalwareStateCount($this->_propDict["malwareStateSummary"]);
                return $this->_propDict["malwareStateSummary"];
            }
        }
        return null;
    }

    /**
    * Sets the malwareStateSummary
    * Count of devices per malware state
    *
    * @param WindowsMalwareStateCount $val The value to assign to the malwareStateSummary
    *
    * @return WindowsMalwareOverview The WindowsMalwareOverview
    */
    public function setMalwareStateSummary($val)
    {
        $this->_propDict["malwareStateSummary"] = $val;
         return $this;
    }

    /**
    * Gets the osVersionsSummary
    * Count of devices with malware per windows OS version
    *
    * @return OsVersionCount The osVersionsSummary
    */
    public function getOsVersionsSummary()
    {
        if (array_key_exists("osVersionsSummary", $this->_propDict)) {
            if (is_a($this->_propDict["osVersionsSummary"], "Solid_Backups\Strauss\Beta\Microsoft\Graph\Model\OsVersionCount")) {
                return $this->_propDict["osVersionsSummary"];
            } else {
                $this->_propDict["osVersionsSummary"] = new OsVersionCount($this->_propDict["osVersionsSummary"]);
                return $this->_propDict["osVersionsSummary"];
            }
        }
        return null;
    }

    /**
    * Sets the osVersionsSummary
    * Count of devices with malware per windows OS version
    *
    * @param OsVersionCount $val The value to assign to the osVersionsSummary
    *
    * @return WindowsMalwareOverview The WindowsMalwareOverview
    */
    public function setOsVersionsSummary($val)
    {
        $this->_propDict["osVersionsSummary"] = $val;
         return $this;
    }
    /**
    * Gets the totalDistinctMalwareCount
    * Count of all distinct malwares detected across all devices. Valid values -2147483648 to 2147483647
    *
    * @return int The totalDistinctMalwareCount
    */
    public function getTotalDistinctMalwareCount()
    {
        if (array_key_exists("totalDistinctMalwareCount", $this->_propDict)) {
            return $this->_propDict["totalDistinctMalwareCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the totalDistinctMalwareCount
    * Count of all distinct malwares detected across all devices. Valid values -2147483648 to 2147483647
    *
    * @param int $val The value of the totalDistinctMalwareCount
    *
    * @return WindowsMalwareOverview
    */
    public function setTotalDistinctMalwareCount($val)
    {
        $this->_propDict["totalDistinctMalwareCount"] = $val;
        return $this;
    }
    /**
    * Gets the totalMalwareCount
    * Count of all malware detections across all devices. Valid values -2147483648 to 2147483647
    *
    * @return int The totalMalwareCount
    */
    public function getTotalMalwareCount()
    {
        if (array_key_exists("totalMalwareCount", $this->_propDict)) {
            return $this->_propDict["totalMalwareCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the totalMalwareCount
    * Count of all malware detections across all devices. Valid values -2147483648 to 2147483647
    *
    * @param int $val The value of the totalMalwareCount
    *
    * @return WindowsMalwareOverview
    */
    public function setTotalMalwareCount($val)
    {
        $this->_propDict["totalMalwareCount"] = $val;
        return $this;
    }
}
