<?php

// Direct load is not allowed
if ( ! defined( 'ABSPATH' ) ) {
	die();
}

use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Modules\NestedElements\Base\Widget_Nested_Base;
use Elementor\Modules\NestedElements\Controls\Control_Nested_Repeater;

class Alpus_Nested_Switcher extends Widget_Nested_Base {

	public function get_name() {
		return 'alpus-nested-switcher';
	}

	public function get_title() {
		return esc_html__( 'Alpus Switcher', 'alpus-flexbox' );
	}

	public function get_icon() {
		return 'alpus-elementor-widget-icon alpus-widget-icon-switcher';
	}

	public function get_categories() {
		return array( 'layout' );
	}

	public function get_script_depends() {
		return array( 'alpus-el-switcher' );
	}

	public function get_style_depends() {
		return array( 'alpus-el-switcher' );
	}

	public function has_widget_inner_wrapper(): bool {
		return ! Plugin::$instance->experiments->is_feature_active( 'e_optimized_markup' );
	}

	public function get_keywords() {
		return array( 'nested', 'switcher', 'toggle', 'flexbox', 'container', 'tab' );
	}

	protected function get_default_children_placeholder_selector() {
		return '.alpus-nested-switcher-wrapper .switcher-contents';
	}

	protected function switcher_item_container( int $index ) {
		return array(
			'elType'   => 'container',
			'settings' => array(
				'_title'        => sprintf( __( 'Switch #%s', 'alpus-flexbox' ), $index ),
				'content_width' => 'full',
				'padding'       => array(
					'unit'     => 'px',
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'isLinked' => true,
				),
			),
		);
	}

	protected function get_default_children_title() {
		return esc_html__( 'Switch #%d', 'alpus-flexbox' );
	}

	protected function get_default_repeater_title_setting_key() {
		return '';
	}

	protected function get_default_children_elements() {
		return array(
			$this->switcher_item_container( 1 ),
			$this->switcher_item_container( 2 ),
		);
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_switches',
			array(
				'label' => esc_html__( 'Switches', 'alpus-flexbox' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			)
		);

			$repeater = new Repeater();

			$repeater->add_control(
				'switch_title',
				array(
					'type'  => Controls_Manager::TEXT,
					'label' => __( 'Title', 'alpha-core' ),
				)
			);

			$this->add_control(
				'items',
				array(
					'label'   => esc_html__( 'Switches', 'alpus-flexbox' ),
					'type'    => Control_Nested_Repeater::CONTROL_TYPE,
					'fields'  => $repeater->get_controls(),
					'default' => array(
						array(),
						array(),
					),
				)
			);

			$this->add_responsive_control(
				'switch_align',
				array(
					'label'     => esc_html__( 'Switcher Align', 'alpha-core' ),
					'type'      => Controls_Manager::CHOOSE,
					'options'   => array(
						'flex-start' => array(
							'title' => esc_html__( 'Left', 'alpha-core' ),
							'icon'  => 'eicon-text-align-left',
						),
						'center'     => array(
							'title' => esc_html__( 'Center', 'alpha-core' ),
							'icon'  => 'eicon-text-align-center',
						),
						'flex-end'   => array(
							'title' => esc_html__( 'Right', 'alpha-core' ),
							'icon'  => 'eicon-text-align-right',
						),
					),
					'selectors' => array(
						'{{WRAPPER}} .alpus-nested-switcher-wrapper' => '--alpha-switcher-h-align: {{VALUE}};',
					),
				)
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_text',
			array(
				'label' => esc_html__( 'Switcher Text', 'alpus-flexbox' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				array(
					'name'     => 'switch_typography',
					'selector' => '{{WRAPPER}} .switcher-switch span',
				)
			);

			$this->add_responsive_control(
				'switch_spacing',
				array(
					'label'      => esc_html__( 'Space Between', 'alpus-flexbox' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => array( 'px', 'em', 'rem', 'custom' ),
					'range'      => array(
						'px' => array(
							'min'  => 0,
							'max'  => 50,
							'step' => 5,
						),
						'%'  => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .alpus-nested-switcher-wrapper' => '--alpha-switcher-between-space: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->add_responsive_control(
				'switch_bottom_spacing',
				array(
					'label'      => esc_html__( 'Bottom Spacing', 'alpus-flexbox' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => array( 'px', 'em', 'rem', 'custom' ),
					'range'      => array(
						'px' => array(
							'min'  => 0,
							'max'  => 50,
							'step' => 5,
						),
						'%'  => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .alpus-nested-switcher-wrapper' => '--alpha-switcher-toggle-bottom-space: {{SIZE}}{{UNIT}};',
					),
				)
			);

		$this->start_controls_tabs( 'tabs_switch_text' );

		$this->start_controls_tab(
			'tab_text_color_normal',
			array(
				'label' => esc_html__( 'Normal', 'alpha-core' ),
			)
		);

		$this->add_control(
			'link_color',
			array(
				'label'     => esc_html__( 'Color', 'alpha-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .switcher-switch:not(.active) span' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_text_color_active',
			array(
				'label' => esc_html__( 'Active', 'alpha-core' ),
			)
		);

			$this->add_control(
				'link_active_color',
				array(
					'label'     => esc_html__( 'Active Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .switcher-switch.active span' => 'color: {{VALUE}};',
					),
				)
			);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_control',
			array(
				'label' => esc_html__( 'Switcher Control', 'alpus-flexbox' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

			$this->add_responsive_control(
				'switcher_width',
				array(
					'label'      => esc_html__( 'Width', 'alpus-flexbox' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => array( 'px', 'em', 'rem', 'custom' ),
					'range'      => array(
						'px' => array(
							'min'  => 0,
							'max'  => 500,
							'step' => 1,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .alpus-nested-switcher-wrapper' => '--alpha-switcher-toggle-width: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->add_responsive_control(
				'switcher_height',
				array(
					'label'      => esc_html__( 'Height', 'alpus-flexbox' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => array( 'px', 'em', 'rem', 'custom' ),
					'range'      => array(
						'px' => array(
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .alpus-nested-switcher-wrapper' => '--alpha-switcher-toggle-height: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->add_responsive_control(
				'control_bg_color',
				array(
					'label'     => esc_html__( 'Background Color', 'alpus-flexbox' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .alpus-nested-switcher-wrapper' => '--alpha-switcher-control-bg-color: {{VALUE}};',
					),
				)
			);

			$this->add_responsive_control(
				'control_circle_color',
				array(
					'label'     => esc_html__( 'Circle Color', 'alpus-flexbox' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .alpus-nested-switcher-wrapper' => '--alpha-switcher-control-color: {{VALUE}};',
					),
				)
			);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		if ( empty( $settings['items'] ) ) {
			return;
		}

		$switcher_html = '';
		$content_html  = '';
		foreach ( $settings['items'] as $index => $item ) {
			if ( $index > 1 ) {
				break;
			}
			// Switcher Switch.
			$switcher_html .= '<li class="switcher-switch' . ( ! $index ? ' active' : '' ) . '"><span data-target="' . $item['_id'] . '">' . ( $item['switch_title'] ? $item['switch_title'] : ( esc_html__( 'Switch ', 'alpus-flexbox' ) . ( $index + 1 ) ) ) . '</span></li>';
			if ( ! $index ) {
				$switcher_html .= '<li class="switcher-toggle"><span class="switcher-toggle-inner"><span class="circle"></span></span></li>';
			}

			// Switcher Content.
			ob_start();
			$this->print_child( $index );
			$content_html .= '<div class="switcher-content' . ( ! $index ? ' active' : '' ) . '" data-id="' . $item['_id'] . '">' . ob_get_clean() . '</div>';
		}
		?>
		<div class="alpus-nested-switcher-wrapper">
			<ul class="switcher-switches nav">
				<?php echo $switcher_html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
			</ul>
			<div class="switcher-contents">
				<?php echo $content_html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
			</div>
		</div>
		<?php
	}

	protected function content_template() {
		?>
		<#
			view.addRenderAttribute( 'switch-contents', 'class', 'switcher-contents' );
		#>
		<div class="alpus-nested-switcher-wrapper">
			<ul class="switcher-switches nav">
			<#
			_.each( settings.items, function( item, index ) {
				#>
				<li class="switcher-switch{{!index ? ' active' : ''}}"><span data-target="{{item._id}}">{{{ item.switch_title ? item.switch_title : ( 'Switch ' + ( index + 1 ) ) }}}</span></li>
				<#
				if (!index) {
					#>
					<li class="switcher-toggle"><span class="switcher-toggle-inner"><span class="circle"></span></span></li>
					<#
				}
			} )
			#>
			</ul>
			<div {{{ view.getRenderAttributeString( 'switch-contents' ) }}}>
			</div>
		</div>
		<?php
	}
}
