<?php

/**
 * Add child styles.
 */
function medcity_child_enqueue_styles()
{
    $parent_style = 'medcity-style';
    wp_enqueue_style('child-style', get_stylesheet_directory_uri() . '/style.css', array(
        $parent_style
    ));
}

add_action('wp_enqueue_scripts', 'medcity_child_enqueue_styles', 99);
/**
  * Set up Medcity Child Theme's textdomain.
  *
  * Declare textdomain for this child theme.
  * Translations can be added to the /languages/ directory.
  */
add_action( 'after_setup_theme', 'medcity_child_theme_setup' );
function medcity_child_theme_setup() {
    load_child_theme_textdomain( 'medcity-child', get_stylesheet_directory() . '/languages' );
}
/**
 * CMS Portal
 * child theme active
 *
*/
add_action('after_switch_theme', 'medcity_child_redirect_to_welcome_page');
function medcity_child_redirect_to_welcome_page()
{
    if (is_child_theme()) {
        $parent_theme = wp_get_theme()->parent();
        if (class_exists('CMS_PORTAL')) {
            wp_safe_redirect(admin_url("themes.php?page={$parent_theme->get('TextDomain')}"));
        } else {
            wp_safe_redirect(admin_url("themes.php?page={$parent_theme->get('TextDomain')}-welcome"));
        }
    }
}