<?php

// =============================================================================
// FUNCTIONS/GLOBAL/ADMIN/CUSTOMIZER/OUTPUT/VARIABLES.PHP
// -----------------------------------------------------------------------------
// Variables to be used across all Stacks for global CSS output.
// =============================================================================

// =============================================================================
// TABLE OF CONTENTS
// -----------------------------------------------------------------------------
//   01. Layout and Design
//   02. Typography
//   03. Header
//   04. Buttons
// =============================================================================

// Layout and Design
// =============================================================================

$x_stack                               = x_get_stack();
$x_layout_site                         = x_get_option( 'x_layout_site' );
$x_layout_site_width                   = x_coerce_value( x_get_option( 'x_layout_site_width' ), '%' );
$x_layout_site_max_width               = x_coerce_value( x_get_option( 'x_layout_site_max_width' ), 'px' );
$x_layout_content                      = x_get_option( 'x_layout_content' );
$x_layout_content_width                = x_coerce_value( x_get_option( 'x_layout_content_width' ), '%' );
$x_layout_sidebar_width                = x_coerce_value( x_get_option( 'x_layout_sidebar_width' ), 'px' );
$x_design_bg_color                     = x_post_css_value( x_get_option( 'x_design_bg_color' ), 'color' );
$x_design_bg_image_pattern             = x_get_option( 'x_design_bg_image_pattern' );
$x_design_bg_image_full                = x_get_option( 'x_design_bg_image_full' );
$x_design_bg_image_full_fade           = x_coerce_value( x_get_option( 'x_design_bg_image_full_fade' ), 'ms' );



// Typography
// =============================================================================

$x_root_font_size_mode                 = x_get_option( 'x_root_font_size_mode' );
$x_root_font_size_stepped_unit         = x_get_option( 'x_root_font_size_stepped_unit' );
$x_root_font_size_stepped_xs           = x_get_option( 'x_root_font_size_stepped_xs' );
$x_root_font_size_stepped_sm           = x_get_option( 'x_root_font_size_stepped_sm' );
$x_root_font_size_stepped_md           = x_get_option( 'x_root_font_size_stepped_md' );
$x_root_font_size_stepped_lg           = x_get_option( 'x_root_font_size_stepped_lg' );
$x_root_font_size_stepped_xl           = x_get_option( 'x_root_font_size_stepped_xl' );
$x_root_font_size_scaling_unit         = x_get_option( 'x_root_font_size_scaling_unit' );
$x_root_font_size_scaling_min          = x_get_option( 'x_root_font_size_scaling_min' );
$x_root_font_size_scaling_max          = x_get_option( 'x_root_font_size_scaling_max' );
$x_root_font_size_scaling_lower_limit  = x_get_option( 'x_root_font_size_scaling_lower_limit' );
$x_root_font_size_scaling_upper_limit  = x_get_option( 'x_root_font_size_scaling_upper_limit' );
$x_body_font_size                      = x_get_option( 'x_body_font_size' );
$x_body_font_color                     = x_post_css_value( x_get_option( 'x_body_font_color' ), 'color' );
$x_content_font_size_rem               = x_coerce_value( x_get_option( 'x_content_font_size_rem' ), 'rem' );
$x_headings_font_color                 = x_post_css_value( x_get_option( 'x_headings_font_color' ), 'color' );
$x_h1_letter_spacing                   = x_coerce_value( x_get_option( 'x_h1_letter_spacing' ), 'em' );
$x_h2_letter_spacing                   = x_coerce_value( x_get_option( 'x_h2_letter_spacing' ), 'em' );
$x_h3_letter_spacing                   = x_coerce_value( x_get_option( 'x_h3_letter_spacing' ), 'em' );
$x_h4_letter_spacing                   = x_coerce_value( x_get_option( 'x_h4_letter_spacing' ), 'em' );
$x_h5_letter_spacing                   = x_coerce_value( x_get_option( 'x_h5_letter_spacing' ), 'em' );
$x_h6_letter_spacing                   = x_coerce_value( x_get_option( 'x_h6_letter_spacing' ), 'em' );
$x_headings_uppercase_enable           = x_get_option( 'x_headings_uppercase_enable');
$x_headings_widget_icons_enable        = x_get_option( 'x_headings_widget_icons_enable');
$x_site_link_color                     = x_post_css_value( x_get_option( 'x_site_link_color' ), 'color' );
$x_site_link_color_hover               = x_post_css_value( x_get_option( 'x_site_link_color_hover' ), 'color' );
$x_logo_width                          = x_coerce_value( x_get_option( 'x_logo_width' ), 'px' );
$x_logo_font_family                    = x_get_option( 'x_logo_font_family' );
$x_logo_font_size                      = x_coerce_value( x_get_option( 'x_logo_font_size' ), 'px' );
$x_logo_font_weight_and_style          = x_get_option( 'x_logo_font_weight' );
$x_logo_font_color                     = x_post_css_value( x_get_option( 'x_logo_font_color' ), 'color' );
$x_logo_letter_spacing                 = x_coerce_value( x_get_option( 'x_logo_letter_spacing' ), 'em' );
$x_logo_uppercase_enable               = x_get_option( 'x_logo_uppercase_enable');
$x_navbar_font_size                    = x_coerce_value( x_get_option( 'x_navbar_font_size' ), 'px' );
$x_navbar_link_color                   = x_post_css_value( x_get_option( 'x_navbar_link_color' ), 'color' );
$x_navbar_link_color_hover             = x_post_css_value( x_get_option( 'x_navbar_link_color_hover' ), 'color' );
$x_navbar_letter_spacing               = x_coerce_value( x_get_option( 'x_navbar_letter_spacing' ), 'em' );

if ( x_get_option( 'x_enable_font_manager' ) ) {

  $x_body_font_is_italic     = x_get_option( 'x_body_font_italic' );
  $x_headings_font_is_italic = x_get_option( 'x_headings_font_italic' );
  $x_logo_font_is_italic     = x_get_option( 'x_logo_font_italic' );
  $x_navbar_font_is_italic   = x_get_option( 'x_navbar_font_italic' );

  $x_body_font_family_selection = x_get_option( 'x_body_font_family_selection' );
  $x_headings_font_family_selection = x_get_option( 'x_headings_font_family_selection' );
  $x_logo_font_family_selection = x_get_option( 'x_logo_font_family_selection' );
  $x_navbar_font_family_selection = x_get_option( 'x_navbar_font_family_selection' );


  $x_body_font_weight     = x_post_css_value( $x_body_font_family_selection . '|' . x_get_option( 'x_body_font_weight_selection' ), 'font-weight');
  $x_headings_font_weight = x_post_css_value( $x_headings_font_family_selection . '|' . x_get_option( 'x_headings_font_weight_selection' ), 'font-weight');
  $x_logo_font_weight     = x_post_css_value( $x_logo_font_family_selection . '|' . x_get_option( 'x_logo_font_weight_selection' ), 'font-weight');
  $x_navbar_font_weight   = x_post_css_value( $x_navbar_font_family_selection . '|' . x_get_option( 'x_navbar_font_weight_selection' ), 'font-weight');

  $x_body_font_stack     = x_post_css_value( $x_body_font_family_selection, 'font-family');
  $x_headings_font_stack = x_post_css_value( $x_headings_font_family_selection, 'font-family');
  $x_logo_font_stack     = x_post_css_value( $x_logo_font_family_selection, 'font-family');
  $x_navbar_font_stack   = x_post_css_value( $x_navbar_font_family_selection, 'font-family');

} else {

  //
  // 1. Load font options
  // 2. Check if fonts are italic.
  // 3. Remove 'italic' from setting output if it exists to provide us with just
  //    the weight to work with.
  // 4. Get the font stack.
  //

  $x_body_font_family                    = x_get_option( 'x_body_font_family' );
  $x_body_font_weight_and_style          = x_get_option( 'x_body_font_weight' );
  $x_headings_font_family                = x_get_option( 'x_headings_font_family' );
  $x_headings_font_weight_and_style      = x_get_option( 'x_headings_font_weight' );
  $x_navbar_font_family                  = x_get_option( 'x_navbar_font_family' );
  $x_navbar_font_weight_and_style        = x_get_option( 'x_navbar_font_weight' );

  $x_body_font_is_italic                 = x_is_font_italic( $x_body_font_weight_and_style );
  $x_headings_font_is_italic             = x_is_font_italic( $x_headings_font_weight_and_style );
  $x_logo_font_is_italic                 = x_is_font_italic( $x_logo_font_weight_and_style );
  $x_navbar_font_is_italic               = x_is_font_italic( $x_navbar_font_weight_and_style );

  $x_body_font_weight                    = x_get_font_weight( $x_body_font_weight_and_style );
  $x_headings_font_weight                = x_get_font_weight( $x_headings_font_weight_and_style );
  $x_logo_font_weight                    = x_get_font_weight( $x_logo_font_weight_and_style );
  $x_navbar_font_weight                  = x_get_font_weight( $x_navbar_font_weight_and_style );

  $x_body_font_stack                     = x_get_font_data( $x_body_font_family, 'stack' );
  $x_headings_font_stack                 = x_get_font_data( $x_headings_font_family, 'stack' );
  $x_logo_font_stack                     = x_get_font_data( $x_logo_font_family, 'stack' );
  $x_navbar_font_stack                   = x_get_font_data( $x_navbar_font_family, 'stack' );

}



// Header
// =============================================================================

// $x_navbar_positioning                  = x_get_navbar_positioning();
$x_logo_adjust_navbar_top              = x_coerce_value( x_get_option( 'x_logo_adjust_navbar_top' ), 'px' );
$x_logo_adjust_navbar_side             = x_coerce_value( x_get_option( 'x_logo_adjust_navbar_side' ), 'px' );
$x_logo_navigation_layout              = x_get_option( 'x_logo_navigation_layout' );
$x_logobar_adjust_spacing_top          = x_coerce_value( x_get_option( 'x_logobar_adjust_spacing_top' ), 'px' );
$x_logobar_adjust_spacing_bottom       = x_coerce_value( x_get_option( 'x_logobar_adjust_spacing_bottom' ), 'px' );
$x_navbar_width                        = x_coerce_value( x_get_option( 'x_navbar_width' ), 'px' );
$x_navbar_height                       = x_coerce_value( x_get_option( 'x_navbar_height' ), 'px' );
$x_navbar_adjust_links_top             = x_coerce_value( x_get_option( 'x_navbar_adjust_links_top' ), 'px' );
$x_navbar_adjust_links_side            = x_coerce_value( x_get_option( 'x_navbar_adjust_links_side' ), 'px' );
$x_navbar_adjust_links_top_spacing     = x_coerce_value( x_get_option( 'x_navbar_adjust_links_top_spacing' ), 'px' );
$x_navbar_adjust_button                = x_coerce_value( x_get_option( 'x_navbar_adjust_button' ), 'px' );
$x_navbar_adjust_button_size           = x_coerce_value( x_get_option( 'x_navbar_adjust_button_size' ), 'px' );
// $x_header_widget_areas                 = x_get_option( 'x_header_widget_areas' );
$x_widgetbar_button_background         = x_post_css_value( x_get_option( 'x_widgetbar_button_background' ), 'color' );
$x_widgetbar_button_background_hover   = x_post_css_value( x_get_option( 'x_widgetbar_button_background_hover' ), 'color' );



// Buttons
// =============================================================================

$x_button_style                        = x_get_option( 'x_button_style' );
$x_button_shape                        = x_get_option( 'x_button_shape' );
$x_button_size                         = x_get_option( 'x_button_size' );
$x_button_color                        = x_post_css_value( x_get_option( 'x_button_color' ), 'color' );
$x_button_background_color             = x_post_css_value( x_get_option( 'x_button_background_color' ), 'color' );
$x_button_border_color                 = x_post_css_value( x_get_option( 'x_button_border_color' ), 'color' );
$x_button_bottom_color                 = x_post_css_value( x_get_option( 'x_button_bottom_color' ), 'color' );
$x_button_color_hover                  = x_post_css_value( x_get_option( 'x_button_color_hover' ), 'color' );
$x_button_background_color_hover       = x_post_css_value( x_get_option( 'x_button_background_color_hover' ), 'color' );
$x_button_border_color_hover           = x_post_css_value( x_get_option( 'x_button_border_color_hover' ), 'color' );
$x_button_bottom_color_hover           = x_post_css_value( x_get_option( 'x_button_bottom_color_hover' ), 'color' );

?>
