<?php

if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! class_exists( 'WPGMP_Integration_MetaPixel' ) ) {

	class WPGMP_Integration_MetaPixel {

		public function __construct() {
			add_filter( 'wpgmp_integrations_list', [ $this, 'register_extension' ] );
			add_filter( 'wpgmp_integration_nav_metapixel', [ $this, 'register_nav_tabs' ] );
			add_action( 'wpgmp_render_integration_metapixel_settings', [ $this, 'render_settings_tab' ] );
			add_action( 'wpgmp_render_integration_metapixel_help', [ $this, 'render_help_tab' ] );
			add_action( 'wp_footer', [ $this, 'inject_tracking_script' ] );
		}

		public function register_extension( $integrations ) {
			$integrations['metapixel'] = [
				'title' => __( 'Meta Pixel', 'wpgmp-google-map' ),
				'slug'  => 'metapixel',
			];
			return $integrations;
		}

		public function register_nav_tabs( $tabs ) {
			return [
				'settings' => __( 'Settings', 'wpgmp-google-map' ),
				'help'     => __( 'Help', 'wpgmp-google-map' ),
			];
		}

		public function render_settings_tab() {
			echo '<div class="fc-box">';
			echo '<h3>' . esc_html__( 'Meta Pixel Settings', 'wpgmp-google-map' ) . '</h3>';
			echo '<p>' . esc_html__( 'Enable marker click tracking via Facebook Pixel.', 'wpgmp-google-map' ) . '</p>';

			$form_fields = [
				[
					'type'  => 'checkbox',
					'name'  => 'metapixel_enable_marker_click',
					'label' => __( 'Enable Marker Click Tracking', 'wpgmp-google-map' ),
					'desc'  => __( 'Trigger Facebook Pixel event when a marker is clicked.', 'wpgmp-google-map' ),
				],
			];

			$form = new WPGMP_Integration_Form( 'metapixel', $form_fields );
			$form->render_form();

			echo '</div>';
		}

		public function render_help_tab() {
			echo '<div class="fc-box">';
			echo '<h3>' . esc_html__( 'Help & Instructions', 'wpgmp-google-map' ) . '</h3>';
			echo '<p>' . esc_html__( 'This integration sends marker click events to Facebook Pixel. Make sure your site has the Meta Pixel base code installed.', 'wpgmp-google-map' ) . '</p>';
			echo '<p><strong>Pixel Event Name:</strong> <code>MarkerClick</code></p>';
			echo '</div>';
		}

		public function inject_tracking_script() {
			$extension_key = 'metapixel';
			$enabled = false;

			$all_data = maybe_unserialize( get_option( 'wpgmp_integrations_data' ) );

			if (
				is_array( $all_data ) &&
				isset( $all_data[ $extension_key ]['metapixel_enable_marker_click'] ) &&
				in_array( $all_data[ $extension_key ]['metapixel_enable_marker_click'], [ '1', 1, true ], true )
			) {
				$enabled = true;
			}

			if ( ! $enabled ) return;
			?>
			<script>
			(function ($, window) {
				if (typeof fbq !== 'function') {
					console.warn("Meta Pixel (fbq) not found. Marker click tracking skipped.");
					return;
				}

				$(document).on("wpgmp_marker_clicked", function (e, mapObj, place) {
					if (!mapObj || !place) return;
					fbq('trackCustom', 'MarkerClick', {
						map_id: mapObj.map_data?.map_property?.map_id || 'unknown',
						marker_id: place.id || 'unknown',
						marker_title: place.title || '',
						provider: mapObj.map_data?.provider || 'unknown'
					});
				});
			})(jQuery, window);
			</script>
			<?php
		}
	}
}

new WPGMP_Integration_MetaPixel();
