<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'WPGMP_Integration_GA4' ) ) {

	class WPGMP_Integration_GA4 {

		public function __construct() {
			add_filter( 'wpgmp_integrations_list', [ $this, 'register_extension' ] );
			add_filter( 'wpgmp_integration_nav_ga4', [ $this, 'register_nav_tabs' ] );
			add_action( 'wpgmp_render_integration_ga4_settings', [ $this, 'render_settings_tab' ] );
			add_action( 'wpgmp_render_integration_ga4_help', [ $this, 'render_help_tab' ] );
			add_action( 'wp_footer', [ $this, 'inject_tracking_script' ] );
		}

		public function register_extension( $integrations ) {
			$integrations['ga4'] = [
				'title' => __( 'Google Analytics 4', 'wpgmp-google-map' ),
				'slug'  => 'ga4',
			];
			return $integrations;
		}

		public function register_nav_tabs( $tabs ) {
			return [
				'settings' => __( 'Settings', 'wpgmp-google-map' ),
				'help'     => __( 'Help', 'wpgmp-google-map' ),
			];
		}

		public function render_settings_tab() {
			echo '<div class="fc-box">';
			echo '<h3>' . esc_html__( 'GA4 Integration Settings', 'wpgmp-google-map' ) . '</h3>';
			echo '<p>' . esc_html__( 'Enable or disable Google Analytics 4 event tracking for maps.', 'wpgmp-google-map' ) . '</p>';
		
			$form_fields = [
				[
					'type'  => 'checkbox',
					'name'  => 'ga4_enable_marker_click',
					'label' => __( 'Enable Marker Click Tracking', 'wpgmp-google-map' ),
					'desc'  => __( 'Track marker_click events in Google Analytics when users click a marker.', 'wpgmp-google-map' ),
				],
			];
		
			$form = new WPGMP_Integration_Form( 'ga4', $form_fields );
			$form->render_form();
		
			echo '</div>';
		}

		public function render_help_tab() {
			echo '<div class="fc-box">';
			echo '<h3>' . esc_html__( 'Help & Instructions', 'wpgmp-google-map' ) . '</h3>';
			echo '<p>' . esc_html__( 'This integration sends events like marker clicks, direction generation, and filter usage to Google Analytics 4.', 'wpgmp-google-map' ) . '</p>';
			echo '<p>' . esc_html__( 'Tracked Events: marker_click, directions_generated, map_filters_applied.', 'wpgmp-google-map' ) . '</p>';
			echo '</div>';
		}

		public function inject_tracking_script() {
			$extension_key = 'ga4';
			$enabled = false;
		
			$all_data = maybe_unserialize( get_option( 'wpgmp_integrations_data' ) );
		
			if (
				is_array( $all_data ) &&
				isset( $all_data[ $extension_key ]['ga4_enable_marker_click'] ) &&
				in_array( $all_data[ $extension_key ]['ga4_enable_marker_click'], [ '1', 1, true ], true )
			) {
				$enabled = true;
			}
		
			if ( ! $enabled ) {
				return; // Marker click tracking is disabled
			}
			?>
			<script>
			(function ($, window) {
				if (typeof gtag !== 'function') {
					console.warn("GA4 tag not found — tracking skipped.");
					return;
				}
		
				$(document).on("wpgmp_marker_clicked", function (e, mapObj, place) {
					if (!mapObj || !place) return;
					gtag('event', 'marker_click', {
						map_id: mapObj.map_data?.map_property?.map_id || 'unknown',
						marker_id: place.id || 'unknown',
						marker_title: place.title || '',
						provider: mapObj.map_data?.provider || 'unknown'
					});
				});
			})(jQuery, window);
			</script>
			<?php
		}
		
		
		
		
	}
}

new WPGMP_Integration_GA4();
