<?php

if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! class_exists( 'WPGMP_Integration_Clarity' ) ) {

	class WPGMP_Integration_Clarity {

		public function __construct() {
			add_filter( 'wpgmp_integrations_list', [ $this, 'register_extension' ] );
			add_filter( 'wpgmp_integration_nav_clarity', [ $this, 'register_nav_tabs' ] );
			add_action( 'wpgmp_render_integration_clarity_settings', [ $this, 'render_settings_tab' ] );
			add_action( 'wpgmp_render_integration_clarity_help', [ $this, 'render_help_tab' ] );
			add_action( 'wp_footer', [ $this, 'inject_tracking_script' ] );
		}

		public function register_extension( $integrations ) {
			$integrations['clarity'] = [
				'title' => __( 'Microsoft Clarity', 'wpgmp-google-map' ),
				'slug'  => 'clarity',
			];
			return $integrations;
		}

		public function register_nav_tabs( $tabs ) {
			return [
				'settings' => __( 'Settings', 'wpgmp-google-map' ),
				'help'     => __( 'Help', 'wpgmp-google-map' ),
			];
		}

		public function render_settings_tab() {
			echo '<div class="fc-box">';
			echo '<h3>' . esc_html__( 'Microsoft Clarity Settings', 'wpgmp-google-map' ) . '</h3>';
			echo '<p>' . esc_html__( 'Enable marker click tracking using Clarity custom events.', 'wpgmp-google-map' ) . '</p>';

			$form_fields = [
				[
					'type'  => 'checkbox',
					'name'  => 'clarity_enable_marker_click',
					'label' => __( 'Enable Marker Click Tracking', 'wpgmp-google-map' ),
					'desc'  => __( 'Send a Clarity custom event on marker click.', 'wpgmp-google-map' ),
				],
			];

			$form = new WPGMP_Integration_Form( 'clarity', $form_fields );
			$form->render_form();

			echo '</div>';
		}

		public function render_help_tab() {
			echo '<div class="fc-box">';
			echo '<h3>' . esc_html__( 'Help & Instructions', 'wpgmp-google-map' ) . '</h3>';
			echo '<p>' . esc_html__( 'This integration sends "MarkerClick" events to Microsoft Clarity. You must first install the Clarity tracking script in your site header.', 'wpgmp-google-map' ) . '</p>';
			echo '<p><strong>Clarity Event Name:</strong> <code>MarkerClick</code></p>';
			echo '</div>';
		}

		public function inject_tracking_script() {
			$extension_key = 'clarity';
			$enabled = false;

			$all_data = maybe_unserialize( get_option( 'wpgmp_integrations_data' ) );

			if (
				is_array( $all_data ) &&
				isset( $all_data[ $extension_key ]['clarity_enable_marker_click'] ) &&
				in_array( $all_data[ $extension_key ]['clarity_enable_marker_click'], [ '1', 1, true ], true )
			) {
				$enabled = true;
			}

			if ( ! $enabled ) return;
			?>
			<script>
			(function ($, window) {
				if (typeof clarity !== 'function') {
					console.warn("Microsoft Clarity not found. Marker click event will not fire.");
					return;
				}

				$(document).on("wpgmp_marker_clicked", function (e, mapObj, place) {
					if (!mapObj || !place) return;
					clarity('event', 'MarkerClick');
				});
			})(jQuery, window);
			</script>
			<?php
		}
	}
}

new WPGMP_Integration_Clarity();
