<?php
/**
 * This is file for enhance tracking.
 *
 * @package Woocommerce_Order_Tracker.
 */

// Creation of shipment tracking courier list array.
$wps_tofwp_courier_companies = array();
$wps_tofwp_courier_companies = array(
	'DHL'                   => 'http://www.dhl.com/en/express/tracking.shtml?AWB=',
	'UPS'                   => 'https://wwwapps.ups.com/WebTracking/track?track=yes&trackNums=',
	'USPS'                  => 'https://tools.usps.com/go/TrackConfirmAction?tRef=fullpage&tLc=5&text28777=&tLabels=',
	'FedEx'                 => 'https://www.fedex.com/apps/fedextrack/?action=track&trackingnumber=',
	'RoyalMail'             => 'https://www.royalmail.com/track-your-item#/',
	'AustraliaPost'         => 'https://auspost.com.au/mypost/track/#/search',
	'IMEX'                  => 'http://dm.mytracking.net/IMEX/track/TrackDetails.aspx?t=',
	'OnTrac'                => 'https://www.ontrac.com/tracking.asp?trackingres=submit&tracking_number=',
	'parcelForce'           => 'https://www.parcelforce.com/track',
	'Dpd'                   => 'https://www.dpd.co.uk/apps/tracking/?reference=',
	'CollectPlus'           => 'https://www.collectplus.co.uk/track/',
	'TforceLogistics'       => 'http://www.tforcelogistics.com/track-a-shipment/',
	'ApcPostalLogistics'    => 'https://us.mytracking.net/APC/track/TrackDetails.aspx?t=',
	'EStes'                 => 'http://www.estes-express.com/WebApp/ShipmentTracking/',
	'CouriersPlease'        => 'https://www.couriersplease.com.au/tools-track?',
	'Dai Post'              => 'https://daiglobaltrack.com/tracking.aspx?custtracknbr=',
	'StarTrack'             => 'https://startrack.com.au/track/details/',
	'DPD Austria'           => 'http://www.mydpd.at/?f=parcel.load&p=',
	'post.at'               => 'http://www.post.at/sendungsverfolgung.php?pnum1=',
	'Associated Global Systems' => 'https://app.freightclub.com/Tracking/',
	'DHL Parcel'            => 'https://www.dhl.com/de/home/tracking/tracking-express.html?submit=1&tracking-id=',
	'Canada Post'           => 'https://www.canadapost.ca/track-reperage/en#/search?searchFor=',
	'Canpar'                => 'https://www.canpar.ca/en/tracking/track.htm?barcode=',
	'Correos Chile'         => 'https://www.correos.cl/web/guest/seguimiento-en-linea?codigos=',
	'China Post'            => 'https://www.ems.com.cn/english',
	'EMS'                   => 'https://www.ems.post/en/global-network/tracking',
	'TNT'                   => 'https://www.tnt.com/express/en_us/site/tracking.html?searchType=con&cons=',
	'Speedex Courier'       => 'http://www.speedexcourier.com/',
	'Correos Costa Rica'    => 'https://correos.go.cr/rastreo/',
	'DHL Express UK'        => 'https://www.dhl.com/gb-en/home/tracking/tracking-express.html?submit=1&tracking-id=',
	'DPD Czech Republic'    => 'https://tracking.dpd.de/parcelstatus?locale=cs_CZ&query=',
	'Chronopost'            => 'https://www.chronopost.fr/fr/chrono_suivi_search?listeNumerosLT=',
	'Colis Prive'           => 'https://www.colisprive.com/moncolis/pages/detailColis.aspx?numColis=',
	'Colissimo'             => 'https://www.laposte.fr/outils/suivre-vos-envois?code=',
	'La Poste'              => 'https://www.laposte.fr/outils/suivre-vos-envois?code=',
	'Mondial Relay'         => 'https://www.mondialrelay.fr/suivi-de-colis?numeroExpedition=&CodePostal=',
	'Deutsche Post'         => 'https://www.deutschepost.de/en/s/shipment-tracking.html?piececode=',
	'TNT UK'                => 'https://www.tnt.com/express/en_gb/site/shipping-tools/tracking.html?searchType=con&cons=',
	'TNT Reference'         => 'https://www.tnt.com/express/en_gb/site/shipping-tools/tracking.html?searchType=con&cons=',
	'DPD Germany'           => 'https://tracking.dpd.de/parcelstatus?query=&amp;locale=en_DE',
	'Hermes Germany'        => 'https://www.myhermes.de/empfangen/sendungsverfolgung/?suche=',
	'UPS Germany'           => 'https://wwwapps.ups.com/WebTracking/processInputRequest?sort_by=status&tracknums_displayed=1&TypeOfInquiryNumber=T&loc=de_DE&InquiryNumber1=',
	'Hong Kong Post'        => 'https://www.hongkongpost.hk/en/mail_tracking/index.html',
	'ABF'                   => 'https://arcb.com/tools/tracking.html',
	'Delhivery'             => 'https://www.delhivery.com/track/package/',
	'Ukraine EMS'           => 'http://dpsz.ua/en/track/ems',
	'Swiss Post'            => 'https://www.post.ch/swisspost-tracking?formattedParcelCodes=',
	'Ecom Express'          => 'https://ecomexpress.in/tracking/?awb_field=',
	'India Post'            => 'https://www.indiapost.gov.in/_layouts/15/dop.portal.tracking/trackconsignment.aspx',
	'Israel Post'           => 'https://mypost.israelpost.co.il/itemtrace?itemcode=',
	'DHL se'                => 'https://www.dhl.com/se-sv/home/tracking/tracking-freight.html?tracking-id=',
	'JP Post'               => 'https://trackings.post.japanpost.jp/services/srv/search/direct?reqCodeNo1=&searchKind=S002&locale=ja',
	'Latvia Post'           => 'https://track.pasts.lv/consignment/tracking?type=pasts&ampid=&lttrackid=&gt=&id=&type=pasts&button=Track',
	'South African Post Office' => 'http://www.southafricanpostoffice.post/index.html',
	'DPD Netherlands'       => 'https://www.dpdgroup.com/nl/mydpd/my-parcels/incoming?parcelNumber=',
	'PostNL International'  => 'https://postnl.post/track?barcodes=',
	'DPD Romania'           => 'https://tracking.dpd.ro/?shipmentNumber=',
	'Boxberry'              => 'https://boxberry.ru/tracking/',
	'Ninja Van Singapore'   => 'https://www.ninjavan.co/en-sg/?tracking_id=',
	'Singapore Post'        => 'https://www.singpost.com/track-items?trackingid=',
	'Portugal Post - CTT'   => 'https://www.ctt.pt/feapl_2/app/open/objectSearch/objectSearch.jspx?objects=',
	'PostNord Sverige AB'   => 'https://www.postnord.se/vara-verktyg/spara-brev-paket-och-pall?shipmentId=',
	'Sagawa' => 'https://k2k.sagawa-exp.co.jp/p/web/okurijosearch.do?okurijoNo=',
	'Border Express' => 'https://bexonline.borderexpress.com.au/bxo/track?consignmentNumber=',
	'Asendia UK' => 'https://tracking.asendia.com/tracking/',
	'Bluedart' => 'https://www.bluedart.com/?',
	'ELTA Courier' => 'https://www.elta-courier.gr/search?br=',
	'Aramex' => 'https://www.aramex.com/us/en/track/shipments?ShipmentNumber=',
	'Purolator' => 'https://www.purolator.com/en/app-tracker.page?pins=',
	'Turkey Post' => 'https://track.ptt.gov.tr/Track/Verify?q=',
	'SDA' => 'https://www.poste.it/cerca/index.html#/risultati-spedizioni/',
	'New Zealand Post' => 'https://www.nzpost.co.nz/tools/tracking/item/',
	'SMSA Express' => 'https://www.smsaexpress.com/sa/trackingdetails?tracknumbers0=',
	'Posten Norge' => 'https://sporing.posten.no/sporing/',
	'Emirates Post' => 'https://www.emiratespost.ae/all-services/track-a-package/step-two?q=',
	'Ceska Posta' => 'https://www.postaonline.cz/trackandtrace/-/zasilka/cislo?parcelNumbers=',
	'DHL Paket' => 'https://www.dhl.de/de/privatkunden/pakete-empfangen/verfolgen.html?idc=',
	'Loomis Express' => 'https://www.loomisexpress.com/loomship/Track/TrackStatus?wbs=',
	'CJPacket' => 'https://cjpacket.com/?trackingNumber=',
	'Serbia Post' => 'https://www.posta.rs/cir/alati/pracenje-posiljke.aspx?broj=',
	'Magyar Posta' => 'https://www.posta.hu/nyomkovetes/nyitooldal?searchvalue=',
	'Ekart' => 'https://www.ekartlogistics.com/shipmenttrack/',
	'Poste Italiane' => 'https://www.poste.it/cerca/index.html#/risultati-spedizioni/',
	'Thailand Post' => 'https://track.thailandpost.co.th/?trackNumber=',
	'Russian Post' => 'https://www.pochta.ru/tracking#',
	'Spee-Dee' => 'http://speedeedelivery.com/track-a-shipment/?v=detail&barcode=',
	'Saudi Post' => 'https://sp.com.sa/ar/tracktrace/?tid=',
	'BRT' => 'https://services.brt.it/it/tracking?OP=N&CD=',
	'CJ Logistics' => 'https://www.doortodoor.co.kr/parcel/doortodoor.do?fsp_action=PARC_ACT_002&fsp_cmd=retrieveInvNoACT&invc_no=',

	'Lion Parcel' => 'http://lionparcel.com/track/stt?q=',
	'Shadowfax' => 'https://track.shadowfax.in/track?order=new&trackingId=',
	'Yodel' => 'https://www.yodel.co.uk/tracking/',
	'Spring GDS' => 'https://www.mailingtechnology.com/tracking/?tn=',
	'Redpack' => 'https://www.redpack.com.mx/es/rastreo/?guias=',
	'DPD France' => 'https://www.dpd.fr/trace/',
	'GLS Denmark' => 'https://gls-group.eu/DK/da/find-pakke.html?match=',
	'Ninja Express' => 'https://www.ninjaxpress.co/id-id/tracking?id=',
	'Wahana' => 'https://www.wahana.com/lacak-kiriman?noresi=',
	'Pos Indonesia' => 'https://www.posindonesia.co.id/id/tracking/',
	'Gig Logistics' => 'https://www.giglogistics.com/track/',
	'Yamato' => 'http://jizen.kuronekoyamato.co.jp/jizen/servlet/crjz.b.NQ0010?id=',
	'Shree Tirupati Courier' => 'http://www.shreetirupaticourier.net/Frm_DocTrack.aspx?docno=',
	'SkyNet Worldwide Express' => 'https://sky.skynet.net/public/Tracking.aspx?guide=',
	'Skynet' => 'https://www.skynet.com.my/track/',
	'CNE Express' => 'https://www.cne.com/track/?no=',
	'Chit Chats' => 'https://chitchats.com/tracking/',
	'DPD Portugal' => 'https://dpd.pt/track-and-trace?reference=',
	'Correos Express' => 'https://s.correosexpress.com/SeguimientoSinCP/search?shippingNumber=',
	'NZ Couriers' => 'https://tools.nzcouriers.co.nz/nzc/servlet/ITNG_TAndTServlet?page=1&VCCA=Enabled&Key_Type=BarCode&barcode_data=',
	'Finland Post' => 'https://www.posti.fi/en/tracking#/lahetys/',
	'Nacex' => 'https://www.nacex.es/seguimientoFormularioExterno.do?intcli=',
	'Post Haste' => 'https://www.posthaste.co.nz/phl/servlet/ITNG_TAndTServlet?page=1&VCCA=Enabled&Key_Type=BarCode&barcode_data=',
	'Global Order Tracking' => 'https://global.cainiao.com/detail.htm?mailNoList=',
	'Palletways' => 'https://track2.palletways.com/?dc_syscon=',
	'GLS France' => 'https://gls-group.eu/FR/fr/suivi-colis?match=',
	'Mail Boxes Etc' => 'https://www.mbe.es/en/tracking?c=',
	'GLS Paket' => 'https://www.gls-pakete.de/sendungsverfolgung?match=',
	'Fastway Ireland' => 'https://fastway.ie/courier-services/track-your-parcel/?l=',
	'DB Schenker' => 'https://eschenker.dbschenker.com/app/tracking-public/schenker-search?refNumber=',
	'Raben' => 'https://myraben.com/link/ShipmentInformation?Language=E01_ENGLISH&ShipmentNumber=',
	'GLS Slovenia' => 'https://gls-group.eu/SI/sl/sledenje-posiljki?match=',
	'DPD Slovenia' => 'https://www.dpdgroup.com/si/mydpd/my-parcels/incoming?parcelNumber=',
	'Bulgaria Post' => 'https://www.bgpost.bg/IPSWebTracking/IPSWeb_item_events.asp?itemid=',
	'Poczta Polska' => 'https://emonitoring.poczta-polska.pl/?numer=',
	'FedEx Poland' => 'https://www.fedex.com/fedextrack/?trknbr=',
	'Yurtici Kargo' => 'https://www.yurticikargo.com/tr/online-servisler/gonderi-sorgula?code=',
	'Aras Kargo' => 'https://kargotakip.araskargo.com.tr/mainpage.aspx?code=',
	'MNG Kargo' => 'https://kargotakip.mngkargo.com.tr/?takipNo=',
	'PTT Kargo' => 'https://gonderitakip.ptt.gov.tr/Track/Verify?q=',
	'PTT Posta' => 'https://track.ptt.gov.tr/Track/Verify?q=',
	'Dellin' => 'https://www.dellin.ru/tracker/orders/',
	'FastWay South Africa' => 'https://www.fastway.co.za/our-services/track-your-parcel?l=',
	'DPD Croatia' => 'https://www.dpdgroup.com/hr/mydpd/my-parcels/incoming?parcelNumber',
	'GLS Croatia' => 'https://gls-group.eu/HR/en/parcel-tracking?match=',
	'Jadlog' => 'https://www.jadlog.com.br/tracking?cte=',
	'Geniki Taxydromiki' => 'https://www.taxydromiki.com/track/',
	'Ninja Van Malaysia' => 'https://www.ninjavan.co/en-my/tracking?id=',
	'Seko' => 'http://harmony.myseko.com/Track/Result/',
	'Ninja Van Philippines' => 'https://www.ninjavan.co/en-ph/tracking?id=',
	'Asendia USA' => 'https://a1.asendiausa.com/tracking/?trackingnumber=',
	'Singapore Speedpost' => 'https://www.speedpost.com.sg/track-and-trace#t',
	'Servientrega' => 'https://www.servientrega.com/wps/portal/rastreo-envio/detalle?id=',
	'RPX Indonesia' => 'https://rpx.co.id/tracking?tracking_number[]=',
	'Saia' => 'https://www.saia.com/track/details;pro=',
	'Franch Express' => 'http://erpfranchexpress.com/awb_tracking2.php?keyword=',
	'ST courier' => 'https://www.erpstcourier.com/awb_tracking2.php?keyword=',
	'Qxpress' => 'http://www.qxpress.net/Customer/PopupTraceParcels?TrackingNo=',
	'Janio' => 'https://tracker.janio.asia/',
	'TCS express' => 'https://www.tcsexpress.com/track/',
	'Pakistan Post' => 'https://ep.gov.pk/emtts/EPTrack_Live.aspx?ArticleIDz=',
	'Shipa' => 'https://tracking.shipadelivery.com/?bc=',
	'InPost Paczkomaty' => 'https://inpost.pl/sledzenie-przesylek?number=',
	'The Courier Guy' => 'https://portal.thecourierguy.co.za/track?ref=',
	'PostNord Denmark' => 'https://www.postnord.dk/varktojer/track-trace?shipmentId=',
	'Teleport' => 'https://teleport.delivery/track?tracking_number=',
	'FBA Swiship USA' => 'https://www.swiship.com/track?id=',
	'Meest' => 'https://t.meest-group.com/en/',
	'Israel Post He' => 'https://mypost.israelpost.co.il/itemtrace_he?itemcode=',
	'City-Link Express' => 'https://www.citylinkexpress.com/tracking-result/?track0=',
	'FedEx FIMS' => 'http://mailviewrecipient.fedex.com/recip_package_summary.aspx?PostalID=',
	'FBA Swiship UK' => 'https://www.swiship.co.uk/track/?id=',
	'Chilexpress' => 'https://centrodeayuda.chilexpress.cl/seguimiento/',
	'BOXIT' => 'http://portal.fcx.co.il/he/Track?shipmentNumber=',
	'Slovakia Post' => 'https://tandt.posta.sk/en/items/',
	'CDEK' => 'https://www.cdek.ru/ru/tracking?order_id=',
	'J&T PH' => 'https://www.jtexpress.ph/index/query/gzquery.html?bills=',
	'wanbexpress' => 'https://tracking.wanbexpress.com/?trackingNumbers=',
	'99minutos' => 'https://tracking.99minutos.com/search/',
	'Southeastern Freight Lines' => 'https://www.sefl.com/webconnect/tracing?Type=PN&RefNum1=',
	'DPD Latvia' => 'https://www.dpdgroup.com/lv/mydpd/my-parcels/incoming?parcelNumber=',
	'GLS US' => 'https://www.gls-us.com/Trackshipment?TrackingNumbers=',
	'Asendia' => 'ttps://tracking.asendia.com/tracking/',
	'Cargoboard' => 'https://cargoboard.customer.cepra.de/Track/None?cRef=',
	'Nexive' => 'https://tracking.nexive.it/?&b=',
	'Speedy' => 'https://www.speedy.bg/en/track-shipment?shipmentNumber=',
	'Old Dominion' => 'https://www.odfl.com/Trace/standardResult.faces?pro=',
	'Orian' => 'https://www.orian.com/OrianBarcodeTracking/?barcode=',
	'DHL Parcel Spain' => 'https://clientesparcel.dhl.es/LiveTracking/ModificarEnvio/',
	'BEST Express MY' => 'https://www.best-inc.my/track?bills=',
	'Fetchr' => 'https://track.fetchr.us/track/',
	'Pitt Ohio' => 'https://pittohio.com/myPittOhio/Shipping/LTL/TraceRequest?pro=',
	'Udaan Express' => 'https://udaanexpress.com/track/',
	'Kerry Express TH' => 'https://th.kerryexpress.com/en/track/?track=',
	'Kerry Express VN' => 'https://kerryexpress.com.vn/trang-thai-don-hang?trackingid=',
	'Sunyou' => 'https://www.sypost.net/search?orderNo=',
	'J&T CN' => 'https://www.jtexpress.com.cn/service.html?indexIpt=',
	'J&T TH' => 'https://www.jtexpress.co.th/index/query/gzquery.html?bills=',
	'J&T VN' => 'https://jtexpress.vn/track?billcodes=',
	'PostNord Norge' => 'https://www.postnord.no/pakkesporing?shipmentId=',
	'Pgeon' => 'https://www.pgeon.delivery/track-parcel?awb_no=',
	'Yodel Direct' => 'https://www.yodeldirect.co.uk/tracking/',
	'Overseas Express' => 'https://is.overseas.hr/tracking/?trackingid=',
	'GAP AKIS EXPRESS' => 'https://gapakisexpress.com/track-your-packages/?tracking_num=',
	'CJ Logistics Malaysia' => 'https://mysgnexs.cjlogistics-global.com/web/g_tracking_eng.jsp?slipno=',
	'GLS Ireland' => 'https://gls-group.eu/IE/en/parcel-tracking.html?match=',
	'J&T MY' => 'https://www.jtexpress.my/tracking/',
	'PosLaju' => 'https://tracking.pos.com.my/tracking/',
	'Giao Hàng Nhanh' => 'https://donhang.ghn.vn/?order_code=',
	'UPS UK' => 'https://www.ups.com/track?loc=en_GB&tracknum=',
	'GoJavas' => 'p://gojavas.com/docket_details.php?pop=docno&docno=',
	'Bombino Express' => 'https://www.bombinoexp.com/track.aspx?AwbNo=',
	'Grand Slam Express' => 'http://grandslamexpress.in/Web/Track?AwbNo=',
	'Lexship' => 'https://track.lexship.com/track?tracking_id=',
	'Bombax' => 'https://bombax.in/booking/Tracking?OrderNo=',
	'Amazon Shipping IN' => 'https://track.amazon.in/tracking/%number%?trackingId=',

);


if ( empty( get_option( 'mwb_tyo_courier_companies', false ) ) ) {
	update_option( 'mwb_tyo_courier_companies', $wps_tofwp_courier_companies );

}

	// update_option( 'mwb_tyo_courier_default_company', $wps_tofwp_courier_companies );.
	$wps_tofwp_courier_companies = get_option( 'mwb_tyo_courier_companies', false );

if ( isset( $_POST['save'] ) && check_admin_referer( 'admin_save_data', 'wps_tabs_nonce' ) ) {

	$wps_tofwp_general_settings = array();
	$wps_tofwp_enable_plugin = isset( $_POST['mwb_tyo_tracking_enable'] ) ? sanitize_text_field( wp_unslash( $_POST['mwb_tyo_tracking_enable'] ) ) : '';

	$selected_keys = isset( $_POST['wps_tofwp_courier_url_keys'] ) ? map_deep( wp_unslash( (array) $_POST['wps_tofwp_courier_url_keys'] ), 'sanitize_text_field' ) : array();

	$wps_tofwp_shipment_tracking_providers_url = array();
	foreach ( $selected_keys as $carrier_key ) {
		if ( isset( $wps_tofwp_courier_companies[ $carrier_key ] ) ) {
			$wps_tofwp_shipment_tracking_providers_url[ $carrier_key ] = $wps_tofwp_courier_companies[ $carrier_key ];
		}
	}

	$wps_tofwp_general_settings = array(
		'enable_plugin'  => $wps_tofwp_enable_plugin,
		'providers_data' => $wps_tofwp_shipment_tracking_providers_url,
	);

	update_option( 'mwb_tyo_general_settings_saved', $wps_tofwp_general_settings );
}
?>
<form action="" method="POST" class="wps-tofw-gen-section-form">
	<div class="tofw-secion-wrap">
<?php
   $wps_tofwp_general_settings_data = get_option( 'mwb_tyo_general_settings_saved', false );
   $wps_tofwp_courier_default_company = get_option( 'mwb_tyo_courier_default_company', false );


$saved_settings = get_option( 'mwb_tyo_general_settings_saved' );
$saved_providers = isset( $saved_settings['providers_data'] ) ? $saved_settings['providers_data'] : array();
?>
<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<div class="wps_tofwp_wrapper">

<div class="mwb_tyo_section">

			<table class="form-table">

								<tbody><tr class="">
									<th scope="row" class="titledesc"><?php esc_html_e( 'Enable Enhance Tracking', 'woocommerce-order-tracker' ); ?><?php
				$tip_message = __( 'Enable this option to track orders through various carrier platforms.', 'woocommerce-order-tracker' );
				echo wp_kses_post( wc_help_tip( $tip_message ) );
				?></th>
									<td class="forminp forminp-checkbox "><input type="checkbox" name="mwb_tyo_tracking_enable" id="mwb_tyo_tracking_enable" <?php isset( $saved_settings['enable_plugin'] ) ? checked( 						'on', $saved_settings['enable_plugin'] ) : ''; ?> >
									</td>
								</tr>
							</tbody>
						</table>
		</div>

	   
	<!-- Styles for better UI -->

	<!-- Select Dropdown -->
<div class="wps-select-wrapper">
	<label for="wps_tofwp_courier_url_keys" style="font-size: 15px !important;"><?php echo esc_html__( 'Choose Courier Providers', 'woocommerce-order-tracker' ); ?><?php $tip_message = __( 'Select the courier service through which you want to track orders.', 'woocommerce-order-tracker' );
	echo wp_kses_post( wc_help_tip( $tip_message ) );?></label>
	<select name="wps_tofwp_courier_url_keys[]" id="wps_tofwp_courier_url_keys" multiple>
		<?php foreach ( $wps_tofwp_courier_companies as $key => $url ) : ?>
			<option value="<?php echo esc_attr( $key ); ?>" <?php selected( array_key_exists( $key, $saved_providers ), true ); ?>>
				<?php echo esc_html( $key ); ?>
			</option>
		<?php endforeach; ?>
	</select>
</div>

<!-- Display Selected Providers -->
<?php
$plugin_url = plugin_dir_url( __FILE__ );
$icon_path  = $plugin_url . 'icons/';
?>

<?php if ( ! empty( $saved_providers ) ) : ?>
	<h4 style="font-size: 15px; font-weight: 600; margin-bottom: 18px;"><?php echo esc_html__( 'Selected Providers', 'woocommerce-order-tracker' ); ?><?php $tip_message = __( 'These are selected  courier service through which you want to track orders.', 'woocommerce-order-tracker' );
	echo wp_kses_post( wc_help_tip( $tip_message ) );?></h4>
	<div class="wps-provider-grid">
		<?php foreach ( $saved_providers as $name => $url ) : ?>
			<?php
			$icon_file = strtolower( str_replace( ' ', '', $name ) ) . '.png';
			$icon_full_path = plugin_dir_path( __FILE__ ) . 'icons/' . $icon_file;
			$icon_url = file_exists( $icon_full_path ) ? $icon_path . $icon_file : $icon_path . 'default.png';
			?>
			<div class="wps-provider-card">
				<img src="<?php echo esc_url( $icon_url ); ?>" alt="<?php echo esc_attr( $name ); ?>">
				<span><?php echo esc_html( $name ); ?></span>
			</div>
		<?php endforeach; ?>
	</div>
<?php endif; ?>

<!-- Panel For Adding The Shipment Tracking Couries-->
<div class="wb_enhanced_tyo_table_wrapper">
<table class="wps-form-table-tow form-table">
  <tr>
	   <th><?php esc_html_e( 'Add Shipment Tracking Provide Name', 'woocommerce-order-tracker' ); ?></th>
		<td>
			
			<div class="mwb_enhanced_tyo_provider">

				<div class="mwb_enhanced_tyo_add-wrap">
					<?php
					$tip_description = __( 'Enter Providers name you are going to use like PostNl Shipping, Express Shipping etc.', 'woocommerce-order-tracker' );
					echo wp_kses_post( wc_help_tip( $tip_description ) );
					?>
					<label><?php esc_html_e( 'Provider Name', 'woocommerce-order-tracker' ); ?></label>

					<input type="text" name="mwb_enhanced_tyo_add_prodvider" class="mwb_toy_enhanced_provider" value="">
				</div>

				<div class="wps_enhanced_tofwp_add-wrap">
					<?php
					$tip_descriptions = __( 'Enter Providers Tracking Page Url from where your customer can track thier packages.', 'woocommerce-order-tracker' );
					echo wp_kses_post( wc_help_tip( $tip_descriptions ) );
					?>
					<label><?php esc_html_e( 'Provider tracking Page Url', 'woocommerce-order-tracker' ); ?></label>

					<div class="mwb_enhanced_tyo_add-inner-wrap">
						<input type="text" name="mwb_enhanced_tyo_add_prodvider" class='mwb_toy_enhanced_provider_url' value="">
						<input type="button" id='mwb_tyo_enhanced_woocommerce_shipment_tracking_add_providers' value="<?php esc_attr_e( 'Add', 'woocommerce-order-tracker' ); ?>" class="button">
					</div>
				</div>
			</div>
	   </td>
   </tr>
</table>
</div> 
</div> 
<?php
wp_nonce_field( 'admin_save_data', 'wps_tabs_nonce' );
?>
</form>
<script>
	jQuery(document).ready(function($) {
	$('select[name="wps_tofwp_courier_url_keys[]"]').select2({
		placeholder: 'Select courier providers'
	});
});
</script>
<style>
	.wps-select-wrapper {
		margin-bottom: 25px;
	}

	.wps-select-wrapper label {
		display: block;
		font-weight: 600;
		margin-bottom: 8px;
		font-size: 1rem;
		color: #333;
	}

	select[name="wps_tofwp_courier_url_keys[]"] {
		width: 100%;
		height: 220px;
		padding: 10px;
		border: 1px solid #ccc;
		border-radius: 6px;
		font-size: 0.95rem;
		background-color: #fafafa;
		transition: border-color 0.3s ease;
	}

	select[name="wps_tofwp_courier_url_keys[]"]:focus {
		border-color: #0073aa;
		outline: none;
		background-color: #fff;
	}

	.wps-provider-grid {
		display: flex;
		flex-wrap: wrap;
		gap: 16px;
	}

	.wps-provider-card {
		flex: 1 1 160px;
		max-width: 180px;
		min-height: 170px;
		display: flex;
		flex-direction: column;
		align-items: center;
		justify-content: center;
		background: #fff;
		border: 1px solid #e0e0e0;
		border-radius: 12px;
		box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
		padding: 15px;
		text-align: center;
		transition: transform 0.2s ease, box-shadow 0.2s ease;
	}

	.wps-provider-card:hover {
		transform: translateY(-4px);
		box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
	}

	.wps-provider-card img {
		width: 55px;
		height: 55px;
		object-fit: contain;
		margin-bottom: 12px;
	}

	.wps-provider-card span {
		font-weight: 600;
		font-size: 0.95rem;
		color: #222;
	}
	.wps_enhanced_tofwp_add-wrap {
    display: inline-block;
}

.wb_enhanced_tyo_table_wrapper #mwb_tyo_enhanced_woocommerce_shipment_tracking_add_providers {
    margin: 0;
}

	
</style>