<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class VI_WNOTIFICATION_Admin_System {

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'menu_page' ) );
        add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );
	}

	public function page_callback() { ?>
		<h2><?php esc_html_e( 'System Status', 'woocommerce-notification' ) ?></h2>
		<table id="status" class="widefat">
			<tbody>

			<tr>
				<td data-export-label="<?php esc_html_e( 'Log Directory Writable', 'woocommerce-notification' ) ?>"><?php esc_html_e( 'Log Directory Writable', 'woocommerce-notification' ) ?></td>
                <?php
                if ( @fopen( VI_WNOTIFICATION_CACHE . 'test-log.log', 'a' ) ) { // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_fopen
                    echo '<td><i class="check green icon"></i></td>';
                    echo '<td><code>' . esc_html(VI_WNOTIFICATION_CACHE ) . '</code></td> ';
                } else {
                    echo '<td><i class="cancel red icon"></i></td>';
                    /* translators: %1$s: Cache path, %2$s: Cache constant variable*/
                    echo '<td>' . sprintf( esc_html__( 'To allow logging, make %1$s writable or define a custom %2$s.', 'woocommerce-notification' ), '<code>'. wp_kses_post( VI_WNOTIFICATION_CACHE ).'</code>','<code>VI_WNOTIFICATION_CACHE</code>' ) . '</td>';
                }
                ?>
			</tr>
			<tr>
				<td data-export-label="file_get_contents">file_get_contents</td>
				<td>
					<?php
					if ( function_exists( 'file_get_contents' ) ) {
                        echo '<i class="check green icon"></i>';
					} else {
                        echo '<i class="cancel red icon"></i>';
					}
					?>
				</td>
			</tr>
			<tr>
				<td data-export-label="file_put_contents">file_put_contents</td>
				<td>
					<?php
					if ( function_exists( 'file_put_contents' ) ) {
                        echo '<i class="check green icon"></i>';
					} else {
                        echo '<i class="cancel red icon"></i>';
					}
					?>
				</td>
			</tr>
			<tr>
				<td data-export-label="mkdir">mkdir</td>
				<td>
					<?php
					if ( function_exists( 'mkdir' ) ) {
						echo '<i class="check green icon"></i>';
					} else {
						echo '<i class="cancel red icon"></i>';
					}
					?>

				</td>
			</tr>
			</tbody>
		</table>
	<?php }

	/**
	 * Register a custom menu page.
	 */
	public function menu_page() {
		add_submenu_page(
			'woocommerce-notification',
			esc_html__( 'System Status', 'woocommerce-notification' ),
			esc_html__( 'System Status', 'woocommerce-notification' ),
			'manage_options',
			'woocommerce-notification-status',
			array( $this, 'page_callback' )
		);

	}
    
    public function admin_enqueue_scripts() {
        $page    = isset( $_REQUEST['page'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['page'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        if ( $page == 'woocommerce-notification-status' ) {
            wp_enqueue_style( 'woocommerce-notification-icon', VI_WNOTIFICATION_CSS . 'icon.min.css',array(), VI_WNOTIFICATION_VERSION );
            
        }
    }
}
