<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class VI_WNOTIFICATION_Admin_Admin {

    protected $settings;

    function __construct() {
        add_filter( 'plugin_action_links_woocommerce-notification/woocommerce-notification.php', [
            $this,
            'settings_link',
        ] );
        add_action( 'init', [ $this, 'init' ] );
        add_action( 'admin_init', [ $this, 'admin_init' ] );
        add_action( 'admin_menu', [ $this, 'menu_page' ] );
        add_action( 'admin_enqueue_scripts', [ $this, 'admin_enqueue_scripts' ], 9999999999 );
    }

    /*Check Auto update*/
    public function admin_init() {
        $key = VI_WNOTIFICATION_Admin_Settings::get_field( 'key', '' );
        /*Check update*/
        if ( class_exists( 'VillaTheme_Plugin_Check_Update' ) ) {
            new VillaTheme_Plugin_Check_Update ( VI_WNOTIFICATION_VERSION,                    // current version
                'https://villatheme.com/wp-json/downloads/v3',  // update path
                'woocommerce-notification/woocommerce-notification.php',                  // plugin file slug
                'woocommerce-notification', '5846', $key );
            $setting_url = admin_url( 'admin.php?page=woocommerce-notification' );
            new VillaTheme_Plugin_Updater( 'woocommerce-notification/woocommerce-notification.php', 'woocommerce-notification', $setting_url );
        }
    }

    public function admin_print_styles() {
        $this->settings     = VI_WNOTIFICATION_Data::get_instance( true );
        $background_image   = $this->settings->get_params( 'background_image' );
        $custom_css_setting = $this->settings->get_params( 'custom_css' );
        $custom_css         = '';
        if ( $background_image ) {
            $background_image_url = woocommerce_notification_background_images( $background_image );

            $custom_css .= "#message-purchased .message-purchase-main::before{background-image: url('{$background_image_url}');border-radius:0;}";
        }
        ?>
        <style id="woocommerce-notification-close-icon-color"></style>
        <style id="woocommerce-notification-background-image"><?php echo wp_kses_post( $custom_css ) ?></style>
        <style id="woocommerce-notification-custom-css"><?php echo wp_kses_post( $custom_css_setting ) ?></style>
        <?php
    }

    /**
     * Init Script in Admin
     */
    public function admin_enqueue_scripts() {
        $this->settings = VI_WNOTIFICATION_Data::get_instance( true );
        $page           = isset( $_REQUEST['page'] ) ? wc_clean( wp_unslash( $_REQUEST['page'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        if ( $page == 'woocommerce-notification' ) {
            add_action( 'admin_print_styles', [ $this, 'admin_print_styles' ] );

            global $wp_scripts, $wp_styles;
            $scripts = $wp_scripts->registered;
            if ( isset( $wp_styles->registered['rich-reviews'] ) ) {
                unset( $wp_styles->registered['rich-reviews'] );
                wp_dequeue_style( 'rich-reviews' );
            }
            foreach ( $scripts as $k => $script ) {
                preg_match( '/^\/wp-/i', $script->src, $result );
                if ( count( array_filter( $result ) ) ) {
                    preg_match( '/(wp-content\/plugins|wp-content\/themes)/i', $script->src, $result1 );
                    if ( count( array_filter( $result1 ) ) ) {
                        wp_dequeue_script( $script->handle );
                    }
                } else {
                    if ( $script->handle !== 'query-monitor' ) {
                        wp_dequeue_script( $script->handle );
                    }
                }
            }
            /*Compatibel with theme or plugin */
            wp_dequeue_style( 'tmpmela_tab' ); /*Theme Kinves*/
            wp_dequeue_style( 'base-admin-css' ); /*Plugin BoldGrid Inspirations*/

            /*Stylesheet*/
            wp_enqueue_style( 'woocommerce-notification-icons-close', VI_WNOTIFICATION_CSS . 'icons-close.min.css', [], VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-input', VI_WNOTIFICATION_CSS . 'input.min.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-label', VI_WNOTIFICATION_CSS . 'label.min.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-image', VI_WNOTIFICATION_CSS . 'image.min.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-transition', VI_WNOTIFICATION_CSS . 'transition.min.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-form', VI_WNOTIFICATION_CSS . 'form.min.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-icon', VI_WNOTIFICATION_CSS . 'icon.min.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-dropdown', VI_WNOTIFICATION_CSS . 'dropdown.min.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-checkbox', VI_WNOTIFICATION_CSS . 'checkbox.min.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-segment', VI_WNOTIFICATION_CSS . 'segment.min.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-menu', VI_WNOTIFICATION_CSS . 'menu.min.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-tab', VI_WNOTIFICATION_CSS . 'tab.min.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-button', VI_WNOTIFICATION_CSS . 'button.min.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-grid', VI_WNOTIFICATION_CSS . 'grid.min.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-dimmer', VI_WNOTIFICATION_CSS . 'dimmer.min.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-modal', VI_WNOTIFICATION_CSS . 'modal.min.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-table', VI_WNOTIFICATION_CSS . 'table.min.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-accordion', VI_WNOTIFICATION_CSS . 'accordion.min.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-front', VI_WNOTIFICATION_CSS . 'woocommerce-notification.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-admin', VI_WNOTIFICATION_CSS . 'woocommerce-notification-admin.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'woocommerce-notification-admin-templates', VI_WNOTIFICATION_CSS . 'woocommerce-notification-templates.css', array(), VI_WNOTIFICATION_VERSION );
            wp_enqueue_style( 'select2', VI_WNOTIFICATION_CSS . 'select2.min.css', array(), VI_WNOTIFICATION_VERSION );

            /*Script*/
            wp_enqueue_script( 'select2-v4', VI_WNOTIFICATION_JS . 'select2.js', [ 'jquery' ], '4.0.3', true );
            wp_enqueue_script( 'woocommerce-notification-dependsOn', VI_WNOTIFICATION_JS . 'dependsOn.min.js', [ 'jquery' ], VI_WNOTIFICATION_VERSION, true );
            wp_enqueue_script( 'woocommerce-notification-transition', VI_WNOTIFICATION_JS . 'transition.min.js', [ 'jquery' ], VI_WNOTIFICATION_VERSION, true );
            wp_enqueue_script( 'woocommerce-notification-faker', VI_WNOTIFICATION_JS . 'faker.min.js', [ 'jquery' ], VI_WNOTIFICATION_VERSION, true );
            wp_enqueue_script( 'woocommerce-notification-dropdown', VI_WNOTIFICATION_JS . 'dropdown.js', [ 'jquery' ], VI_WNOTIFICATION_VERSION, true );
            wp_enqueue_script( 'woocommerce-notification-checkbox', VI_WNOTIFICATION_JS . 'checkbox.js', [ 'jquery' ], VI_WNOTIFICATION_VERSION, true );
            wp_enqueue_script( 'woocommerce-notification-tab', VI_WNOTIFICATION_JS . 'tab.js', [ 'jquery' ], VI_WNOTIFICATION_VERSION, true );
            wp_enqueue_script( 'woocommerce-notification-address', VI_WNOTIFICATION_JS . 'address-1.6.min.js', [ 'jquery' ], VI_WNOTIFICATION_VERSION, true );
            wp_enqueue_script( 'woocommerce-notification-dimmer', VI_WNOTIFICATION_JS . 'dimmer.min.js', [ 'jquery' ], VI_WNOTIFICATION_VERSION, true );
            wp_enqueue_script( 'woocommerce-notification-modal', VI_WNOTIFICATION_JS . 'modal.min.js', [ 'jquery' ], VI_WNOTIFICATION_VERSION, true );
            wp_enqueue_script( 'woocommerce-notification-accordion', VI_WNOTIFICATION_JS . 'accordion.min.js', [ 'jquery' ], VI_WNOTIFICATION_VERSION, true );
            wp_enqueue_script( 'woocommerce-notification-flexslider', VI_WNOTIFICATION_JS . 'flexslider.js', [ 'jquery' ], VI_WNOTIFICATION_VERSION, true );
            wp_enqueue_script( 'woocommerce-notification-admin', VI_WNOTIFICATION_JS . 'woocommerce-notification-admin.js', [ 'jquery' ], VI_WNOTIFICATION_VERSION, true );

            /*Color picker*/
            wp_enqueue_script( 'iris', admin_url( 'js/iris.min.js' ), [ 'jquery-ui-draggable', 'jquery-ui-slider', 'jquery-touch-punch', ], false, true ); // phpcs:ignore WordPress.WP.EnqueuedResourceParameters.NoExplicitVersion

            /*Custom*/
            $highlight_color          = $this->settings->get_params( 'highlight_color' );
            $text_color               = $this->settings->get_params( 'text_color' );
            $background_color         = $this->settings->get_params( 'background_color' );
            $border_radius            = $this->settings->get_params( 'border_radius' );
            $image_border_radius      = $this->settings->get_params( 'image_border_radius' );
            $image_padding            = $this->settings->get_params( 'image_padding' );
            $close_icon_color_classic = $this->settings->get_params( 'close_icon_color_classic' );
            $close_icon_color_default = $this->settings->get_params( 'close_icon_color_default' );
            $close_icon_background    = $this->settings->get_params( 'close_icon_background' );
            $custom_css               = '#notify-close.default:before{color:' . $close_icon_color_default . ';}';
            $custom_css               .= '#notify-close.classic:before{color:' . $close_icon_color_classic . ';}';
            $custom_css               .= "#message-purchased .message-purchase-main{background-color: {$background_color};color:{$text_color};border-radius:{$border_radius}px;overflow:hidden;}.tab.segment #message-purchased a, #message-purchased .wn-notification-message-container span{color:{$highlight_color};}";
            $custom_css               .= "#message-purchased #notify-close.default{background-color:{$close_icon_background};}";
            $is_rtl                   = $this->settings->enable_rtl();
            if ( $image_padding ) {
                $padding_right = 15 - $image_padding;
                $custom_css    .= "#message-purchased .wn-notification-image-wrapper{padding:{$image_padding}px;}";
                if ( $is_rtl ) {
                    $custom_css .= "#message-purchased .wn-notification-message-container{padding-right:{$padding_right}px;}";
                } else {
                    $custom_css .= "#message-purchased .wn-notification-message-container{padding-left:{$padding_right}px;}";
                }
                $custom_css .= "#message-purchased .wn-notification-image{border-radius:{$image_border_radius}px;}";
            } else {
                $custom_css .= "#message-purchased .wn-notification-image-wrapper{padding:0;}";
                if ( $is_rtl ) {
                    $custom_css .= "#message-purchased .wn-notification-message-container{padding-right:15px;}";
                } else {
                    $custom_css .= "#message-purchased .wn-notification-message-container{padding-left:15px;}";
                }
                $custom_css .= "#message-purchased .wn-notification-image{border-radius:{$image_border_radius}px;}";
            }

            wp_add_inline_style( 'woocommerce-notification-admin', wp_kses_post( $custom_css ) );
            wp_localize_script( 'woocommerce-notification-admin', 'woocommerce_notification_admin_params', array(
                'ajaxUrl'   => admin_url( 'admin-ajax.php' ),
                'nonce'     => wp_create_nonce( 'woocommerce_notification_admin_nonce' ),
                'soundUrl' => VI_WNOTIFICATION_SOUNDS_URL,
                'warning_mask_customer_info' => __( 'Are you sure you want to disable this option? . Disabling it may expose customer names and cities to the public.', 'woocommerce-notification' ),
                'sound' => $this->settings->get_params( 'sound' ),
            ) );
        }
    }

    /**
     * Link to Settings
     *
     * @param $links
     *
     * @return mixed
     */
    public function settings_link( $links ) {
        $settings_link = '<a href="admin.php?page=woocommerce-notification" title="' . esc_html__( 'Settings', 'woocommerce-notification' ) . '">' . esc_html__( 'Settings', 'woocommerce-notification' ) . '</a>';
        array_unshift( $links, $settings_link );

        return $links;
    }

    /**
     * Function init when run plugin+
     */
    function init() {
        /*Register post type*/

        load_plugin_textdomain( 'woocommerce-notification' );
        $this->load_plugin_textdomain();
        if ( class_exists( 'VillaTheme_Support_Pro' ) ) {
            new VillaTheme_Support_Pro( [
                'support'   => 'https://villatheme.com/supports/forum/plugins/woocommerce-notification/',
                'docs'      => 'http://docs.villatheme.com/?item=woocommerce-notification',
                'review'    => 'https://codecanyon.net/downloads',
                'css'       => VI_WNOTIFICATION_CSS,
                'image'     => VI_WNOTIFICATION_IMAGES,
                'slug'      => 'woocommerce-notification',
                'menu_slug' => 'woocommerce-notification',
                'version'   => VI_WNOTIFICATION_VERSION,
            ] );
        }
    }

    /**
     * load Language translate
     */
    public function load_plugin_textdomain() {
        $locale = apply_filters( 'plugin_locale', get_locale(), 'woocommerce-notification' );
        // Admin Locale
        if ( is_admin() ) {
            load_textdomain( 'woocommerce-notification', VI_WNOTIFICATION_LANGUAGES . "woocommerce-notification-$locale.mo" );
        }

        // Global + Frontend Locale
        load_textdomain( 'woocommerce-notification', VI_WNOTIFICATION_LANGUAGES . "woocommerce-notification-$locale.mo" );
        load_plugin_textdomain( 'woocommerce-notification', false, VI_WNOTIFICATION_LANGUAGES );
    }

    /**
     * Register a custom menu page.
     */
    public function menu_page() {
        add_menu_page( esc_html__( 'WooCommerce Notification', 'woocommerce-notification' ), esc_html__( 'Woo Notification', 'woocommerce-notification' ), 'manage_options', 'woocommerce-notification', [
            'VI_WNOTIFICATION_Admin_Settings',
            'page_callback',
        ], 'dashicons-megaphone', 2 );
    }

}
