<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class VI_WOOCOMMERCE_ALIDROPSHIP_Admin_System
 */
class VI_WOOCOMMERCE_ALIDROPSHIP_Admin_Recommend {
	protected $dismiss;

	public function __construct() {
		$this->dismiss = 'wad_install_recommended_plugins_dismiss';
		add_action( 'admin_menu', array( $this, 'menu_page' ), 30 );
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );
	}

	public static function admin_notices_html( $message, $button, $plugin_slug ) {
		?>
        <div class="villatheme-dashboard updated" style="border-left: 4px solid #ffba00">
            <div class="villatheme-content">
                <form action="" method="get">
                    <p><?php echo wp_kses_post( $message ) ?></p>
                    <p><?php echo wp_kses_post( $button ) ?></p>
                    <a href="<?php echo esc_url( add_query_arg( array(
						'wad_dismiss_nonce' => wp_create_nonce( 'wad_dismiss_nonce' ),
						'plugin'            => $plugin_slug,
					) ) ) ?>" target="_self"
                       class="button notice-dismiss vi-button-dismiss"><?php esc_html_e( 'Dismiss', 'woocommerce-alidropship' ) ?></a>
                </form>
            </div>
        </div>
		<?php
	}

	public function admin_notices() {
		global $pagenow;
		$action              = isset( $_REQUEST['action'] ) ? wp_unslash( sanitize_text_field( $_REQUEST['action'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$_plugin             = isset( $_REQUEST['plugin'] ) ? wp_unslash( sanitize_text_field( $_REQUEST['plugin'] ) ) : '';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$recommended_plugins = array(
			array(
				'slug'                => 'exmage-wp-image-links',
				'pro'                 => 'exmage-wordpress-image-links',
				'name'                => 'EXMAGE – WordPress Image Links',
				'message_not_install' => __( 'Need to save your server storage? <strong>EXMAGE – WordPress Image Links</strong> will help you solve the problem by using external image URLs. </br>When this plugin is active, "Use external links for images" option will be available in the ALD plugin settings/Product which allows to use original AliExpress product image URLs for featured image, gallery images and variation image of imported AliExpress products.', 'woocommerce-alidropship' ),
				'message_not_active'  => __( '<strong>EXMAGE – WordPress Image Links</strong> is currently inactive, external images added by this plugin(Post/product featured image, product gallery images...) will no longer work properly.', 'woocommerce-alidropship' ),
			),
			array(
				'slug'                => 'woo-photo-reviews',
				'pro'                 => 'woocommerce-photo-reviews',
				'name'                => 'Photo Reviews for WooCommerce',
				'message_not_install' => __( '<strong>Photo Reviews for WooCommerce</strong> helps you send review reminder emails automatically to request a review, and lets your customer include photos in their feedback.', 'woo-alidropship' ),
				'message_not_active'  => __( '<strong>Photo Reviews for WooCommerce</strong> is currently inactive. Activate it to automatically send email to your customers to request reviews', 'woo-alidropship' ),
			),
			array(
				'slug'                => 'woo-notification',
				'pro'                 => 'woocommerce-notification',
				'name'                => 'Notification for WooCommerce',
				'message_not_install' => __( '<strong>Notification for WooCommerce</strong> display recent orders as popup notifications, boosting conversion rates by showing real-time purchase, creating urgency, and showcasing new products.', 'woo-alidropship' ),
				'message_not_active'  => __( '<strong>Notification for WooCommerce</strong> is currently inactive. Activate it to display recent orders as popup notifications', 'woo-alidropship' ),
			),
			array(
				'slug'                => 'product-variations-swatches-for-woocommerce',
				'pro'                 => 'woocommerce-product-variations-swatches',
				'name'                => 'Product Variations Swatches for WooCommerce',
				'message_not_install' => __( 'Need a variations swatches plugin that works perfectly with ALD - AliExpress Dropshipping and Fulfillment for WooCommerce? <strong>Product Variations Swatches for WooCommerce</strong> is what you need.', 'woocommerce-alidropship' ),
				'message_not_active'  => __( '<strong>Product Variations Swatches for WooCommerce</strong> is currently inactive, this prevents variable products from displaying beautifully.', 'woocommerce-alidropship' ),
			),
			array(
				'slug'                => 'bulky-bulk-edit-products-for-woo',
				'pro'                 => '',
				'name'                => 'Bulky – Bulk Edit Products for WooCommerce',
				'message_not_install' => __( 'Quickly and easily edit your products in bulk with <strong>Bulky – Bulk Edit Products for WooCommerce</strong>', 'woocommerce-alidropship' ),
				//				'message_not_active'  => __( '<strong>Bulky – Bulk Edit Products for WooCommerce</strong> is currently inactive. Activate it to quickly edit your products in bulk', 'woocommerce-alidropship' ),
			),
			array(
				'slug'                => 'email-template-customizer-for-woo',
				'pro'                 => 'woocommerce-email-template-customizer',
				'name'                => 'Email Template Customizer for WooCommerce',
				'message_not_install' => __( 'Try our brand new <strong>Email Template Customizer for WooCommerce</strong> plugin to easily customize your WooCommerce emails and make them more beautiful and professional.', 'woocommerce-alidropship' ),
				//				'message_not_active'  => __( '<strong>Email Template Customizer for WooCommerce</strong> is currently inactive. Activate it to customize WooCommerce emails with ease and make your customers more satisfied when receiving your emails.', 'woocommerce-alidropship' ),
			),
			[
				'slug'                => 'vargal-additional-variation-gallery-for-woo',
				'name'                => 'VARGAL – Additional Variation Gallery for Woo',
				'desc'                => esc_html__( 'Easily set unlimited images or MP4/WebM videos for each WC product variation and display them when the customer selects', 'woocommerce-alidropship' ),
				'message_not_install' => sprintf( "%s <strong>VARGAL – Additional Variation Gallery for Woo</strong> %s", esc_html__( 'Looking for a plugin that lets you add unlimited images or MP4/WebM videos to each WooCommerce product variation?', 'woocommerce-alidropship' ), esc_html__( 'is what you need.', 'woocommerce-alidropship' ) ),
				'message_not_active'  => sprintf( "<strong>VARGAL</strong> %s", esc_html__( 'is currently inactive, the variation gallery setting will not be set.', 'woocommerce-alidropship' ) ),
			],
		);
		$plugins             = get_plugins();
		foreach ( $recommended_plugins as $recommended_plugin ) {
			$plugin_slug = $recommended_plugin['slug'];
			if ( ! get_option( "{$this->dismiss}__{$plugin_slug}" ) ) {
				if ( ! empty( $recommended_plugin['pro'] ) && isset( $plugins["{$recommended_plugin['pro']}/{$recommended_plugin['pro']}.php"] ) ) {
					continue;
				}
				$plugin = "{$plugin_slug}/{$plugin_slug}.php";
				if ( ! isset( $plugins[ $plugin ] ) ) {
					if ( ! ( $pagenow === 'update.php' && $action === 'install-plugin' && $_plugin === $plugin_slug ) ) {
						$button = '<a href="' . esc_url( wp_nonce_url( self_admin_url( "update.php?action=install-plugin&plugin={$plugin_slug}" ), "install-plugin_{$plugin_slug}" ) ) . '" target="_self" class="button button-primary">' . esc_html__( 'Install now', 'woocommerce-alidropship' ) . '</a>';
						self::admin_notices_html( $recommended_plugin['message_not_install'], $button, $plugin_slug );
					}
				} elseif ( ! is_plugin_active( $plugin ) && ! empty( $recommended_plugin['message_not_active'] ) ) {
					$button = '<a href="' . esc_url( wp_nonce_url( add_query_arg( array(
							'action' => 'activate',
							'plugin' => $plugin
						), admin_url( 'plugins.php' ) ), "activate-plugin_{$plugin}" ) ) . '" target="_self" class="button button-primary">' . esc_html__( 'Activate now', 'woocommerce-alidropship' ) . '</a>';
					self::admin_notices_html( $recommended_plugin['message_not_active'], $button, $plugin_slug );
				}
			}
		}
	}

	public function admin_enqueue_scripts() {
		if ( isset( $_REQUEST['vi_wad_admin_nonce'] ) && ! wp_verify_nonce( wc_clean( wp_unslash( $_REQUEST['vi_wad_admin_nonce'] ) ), 'vi_wad_admin_nonce' ) ) {
			return;
		}
		global $pagenow;
		$page = isset( $_REQUEST['page'] ) ? wp_unslash( sanitize_text_field( $_REQUEST['page'] ) ) : '';
		if ( $pagenow === 'admin.php' && $page === 'woocommerce-alidropship-recommend' ) {
			wp_dequeue_style( 'eopa-admin-css' );
			wp_enqueue_style( 'vi-woocommerce-alidropship-form', VI_WOOCOMMERCE_ALIDROPSHIP_CSS . 'form.min.css', [], VI_WOOCOMMERCE_ALIDROPSHIP_VERSION );
			wp_enqueue_style( 'vi-woocommerce-alidropship-table', VI_WOOCOMMERCE_ALIDROPSHIP_CSS . 'table.min.css', [], VI_WOOCOMMERCE_ALIDROPSHIP_VERSION );
			wp_enqueue_style( 'vi-woocommerce-alidropship-icon', VI_WOOCOMMERCE_ALIDROPSHIP_CSS . 'icon.min.css', [], VI_WOOCOMMERCE_ALIDROPSHIP_VERSION );
			wp_enqueue_style( 'vi-woocommerce-alidropship-segment', VI_WOOCOMMERCE_ALIDROPSHIP_CSS . 'segment.min.css', [], VI_WOOCOMMERCE_ALIDROPSHIP_VERSION );
			wp_enqueue_style( 'vi-woocommerce-alidropship-button', VI_WOOCOMMERCE_ALIDROPSHIP_CSS . 'button.min.css', [], VI_WOOCOMMERCE_ALIDROPSHIP_VERSION );
			if ( ! wp_style_is( 'viwad-recommended_plugins' ) ) {
				wp_register_style( 'viwad-recommended_plugins', false, [], VI_WOOCOMMERCE_ALIDROPSHIP_VERSION );
				wp_enqueue_style( 'viwad-recommended_plugins' );
				wp_add_inline_style( 'viwad-recommended_plugins', '.fist-col { min-width: 300px;}.vi-wad-plugin-name {font-weight: 600;}.vi-wad-plugin-name a { text-decoration: none;}' );
			}

			/*$wad_dismiss_nonce = isset( $_REQUEST['wad_dismiss_nonce'] ) ? wp_unslash( sanitize_text_field( $_REQUEST['wad_dismiss_nonce'] ) ) : '';
			$dismiss_plugin    = isset( $_REQUEST['plugin'] ) ? wp_unslash( sanitize_text_field( $_REQUEST['plugin'] ) ) : '';
			if ( wp_verify_nonce( $wad_dismiss_nonce, 'wad_dismiss_nonce' ) ) {
				$option = $dismiss_plugin ? "{$this->dismiss}__{$dismiss_plugin}" : $this->dismiss;
				if ( ! get_option( $option ) ) {
					update_option( $option, time() );
				}
			}
			if ( ! get_option( $this->dismiss ) ) {
				add_action( 'admin_notices', array( $this, 'admin_notices' ) );
			}*/
		}
	}

	public function page_callback() {
		$plugins = VI_WOOCOMMERCE_ALIDROPSHIP_Setup_Wizard::recommended_plugins();
		?>
        <div class="">
            <h2><?php esc_html_e( 'Recommended plugins', 'woocommerce-alidropship' ) ?></h2>
            <table cellspacing="0" id="status" class="vi-ui celled table">
                <thead>
                <tr>
                    <th colspan="2"><?php esc_html_e( 'Plugins', 'woocommerce-alidropship' ); ?></th>
                    <th><?php esc_html_e( 'Description', 'woocommerce-alidropship' ); ?></th>
                </tr>
                </thead>
                <tbody>
				<?php
				$installed_plugins = get_plugins();
				foreach ( $plugins as $plugin ) {
					$plugin_id = "{$plugin['slug']}/{$plugin['slug']}.php";
					?>
                    <tr>
                        <td><a target="_blank"
                               href="<?php echo esc_url( "https://wordpress.org/plugins/{$plugin['slug']}" ) ?>"><img
                                        src="<?php echo esc_url( $plugin['img'] ) ?>" width="60" height="60"></a></td>
                        <td class="fist-col">
                            <div class="vi-wad-plugin-name">
                                <a target="_blank"
                                   href="<?php echo esc_url( "https://wordpress.org/plugins/{$plugin['slug']}" ) ?>"><strong><?php echo esc_html( $plugin['name'] ) ?></strong></a>
                            </div>
                            <div>
								<?php
								if ( ! isset( $installed_plugins[ $plugin_id ] ) ) {
									?>
                                    <a href="<?php echo esc_url( wp_nonce_url( self_admin_url( "update.php?action=install-plugin&plugin={$plugin['slug']}" ), "install-plugin_{$plugin['slug']}" ) ) ?>"
                                       target="_blank"><?php esc_html_e( 'Install', 'woocommerce-alidropship' ); ?></a>
									<?php
								} elseif ( ! is_plugin_active( $plugin_id ) ) {
									?>
                                    <a href="<?php echo esc_url( wp_nonce_url( add_query_arg( array(
										'action' => 'activate',
										'plugin' => $plugin_id
									), admin_url( 'plugins.php' ) ), "activate-plugin_{$plugin_id}" ) ) ?>"
                                       target="_blank"><?php esc_html_e( 'Activate', 'woocommerce-alidropship' ); ?></a>
									<?php
								} else {
									esc_html_e( 'Currently active', 'woocommerce-alidropship' );
								}
								?>
                            </div>
                        </td>
                        <td><?php echo esc_html( $plugin['desc'] ) ?></td>
                    </tr>
					<?php
				}
				?>
                </tbody>
            </table>
        </div>
		<?php
	}

	/**
	 * Register a custom menu page.
	 */
	public function menu_page() {
		$menu_slug = 'woocommerce-alidropship-recommend';
		add_submenu_page(
			'woocommerce-alidropship-import-list',
			esc_html__( 'Recommended plugins for ALD - AliExpress Dropshipping and Fulfillment for WooCommerce', 'woocommerce-alidropship' ),
			esc_html__( 'Recommended Plugins', 'woocommerce-alidropship' ),
			apply_filters( 'vi_wad_admin_sub_menu_capability', 'manage_options', $menu_slug ),
			$menu_slug,
			array( $this, 'page_callback' )
		);
	}
}
