<?php
/*

Plugin URI: http://www.beapi.fr
Description: Add 2 methods for WP Filter API
Version: 1.0.1
Author: BeAPI
Author URI: http://www.beapi.fr

Copyright 2012 Amaury Balmer - amaury@beapi.fr

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2, as 
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/**
 * Allow to remove method for an hook when, it's a class method used and class don't have global for instanciation !
 */
 
if (!function_exists('vartable_remove_filters_with_method_name')) {
 
  function vartable_remove_filters_with_method_name( $hook_name = '', $method_name = '', $priority = 0 ) {
    global $wp_filter;
    
    // Take only filters on right hook name and priority
    if ( !isset($wp_filter[$hook_name][$priority]) || !is_array($wp_filter[$hook_name][$priority]) )
      return false;
    
    // Loop on filters registered
    foreach( (array) $wp_filter[$hook_name][$priority] as $unique_id => $filter_array ) {
      // Test if filter is an array ! (always for class/method)
      if ( isset($filter_array['function']) && is_array($filter_array['function']) ) {
        // Test if object is a class and method is equal to param !
        if ( is_object($filter_array['function'][0]) && get_class($filter_array['function'][0]) && $filter_array['function'][1] == $method_name ) {
          unset($wp_filter[$hook_name][$priority][$unique_id]);
        }
      }
      
    }
    
    return false;
  }

}

/**
 * Allow to remove method for an hook when, it's a class method used and class don't have variable, but you know the class name :)
 */
 
if (!function_exists('vartable_remove_filters_for_anonymous_class')) {
 
  function vartable_remove_filters_for_anonymous_class( $hook_name = '', $class_name ='', $method_name = '', $priority = 0 ) {
    global $wp_filter;
    
    // Take only filters on right hook name and priority
    if ( !isset($wp_filter[$hook_name][$priority]) || !is_array($wp_filter[$hook_name][$priority]) )
      return false;
    
    // Loop on filters registered
    foreach( (array) $wp_filter[$hook_name][$priority] as $unique_id => $filter_array ) {
      // Test if filter is an array ! (always for class/method)
	  if ( isset($filter_array['function']) && is_array($filter_array['function']) ) {
        // Test if object is a class, class and method is equal to param !
        if ( is_object($filter_array['function'][0]) && get_class($filter_array['function'][0]) && get_class($filter_array['function'][0]) == $class_name && $filter_array['function'][1] == $method_name ) {
          if (isset($wp_filter[$hook_name][$priority]) && isset($wp_filter[$hook_name][$priority][$unique_id])) {
			unset($wp_filter[$hook_name][$priority][$unique_id]);
		  }
        }
      }
      
    }
    
    return false;
  }
}
?>