<?php
/**
	*
	* @author     Gaviasthemes Team     
	* @copyright  Copyright (C) 2024 Gaviasthemes. All Rights Reserved.
	* @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
	* 
*/
require_once get_template_directory() . '/inc/theme-setup.php';

define('WELOWE_THEME_DIR', get_template_directory());
define('WELOWE_THEME_URL', get_template_directory_uri());

// Include list of files of theme.
require_once(WELOWE_THEME_DIR . '/includes/functions.php'); 
require_once(WELOWE_THEME_DIR . '/includes/template.php'); 
require_once(WELOWE_THEME_DIR . '/includes/hook.php'); 
require_once(WELOWE_THEME_DIR . '/includes/comment.php'); 
require_once(WELOWE_THEME_DIR . '/includes/metaboxes.php');
require_once(WELOWE_THEME_DIR . '/includes/customize.php'); 
require_once(WELOWE_THEME_DIR . '/includes/menu.php'); 
require_once(WELOWE_THEME_DIR . '/includes/elementor/hooks.php');

//Load Woocommerce plugin
if(class_exists('WooCommerce')){
	add_theme_support('woocommerce');
	require_once(WELOWE_THEME_DIR . '/includes/woocommerce/functions.php'); 
	require_once(WELOWE_THEME_DIR . '/includes/woocommerce/hooks.php'); 
}

//Load Give
if(class_exists('Give')){
  require_once(WELOWE_THEME_DIR . '/includes/give/hooks.php'); 
}

add_action('after_setup_theme', 'welowe_after_setup_theme');
function welowe_after_setup_theme(){
	// Load Redux - Theme options framework
	if(class_exists('Redux')){
		require(WELOWE_THEME_DIR . '/includes/options/init.php');
		require_once(WELOWE_THEME_DIR . '/includes/options/opts-general.php'); 
		require_once(WELOWE_THEME_DIR . '/includes/options/opts-footer.php'); 
		require_once(WELOWE_THEME_DIR . '/includes/options/opts-styling.php'); 
		require_once(WELOWE_THEME_DIR . '/includes/options/opts-page.php'); 
		require_once(WELOWE_THEME_DIR . '/includes/options/opts-portfolio.php'); 
		if(class_exists('WooCommerce')){
			require_once(WELOWE_THEME_DIR . '/includes/options/opts-woo.php'); 
		}
	}
	//	Registry menu
	register_nav_menus( array(
		'primary'      => esc_html__( 'Main menu', 'welowe' ),
	));
}

// TGM plugin activation
if (is_admin()) {
	require_once(WELOWE_THEME_DIR . '/includes/tgmpa/class-tgm-plugin-activation.php');
	require(WELOWE_THEME_DIR . '/includes/tgmpa/config.php');
}
load_theme_textdomain('welowe', get_template_directory() . '/languages');

//-------- Register sidebar default in theme -----------
//------------------------------------------------------
function welowe_widgets_init() {
	register_sidebar(array(
		'name' 				=> esc_html__('Default Sidebar', 'welowe'),
		'id' 					=> 'default_sidebar',
		'description' 		=> esc_html__('Appears in the Default Sidebar section of the site.', 'welowe'),
		'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' 	=> '</aside>',
		'before_title' 	=> '<h3 class="widget-title"><span>',
		'after_title' 		=> '</span></h3>',
	));

	if(class_exists('WooCommerce')){
		register_sidebar( array(
			'name' 				=> esc_html__('WooCommerce Shop Sidebar', 'welowe'),
			'id' 					=> 'woocommerce_sidebar',
			'description' 		=> esc_html__('Appears in the Plugin WooCommerce section of the site.', 'welowe'),
			'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
			'after_widget'	 	=> '</aside>',
			'before_title' 	=> '<h3 class="widget-title"><span>',
			'after_title' 		=> '</span></h3>',
		));
	}
	register_sidebar(array(
		'name' 				=> esc_html__('After Offcanvas Mobile', 'welowe'),
		'id' 					=> 'offcanvas_sidebar_mobile',
		'description' 		=> esc_html__('Appears in the Offcanvas section of the site.', 'welowe'),
		'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' 	=> '</aside>',
		'before_title' 	=> '<h3 class="widget-title"><span>',
		'after_title' 		=> '</span></h3>',
	));
	
}
add_action('widgets_init', 'welowe_widgets_init');


function welowe_fonts_url() { 
	$fonts_url = '';
	$fonts     = array();
	$subsets   = '';
	$protocol = is_ssl() ? 'https' : 'http';
	if('off' !== _x('on', 'Inter font: on or off', 'welowe')){
		$fonts[] = 'Inter:wght@300;400;500;600;700;800';
	}
	if('off' !== _x('on', 'Gloria Hallelujah font: on or off', 'welowe')){
		$fonts[] = 'Gloria+Hallelujah:wght@400';
	}
	if($fonts){
		$fonts_url = add_query_arg( array(
			'family' => (implode('&family=', $fonts)),
			'display' => 'swap',
		),  $protocol.'://fonts.googleapis.com/css2');
	}
	return $fonts_url;
}

function welowe_custom_styles() {
	$custom_css = get_option('welowe_theme_custom_styles');
	if($custom_css){
		wp_enqueue_style(
			'welowe-custom-style',
			WELOWE_THEME_URL . '/assets/css/custom_script.css'
		);
		wp_add_inline_style('welowe-custom-style', $custom_css);
	}
}
add_action('wp_enqueue_scripts', 'welowe_custom_styles', 9999);

function welowe_init_scripts(){
	global $post;
	$protocol = is_ssl() ? 'https' : 'http';
	if ( is_singular() && comments_open() && get_option('thread_comments') ){
		wp_enqueue_script('comment-reply');
	}

	$theme = wp_get_theme('welowe');
	$theme_version = $theme['Version'];

	wp_enqueue_style('welowe-fonts', welowe_fonts_url(), array(), null );
	
	wp_enqueue_script('bootstrap', WELOWE_THEME_URL . '/assets/js/bootstrap.min.js', array('jquery') );
	wp_enqueue_script('jquery-magnific-popup', WELOWE_THEME_URL . '/assets/js/magnific/jquery.magnific-popup.min.js');
	wp_enqueue_script('jquery-cookie', WELOWE_THEME_URL . '/assets/js/jquery.cookie.js', array('jquery'));
	wp_enqueue_script('swiper', WELOWE_THEME_URL . '/assets/js/swiper/swiper.min.js');
	wp_enqueue_script('jquery-appear', WELOWE_THEME_URL . '/assets/js/jquery.appear.js');
	wp_enqueue_script('mcustomscrollbar', WELOWE_THEME_URL . '/assets/js/scroll/jquery.mCustomScrollbar.min.js');
	wp_enqueue_script('welowe-main', WELOWE_THEME_URL . '/assets/js/main.js', array('imagesloaded', 'jquery-masonry'));
	
	$register_link = class_exists('WooCommerce') ? wc_get_page_permalink('myaccount') : wp_registration_url();
  	$register_html = esc_html__('New here?', 'welowe');
 	$register_html .= '<a class="text-theme" href="' . esc_url($register_link) . '">&nbsp;' . esc_html__('Create an Account', 'welowe') . '</a>';

	wp_enqueue_style('dashicons');
	wp_enqueue_style('swiper', WELOWE_THEME_URL .'/assets/js/swiper/swiper.min.css');
	wp_enqueue_style('magnific', WELOWE_THEME_URL .'/assets/js/magnific/magnific-popup.css');
	wp_enqueue_style('mcustomscrollbar', WELOWE_THEME_URL . '/assets/js/scroll/jquery.mCustomScrollbar.min.css');
	wp_enqueue_style('fontawesome', WELOWE_THEME_URL . '/assets/css/fontawesome/css/all.min.css');
	wp_enqueue_style('welowe-icons', WELOWE_THEME_URL . '/assets/css/icons/style.css');

	wp_enqueue_style('welowe-style', WELOWE_THEME_URL . '/style.css');
	wp_enqueue_style('bootstrap', WELOWE_THEME_URL . '/assets/css/bootstrap.css', array(), $theme_version , 'all'); 
	wp_enqueue_style('welowe-template', WELOWE_THEME_URL . '/assets/css/template.css', array(), $theme_version , 'all');
	
	//Woocommerce
	if(class_exists('WooCommerce')){
		wp_dequeue_script('wc-add-to-cart');
		wp_enqueue_script('wc-add-to-cart', WELOWE_THEME_URL . '/assets/js/add-to-cart.js' , array('jquery'));
		wp_enqueue_style('welowe-woocoomerce', WELOWE_THEME_URL . '/assets/css/woocommerce.css', array(), $theme_version , 'all'); 
	}

  	wp_localize_script('welowe-main', 'welowe_jquery_object', array( 
		'ajax_url' => admin_url( 'admin-ajax.php'),
		'security_nonce' => wp_create_nonce( "welowe-ajax-security-nonce" )
	));
	
  	if(class_exists('Give')){
		wp_enqueue_style('welowe-givwp', WELOWE_THEME_URL . '/assets/css/givewp.css', array(), $theme_version , 'all');
  	}
} 
add_action('wp_enqueue_scripts', 'welowe_init_scripts', 999);

