<?php
$course_id = get_the_ID();
$thumbnail_size = (isset($image_size) && $image_size) ? $image_size : 'post-thumbnail';
$thumbnail_src = get_tutor_course_thumbnail_src($thumbnail_size);
$course_students = tutor_utils()->count_enrolled_users_by_course();
$tutor_lesson_count = tutor_utils()->get_lesson_count_by_course($course_id);
?>
<div class="item-course">
   <div class="tutor-course tutor-course-loop course-block-3 tutor-course-loop-<?php the_ID() ?>">
      <?php 
         do_action('tutor_course/loop/before_content');

         do_action('tutor_course/loop/badge');

         echo '<div class="course-header">';
            echo '<a class="link-overlay" href="' . get_the_permalink() . '">';
               echo '<img src="' . esc_url($thumbnail_src) . '" alt="' . esc_attr(get_the_title()) . '" />';
            echo'</a>';
            do_action('tutor_course/loop/header');
            
         echo '</div>';

         //==
         do_action('tutor_course/loop/start_content_wrap');

         do_action('tutor_course/loop/before_rating');
         do_action('tutor_course/loop/rating');
         do_action('tutor_course/loop/after_rating');

         do_action('tutor_course/loop/before_meta');
         do_action('tutor_course/loop/meta');
         do_action('tutor_course/loop/after_meta');


         do_action('tutor_course/loop/before_title');
         do_action('tutor_course/loop/title');
         do_action('tutor_course/loop/after_title');

         echo '<div class="course-loop-information">';
            echo '<div class="course-user"><i class="fa fa-user"></i>';
               $stu_text = ($course_students == 1 ? esc_html__('%s Student', 'wellearn') : esc_html__('%s Students', 'wellearn'));
               echo sprintf($stu_text, $course_students);
            echo '</div>';
            if($tutor_lesson_count) {
               echo '<div class="course-lesson-count"><i class="far fa-folder-open"></i>';
                  echo sprintf(esc_html__('%s Lessons', 'wellearn'), $tutor_lesson_count);
               echo '</div>';
            }
         echo '</div>';   

         do_action('tutor_course/loop/before_footer');
         do_action('tutor_course/loop/footer');
         do_action('tutor_course/loop/after_footer');
         
         do_action('tutor_course/loop/end_content_wrap');
         //==

         do_action('tutor_course/loop/after_content');
      ?>
   </div>
</div>      