<?php

/**
 * Template for displaying courses
 *
 * @since v.1.0.0
 *
 * @author Themeum
 * @url https://themeum.com
 *
 * @package TutorLMS/Templates
 * @version 1.5.8
 */

get_header();

$course_filter = (bool) tutor_utils()->get_option('course_archive_filter', false);
$supported_filters = tutor_utils()->get_option('supported_course_filters', array());
$layout = wellearn_get_option('course_filter_layout', 'filter-layout-top');
if( $layout == 'filter-layout-left'){
   $layout = 'course-filter-sidebar filter-layout-left';
}else if($layout == 'filter-layout-right'){
   $layout = 'course-filter-sidebar filter-layout-right';
}
?>

	<section id="wp-main-content" class="clearfix main-page title-layout-standard">
		<?php do_action( 'wellearn_before_page_content' ); ?>
			<div class="container">	
		   	<div class="main-page-content course-archive">
		      	<div class="row">

			      	<!-- Main content -->
			      	<div class="content-page col-12">      
			  			  	<div id="wp-content" class="wp-content">
			  			  		<div class="el-course-filter <?php echo esc_attr($layout) ?>">
									<?php tutor_load_template('archive-course-init'); ?>
								</div>		
							</div>	
						</div>	

					</div>	
				</div>
			</div>				
		<?php do_action( 'wellearn_after_page_content' ); ?>
	</section>

<?php get_footer(); ?>