<?php 
   global $post;

   $thumbnail = (isset($thumbnail_size) && $thumbnail_size) ? $thumbnail_size : 'post-thumbnail';
   $excerpt_words = (isset($excerpt_words) && $excerpt_words) ? $excerpt_words : '0';

   $desc = wellearn_limit_words($excerpt_words, get_the_excerpt(), '');

   $meta_classes = 'post-three__meta';
   if(empty(get_the_date())){
      $meta_classes = 'post-three__meta schedule-date';
   }
   $content_classes = 'post-three__content';
   $thumbnail_check = has_post_thumbnail() ? ' has-thumbnail' : ' has-no-thumbnail';
   $content_classes .= $thumbnail_check;
?>

<article <?php post_class('post post-three__single'); ?>>
      <?php 
         if(has_post_thumbnail()){
            echo '<div class="post-three__thumbnail">';
               echo '<a href="' . esc_url( get_permalink() ) . '">';
                  the_post_thumbnail( $thumbnail, array( 'alt' => get_the_title() ) );
               echo '</a>';
               
            echo '</div>';
         }
         if( get_the_date() ){
            echo '<div class="post-three__entry-date"><div class="created">';
               echo '<span class="month">' . esc_html( get_the_date('M')) . '</span>';
               echo '<span class="date">' . esc_html( get_the_date('d')) . '</span>';
            echo '</div></div>';
         } 
      ?>
      
      <div class="<?php echo esc_attr($content_classes) ?>">
         <div class="<?php echo esc_attr($meta_classes) ?>">
            <?php wellearn_posted_on(); ?>
         </div> 
         <h3 class="post-three__title"><a href="<?php echo esc_url( get_permalink() ) ?>" rel="bookmark"><?php the_title() ?></a></h3>         
         <div class="post-three__action">
            <a class="btn-inline-theme-2" href="<?php echo esc_url( get_permalink() ) ?>"><span><?php echo esc_html__('READ MORE', 'wellearn'); ?></span></a>
         </div>
      </div>
   </article>   

  