<?php
add_filter('tutor_course_loop_wrap_classes', 'wellearn_course_loop_wrap_classes');
function wellearn_course_loop_wrap_classes($classes){
   $classes[] = 'course-block';
   return $classes;
}

add_filter( 'body_class', 'wellearn_tutor_class_names' );
function wellearn_tutor_class_names( $classes ) {
   global $current_user;
   $user_roles = $current_user->roles;
   $classes[] = $user_roles && is_array($user_roles) ? implode(' ', $user_roles) : '';
   $page_id = wellearn_id();
   $register_student_page_id = (int) tutor_utils()->get_option( 'student_register_page' );
   $register_instructor_page_id = (int) tutor_utils()->get_option( 'instructor_register_page' );
   ($register_student_page_id == $page_id || $register_instructor_page_id == $page_id) ? $classes[] = 'z-register-page' : false;
   return $classes;
}
add_action("tutor_course/settings_tab_content/after/general", 'wellearn_settings_tab_text_field', 9);

function wellearn_settings_tab_text_field($tab){
      $course_id = get_the_ID();
      $language_val = tutor_utils()->get_course_settings($course_id, 'language', __('English', 'wellearn'));
      echo '<div class="tutor-row tutor-mb-32">';
         echo '<div class="tutor-col-12 tutor-col-md-5">';
            echo '<label class="tutor-course-setting-label">' . esc_html__('Language', 'wellearn') . '</label>';
         echo '</div>';
         echo '<div class="tutor-col-12 tutor-col-md-7">';
            echo '<input style="max-width:126px !important;" class="tutor-form-control" type="text" name="_tutor_course_settings[language]" value="' . $language_val . '" >';
         echo '</div>';   
      echo '</div>';   

      $certificate_val = tutor_utils()->get_course_settings($course_id, 'certificate', __('Yes', 'wellearn'));
      echo '<div class="tutor-row tutor-mb-32">';
         echo '<div class="tutor-col-12 tutor-col-md-5">';
            echo '<label class="tutor-course-setting-label">' . esc_html__('Certificate', 'wellearn') . '</label>';
         echo '</div>';
         echo '<div class="tutor-col-12 tutor-col-md-7">';
            echo '<input style="max-width:126px !important;" class="tutor-form-control" type="text" name="_tutor_course_settings[certificate]" value="' . $certificate_val . '" >';
         echo '</div>';   
      echo '</div>';   
      }

add_filter('tutor_course_settings_tabs', 'wellearn_course_settings_tabs');

function wellearn_course_settings_tabs($args){
   $course_id = get_the_ID();

   $fields = array(
      '_tutor_course_settings[single_layout]' => array(
         'type'      => 'select',
         'label'     => esc_html__('Single Layout', 'wellearn'),
         'label_title'=> __('Enable', 'wellearn'),
         'options'   => array(
            'layout-1' => esc_html__('Layout 01', 'wellearn' ),
            'layout-2' => esc_html__('Layout 02', 'wellearn' ),
            'layout-3' => esc_html__('Layout 03', 'wellearn' ),
            'layout-4' => esc_html__('Layout 04', 'wellearn' )
         ), 
         'value'  =>  tutor_utils()->get_course_settings($course_id, 'single_layout', 'layout-1')
      )
   );

   $fields_array = apply_filters('wellearn_tutor_course_settings', $fields);

   $args['single_course_layout'] = array(
      'label'        => esc_html__('Layout Settings', 'wellearn'),
      'icon_class'   => ' tutor-icon-settings-1',
      'fields'       => $fields_array
   );

   return $args;
}


add_action( 'woocommerce_product_query', 'wellearn_woocommerce_pre_get_posts_query' );
function wellearn_woocommerce_pre_get_posts_query( $query ) {
   if( is_shop() || is_page('shop') ) { 
      $meta_query = (array) $query->get( 'meta_query' );
      $meta_query['relation'] = 'OR';
      $meta_query[] = array(
         'key' => '_tutor_product',
         'compare' => 'NOT EXISTS'
      );
      $meta_query[] = array(
         'key' => '_tutor_product',
         'value'    => 'yes',
         'compare' => '!='
      );
      
      $query->set( 'meta_query', $meta_query );
      return $query;
   }
}

add_filter('nsl_get_template_part', 'wellearn_nsl_style');

function wellearn_nsl_style($templates){
   $templates = \array_diff($templates, ['style.css']);
   return $templates;
}

do_action('get_template_part_style.css', 'wellearn_disable_style');
function wellearn_disable_style(){
   return false;
}

add_action('tutor_lesson_edit_modal_form_after', 'wellearn_lesson_access_metabox');
function wellearn_lesson_access_metabox($post){
   $lesson_access = get_post_meta($post->ID, '_lesson_access', true);
   ?>
   <div class="tutor-option-field-row">
    <div class="tutor-option-field-label">
        <label for=""><?php esc_html__('Select Lesson Access', 'wellearn'); ?></label>
    </div>
    <div class="tutor-option-field">
        <select name="_lesson_access">
            <option value="lesson_access_enroll" <?php if($lesson_access == 'lesson_access_enroll'){echo esc_attr('selected');} ?>>
               <?php echo esc_html__('Enroll', 'wellearn'); ?>
            </option>
            <option value="lesson_access_free" <?php if($lesson_access == 'lesson_access_free'){echo esc_attr('selected');} ?>>
               <?php echo esc_html__('Free', 'wellearn'); ?>
            </option>
        </select>
    </div>
</div>
<?php
}

add_action('save_post_'. tutor()->lesson_post_type, 'wellearn_save_lesson_meta');
function wellearn_save_lesson_meta($post_ID){
   if (isset($_POST['_lesson_access'])) {
      update_post_meta( $post_ID, '_lesson_access', $_POST['_lesson_access'] );
   }
}

add_filter( 'template_include', 'wellearn_tutor_load_single_lesson_template', 99 );
 function wellearn_tutor_load_single_lesson_template($template){
      global $wp_query;
      
      if ($wp_query->is_single && ! empty($wp_query->query_vars['post_type']) && $wp_query->query_vars['post_type'] === tutor()->lesson_post_type){
         $page_id = get_the_ID();
         $lesson_access = get_post_meta($page_id, '_lesson_access', true);
         
         do_action('tutor_lesson_load_before', $template);

         setup_postdata($page_id);

         if (is_user_logged_in()) {
            $has_content_access = tutils()->has_enrolled_content_access('lesson');
            if ($has_content_access) {
               $template = tutor_get_template('single-lesson');
            } else {
               $template = tutor_get_template('single.lesson.required-enroll'); //You need to enroll first
            }
         }else{
            if($lesson_access == 'lesson_access_free'){
               $template = tutor_get_template('single-lesson');
            }else{
               $template = tutor_get_template('login');
            }
         }
         wp_reset_postdata();

         // Forcefully show lessons if it is public and not paid
         $ancestors = get_post_ancestors($page_id);
         $root = is_array($ancestors) ? end($ancestors) : null;
         $course_id = is_numeric($root) ? $root : $id;

         if(get_post_meta($course_id, '_tutor_is_public_course', true)=='yes' && !tutor_utils()->is_course_purchasable($course_id)){
            $template = tutor_get_template( 'single-lesson' );
         }
         
         return apply_filters('tutor_lesson_template', $template);
      }
      return $template;
   }

