<?php
add_theme_support( 'wp-block-styles' );

function wellearn_style_breadcrumb(){
	global $post;
	$post_id = wellearn_id();
	$result['title'] = '';
	$result['styles'] = '';
	$result['styles_overlay'] = '';
	$result['classes'] = '';

	$show_no_breadcrumbs = wellearn_get_option('enable_breadcrumb', 'enable') == 'disable' ? true : false;
	if (metadata_exists('post', $post_id, 'wellearn_no_breadcrumbs')){
		if(get_post_meta($post_id, 'wellearn_no_breadcrumbs', true) == true){
			$show_no_breadcrumbs = true;
		}
	}
	$breadcrumb_padding_top = wellearn_get_option('breadcrumb_padding_top', '');
	$breadcrumb_padding_bottom = wellearn_get_option('breadcrumb_padding_bottom', '');
	$breadcrumb_show_title = wellearn_get_option('breadcrumb_show_title', '1');
	$breadcrumb_bg_color = wellearn_get_option('breadcrumb_background_color', '1');;
	$breadcrumb_bg_color_opacity = wellearn_get_option('breadcrumb_background_opacity', '1');
	$breadcrumb_enable_image = wellearn_get_option('breadcrumb_image', '1');
	$breadcrumb_image = wellearn_get_option('breadcrumb_bg_image', array('id'=> 0));
	$breadcrumb_text_style = wellearn_get_option('breadcrumb_text_stype', 'text-light');
	$breadcrumb_text_align = wellearn_get_option('breadcrumb_text_align', 'text-left');
	$breadcrumb_page_title_one = '';

	if(get_post_meta($post_id, 'wellearn_breadcrumb_layout', true) == 'page_options'){
		$breadcrumb_padding_top = get_post_meta($post_id, 'wellearn_breadcrumb_padding_top', true);
		$breadcrumb_padding_bottom = get_post_meta($post_id, 'wellearn_breadcrumb_padding_bottom', true);
		$breadcrumb_show_title = get_post_meta($post_id, 'wellearn_page_title', true);
		$breadcrumb_bg_color = get_post_meta($post_id, 'wellearn_bg_color_title', true);
		$breadcrumb_bg_color_opacity = get_post_meta($post_id, 'wellearn_bg_opacity_title', true);
		$breadcrumb_enable_image = get_post_meta($post_id, 'wellearn_image_breadcrumbs', true);
		$breadcrumb_image = get_post_meta($post_id, 'wellearn_page_title_image', true);
		$breadcrumb_text_style = get_post_meta($post_id, 'wellearn_page_title_text_style', true);
		$breadcrumb_text_align = get_post_meta($post_id, 'wellearn_page_title_text_align', true);
		$breadcrumb_page_title_one = get_post_meta($post_id, 'wellearn_page_title_one', true);

		$breadcrumb_image = !empty($breadcrumb_image) ? $breadcrumb_image : wellearn_get_option('breadcrumb_bg_image', array('id'=> 0));
	}
	if ( metadata_exists( 'post', $post_id, 'wellearn_page_title' ) || is_archive()) {
		$breadcrumb_show_title = true;
	}

	//Breadcrumb category and tag products
	if(class_exists('WooCommerce') && (is_product_tag() || is_product_category() || is_product()) ){
		$breadcrumb_padding_top = wellearn_get_option('woo_breadcrumb_padding_top', '');
		$breadcrumb_padding_bottom = wellearn_get_option('woo_breadcrumb_padding_bottom', '');
		$breadcrumb_show_title = wellearn_get_option('woo_breadcrumb_show_title', '1');
		$breadcrumb_bg_color = wellearn_get_option('woo_breadcrumb_background_color', '1');;
		$breadcrumb_bg_color_opacity = wellearn_get_option('woo_breadcrumb_background_opacity', '1');
		$breadcrumb_image = wellearn_get_option('woo_breadcrumb_bg_image', array('id'=> 0));
		$breadcrumb_text_style = wellearn_get_option('woo_breadcrumb_text_stype', 'text-light');
		$breadcrumb_text_align = wellearn_get_option('woo_breadcrumb_text_align', 'text-left');
	}

	$result = array();
	$styles = array();
	$styles_inner = array();
	$styles_overlay = '';
	$classes = array();
	$title = '';
	if($show_no_breadcrumbs){
		$result['no_breadcrumbs'] = true;
	}
	if(!isset($breadcrumb_show_title) || empty($breadcrumb_show_title) || $breadcrumb_show_title){
		$title = get_the_title();
		if(is_archive()) $title = single_cat_title('', false);
		if(class_exists('WooCommerce') && is_shop()){
			$title = woocommerce_page_title(false);
		}
  }
  
	if(is_home()) { // Home Index
		$breadcrumb_show_title = true;
		$title = esc_html__( 'Latest posts', 'wellearn' );
		$breadcrumb_text_align = 'text-left';
		$breadcrumb_text_style = 'text-light';
		$breadcrumb_enable_image = wellearn_get_option('breadcrumb_image', false);
	}

	if($breadcrumb_bg_color){
		$rgba_color = wellearn_convert_hextorgb($breadcrumb_bg_color);
		$styles_overlay = 'background-color: rgba(' . esc_attr($rgba_color['r']) . ',' . esc_attr($rgba_color['g']) . ',' . esc_attr($rgba_color['b']) . ', ' . ($breadcrumb_bg_color_opacity/100) . ')';
	}

	//Tmp
	$breadcrumb_text_style = 'text-light';
	//Classes
	$classes[] = $breadcrumb_text_style;
	$classes[] = $breadcrumb_text_align;
  
	if($breadcrumb_enable_image){
		$image_background_breadcrumb = '';

		if($breadcrumb_image){

			if(is_array($breadcrumb_image)){
			if(isset($breadcrumb_image['id']) && $breadcrumb_image['id']){
				$image = wp_get_attachment_image_src( $breadcrumb_image['id'], 'full');
				if(isset($image[0]) && $image[0]){
					$image_background_breadcrumb = esc_url($image[0]);
				}
			}
			}else{
			if(is_numeric($breadcrumb_image)){
					$image = wp_get_attachment_image_src( $breadcrumb_image, 'full');
					if(isset($image[0]) && $image[0]){
						$image_background_breadcrumb = esc_url($image[0]);
					}
				}else{
					$image_background_breadcrumb = $breadcrumb_image;
				}
			}
		}
		if($image_background_breadcrumb) {
			$styles[] = 'background-image: url(\'' . $image_background_breadcrumb . '\')';
		}
	}

	if(is_single() && empty($breadcrumb_page_title_one)){
		$title = get_the_title();
	}

	if($breadcrumb_padding_top){
		$styles_inner[] = "padding-top:{$breadcrumb_padding_top}px";
	}
	if($breadcrumb_padding_bottom){
		$styles_inner[] = "padding-bottom:{$breadcrumb_padding_bottom}px";
	}

 
	if(is_search()){
		$title = esc_html__('Search', 'wellearn');
	}

	if( empty($title) && is_archive() ){
		$title = get_the_archive_title();
	}

	if($breadcrumb_page_title_one){
		$title = $breadcrumb_page_title_one;
	}  

	$result['title'] = $title;
	$result['styles'] = $styles;
	$result['styles_inner'] = $styles_inner;
	$result['styles_overlay'] = $styles_overlay;
	$result['classes'] = $classes;
	$result['show_page_title'] = $breadcrumb_show_title;
	return $result;
}

function wellearn_breadcrumb(){
	$result = wellearn_style_breadcrumb();
	extract($result);
	if(isset($no_breadcrumbs) && $no_breadcrumbs == true){
	 echo '<div class="disable-breadcrumb clearfix"></div>';
	 return false;
	}
	 $image_breadcumb_standard = wellearn_get_option('image_breadcumb_standard', 'show-bg');
	 $classes[] = $image_breadcumb_standard;
	?>
	
	<div class="custom-breadcrumb <?php echo implode(' ', $classes); ?>" <?php echo(count($styles) > 0 ? 'style="' . implode(';', $styles) . '"' : ''); ?>>
		<?php if($styles_overlay){ ?>
			<div class="breadcrumb-overlay" style="<?php echo esc_attr($styles_overlay); ?>"></div>
		<?php } ?>
		<div class="breadcrumb-main">
		  <div class="container">
			 <div class="breadcrumb-container-inner" <?php echo(count($styles_inner) > 0 ? 'style="' . implode(';', $styles_inner) . '"' : ''); ?>>
				<?php if($title && $show_page_title){ 
				  echo '<h2 class="heading-title">' . html_entity_decode( $title ) . '</h2>';
				} ?>
				<?php wellearn_general_breadcrumbs(); ?>
			 </div>  
		  </div>   
		</div>  
	</div>
	<?php
}

add_action( 'wellearn_before_page_content', 'wellearn_breadcrumb', '10' );

/**
 * Hook to select footer of page
 */
function wellearn_get_footer_layout(){
	
	if(!class_exists('GVA_Layout_Frontend')){
		return false;
	}

	$post_id = false;
	if(class_exists('WooCommerce') && is_shop()){
		$post_id = wc_get_page_id('shop');
	}else{
		$post = get_post();
		if( $post && isset($post->ID) && $post->ID ){
			$post_id = $post->ID;
		}
	}

	$frontend = new GVA_Layout_Frontend();
	if(get_post_type($post_id) == 'page'){
		$footer_id = get_post_meta($post_id, 'wellearn_footer_layout', true);
		if(empty($footer_id) || $footer_id == '_default_active'){
			$footer_id = $frontend->get_template_default('footer_layout');
		}
		return $footer_id;
	}

	$frontend = new GVA_Layout_Frontend();
	$template_id = $frontend->template_default_active_id();

	$post_meta_template = get_post_meta($post_id, 'wellearn_template_layout', true);
	if( !empty($post_meta_template) && $post_meta_template != '_default_active' && $post_meta_template != '_without_layout' && is_numeric($post_meta_template) ){
		$template_id = $post_meta_template;
	}

	$footer_id = 0;
	if($template_id){
		$footer_id = get_post_meta($template_id, 'footer_layout', true);
	}

	if(!$footer_id){
		$footer_id = $frontend->template_default_active_id('footer_layout');
	}

	return $footer_id;
} 
add_filter( 'wellearn_get_footer_layout', 'wellearn_get_footer_layout' );
 
/**
 * Hook to select header of page
 */
function wellearn_get_header_layout(){
	if(!class_exists('GVA_Layout_Frontend')){
		return false;
	}
	$post_id = false;

	if(class_exists('WooCommerce') && is_shop()){
		$post_id = wc_get_page_id('shop');
	}else{
		$post = get_post();
		if( $post && isset($post->ID) && $post->ID ){
			$post_id = $post->ID;
		}
	}

	$frontend = new GVA_Layout_Frontend();
	if(get_post_type($post_id) == 'page'){
		$header_id = get_post_meta($post_id, 'wellearn_header_layout', true);
		if(empty($header_id) || $header_id == '_default_active'){
			$header_id = $frontend->get_template_default('header_layout');
		}
		return $header_id;
	}
	
	$template_id = $frontend->template_default_active_id();
	$post_meta_template = get_post_meta($post_id, 'wellearn_template_layout', true);

	if( !empty($post_meta_template) && $post_meta_template != '_default_active' && is_numeric($post_meta_template) ){
		$template_id = $post_meta_template;
	}

	$header_id = 0;
	if($template_id){
		$header_id = get_post_meta($template_id, 'header_layout', true);
	}

	if(!$header_id){
		$header_id = $frontend->template_default_active_id('header_layout');
	}
	
	return $header_id;
} 
add_filter( 'wellearn_get_header_layout', 'wellearn_get_header_layout' );

function wellearn_main_menu(){
	if(has_nav_menu( 'primary' )){
		$wellearn_menu = array(
			'theme_location'    => 'primary',
			'container'         => 'div',
			'container_class'   => 'navbar-collapse',
			'container_id'      => 'gva-main-menu',
			'menu_class'        => ' gva-nav-menu gva-main-menu',
			'walker'            => new Wellearn_Walker()
		);
		wp_nav_menu($wellearn_menu);
	}  
}
add_action( 'wellearn_main_menu', 'wellearn_main_menu', 10 );
 
function wellearn_mobile_menu(){
	if(has_nav_menu( 'primary' )){
		$wellearn_menu = array(
			'theme_location'    => 'primary',
			'container'         => 'div',
			'container_class'   => 'navbar-collapse',
			'container_id'      => 'gva-mobile-menu',
			'menu_class'        => 'gva-nav-menu gva-mobile-menu',
			'walker'            => new Wellearn_Walker()
		);
		wp_nav_menu($wellearn_menu);
	}  
}
add_action( 'wellearn_mobile_menu', 'wellearn_mobile_menu', 10 );

function wellearn_header_mobile(){
	get_template_part('templates/parts/header', 'mobile');
}
add_action('wellearn_header_mobile', 'wellearn_header_mobile', 10);

function wellearn_offcanvas_mobile(){
	get_template_part('templates/parts/canvas-mobile', 'mobile');
}
add_action('wellearn_offcanvas_mobile', 'wellearn_offcanvas_mobile', 10);

add_filter('gavias-elements/map-api', 'wellearn_googlemap_api');
function wellearn_googlemap_api( $key = '' ){
   return wellearn_get_option('map_api_key', '');
}

add_filter('gavias-post-type/slug-portfolio', 'wellearn_slug_portfolio');
function wellearn_slug_portfolio( $key = '' ){
	return wellearn_get_option('slug_portfolio', '');
}

function wellearn_setup_admin_setting(){
  	global $pagenow; 
  	if ( is_admin() && isset($_GET['activated'] ) && $pagenow == 'themes.php' ) {
	 	update_option( 'thumbnail_size_w', 175 );  
	 	update_option( 'thumbnail_size_h', 175 );  
	 	update_option( 'thumbnail_crop', 1 );  
	 	update_option( 'medium_size_w', 600 );  
	 	update_option( 'medium_size_h', 540 ); 
	 	update_option( 'medium_crop', 1 );  
  }
}
add_action( 'init', 'wellearn_setup_admin_setting'  );

function wellearn_page_class_names($classes) {
	$post_id = wellearn_id();
 	$class_el = get_post_meta($post_id, 'wellearn_extra_page_class', true);
 	if($class_el) $classes[] = $class_el;
 	$classes[] = 'wellearn-body-loading';
 	return $classes;
}
add_filter( 'body_class', 'wellearn_page_class_names' );

function wellearn_post_classes($classes, $class, $post_id){
   if(is_single($post_id)){
    	$classes[] = 'post-single-content';
   }
   return $classes;
}
add_filter( 'post_class', 'wellearn_post_classes', 10, 3 );
