<?php
// Get links Ajax
function ulc_not_empty_string($s) {
  return $s !== "";
}

add_action('wp_ajax_ulc_get_links_list', 'ulc_ajax_ulc_get_links_list');
add_action('wp_ajax_nopriv_ulc_get_links_list', 'ulc_ajax_ulc_get_links_list');

function ulc_ajax_links_links_loop_args_get() {
    $links_loop_args_get = array(
        'post_type' => !empty($_GET['post_type']) ? $_GET['post_type'] : 'ulc-link',
        'category_id' => !empty($_GET['category_id']) ? $_GET['category_id'] : '*',
        'per_page' => !empty($_GET['per_page']) ? $_GET['per_page'] : 10,
        'order_by' => !empty($_GET['order_by']) ? $_GET['order_by'] : 'title',
        'order' => !empty($_GET['order']) ? $_GET['order'] : 'ASC',
        'page' => !empty($_GET['page']) ? $_GET['page'] : 1,
        'is_likes' => !empty($_GET['is_likes']) ? $_GET['is_likes'] : false,
        'is_likes_count' => !empty($_GET['is_likes_count']) ? $_GET['is_likes_count'] : false
    );

    return $links_loop_args_get;
}

function ulc_ajax_links_links_loop_args_base($links_loop_args_get, $tax_id = null) {
    $links_loop_args_base = array(
        'post_type' => $links_loop_args_get['post_type'],
        'post_status' => 'publish',
        'posts_per_page' => $links_loop_args_get['per_page'],
        'paged' => $links_loop_args_get['page'],
        'tax_query' => array(
            array(
                'taxonomy' => 'ulc-link-type',
                'field' => 'term_id',
                'terms' => isset($tax_id) ? $tax_id : $links_loop_args_get['category_id'],
            ),
        ),
    );

    return $links_loop_args_base;
}

function ulc_ajax_links_loop_args_order($args, $get) {
    $prefix_link = '_ulc_link';
    if ($get['order_by'] === 'clicks' || $get['order_by'] === 'likes') {
        $meta_key = $prefix_link . '_stats_' . $get['order_by'];
        $args_order = array(
            'meta_key' => $meta_key,
            'orderby'  => 'meta_value_num',
        );
    } else {
        $args_order = array(
            'orderby' => $get['order_by'],
            'order'   => $get['order']
        );
    }

    $links_loop_args = array_merge($args, $args_order);
    return $links_loop_args;    
}

function ulc_ajax_ulc_get_links_list() {
    check_ajax_referer('ulc-ajax-token', 'token');
    $lists = array();

    $per_page = intval($_GET['per_page']);
    if (intval($per_page) === -1) {
        $per_page = -1;
    }
    $prefix = '_ulc_';

    $taxs = array_filter(explode(';', $_GET['category_id']), 'ulc_not_empty_string');

    // Get taxonomy list
    foreach ($taxs as $taxonomy) {

        $ret = array();

        $tax_id = intval($taxonomy);

        $prefix_link = '_ulc_link';
        $links_loop_args_get = ulc_ajax_links_links_loop_args_get();
        $links_loop_args_base = ulc_ajax_links_links_loop_args_base($links_loop_args_get, $tax_id);
        $links_loop_args = ulc_ajax_links_loop_args_order($links_loop_args_base, $links_loop_args_get);
        $links_loop = new WP_Query($links_loop_args);

        if ($links_loop) {

            $ret['links'] = ulc_ajax_links_loop_query($links_loop);

            if ($links_loop->max_num_pages > 1) {
                $is_pagination = true;
                $ret['options'] = array(
                    'page' => $links_loop_args_get['page'],
                    'is_pagination' => $is_pagination,
                    'max-pages' => $links_loop->max_num_pages,
                );
            } else {
                $is_pagination = false;
                $ret['options'] = array(
                    'page' => $links_loop_args_get['page'],
                    'is_pagination' => $is_pagination,
                );
            }

            if ($links_loop_args_get['is_likes'] != false) {
                $ret['options']['is_likes'] = $links_loop_args_get['is_likes'];
            }

            if ($links_loop_args_get['is_likes'] != false && $links_loop_args_get['is_likes_count'] != false) {
                $ret['options']['is_likes_count'] = $links_loop_args_get['is_likes_count'];
            }

            if (!empty($ret)) {
                $prefix_link_taxonomy = 'ulc_link_type_';
                $term = get_term_by('term_id', $tax_id, 'ulc-link-type');

                $image = wp_get_attachment_image_src( get_term_meta( $tax_id, $prefix_link_taxonomy . 'logo_img_id', true , 'ulc-thumbnail'), 'ulc-thumbnail' );
                $image_link = false;

                $img_tax_type = get_term_meta($tax_id, $prefix_link_taxonomy . 'img_type', true);
                if (!empty($image[0]) && $img_tax_type === 'image') {
                    $image_link = $image[0];
                }
                $lists['lists'][] = array(
                    'id' => $tax_id,
                    'links' => $ret['links'],
                    'options' => $ret['options'],
                    'logo_img' => $image_link,
                    '$img_tax_type' => $img_tax_type,
                    'icon' => get_term_meta($tax_id, $prefix_link_taxonomy . 'icon', true),
                    'icon_color' => get_term_meta($tax_id, $prefix_link_taxonomy . 'icon_color', true),
                    'bg_icon' => get_term_meta($tax_id, $prefix_link_taxonomy . 'bg_icon', true),
                    'title' => $term->name,
                    'post_count' => $term->count,
                    'slug' => $term->slug,
                    'id' => $tax_id
                );

            }

            wp_reset_query();
        }

    }
    wp_reset_postdata();

    echo json_encode($lists);
    die;

}

?>