<?php
// Get links Ajax
add_action('wp_ajax_ulc_get_links', 'ulc_ajax_ulc_get_links');
add_action('wp_ajax_nopriv_ulc_get_links', 'ulc_ajax_ulc_get_links');

function ulc_ajax_links_loop_query_item($id, $is_safe_reidrect_disabled = false) {
    $prefix_link = '_ulc_link';
    $img_link = false;
    $safe_url = esc_url( home_url('/') . '?ulc_safe_link=' . $id );
    $url = get_post_meta( $id, $prefix_link . 'url', true );
    $image = wp_get_attachment_image_src(get_post_meta($id, $prefix_link . 'logo_img_id', true, 'ulc-thumbnail'), 'ulc-thumbnail');
    $img_type = get_post_meta( $id, $prefix_link . '_img_type', true );
    if ($img_type === 'favicon') {
        $img_favicon_url = get_post_meta($id, $prefix_link . '_img_favicon_url', true);
        if (!empty($img_favicon_url)) {
            $img_link = $img_favicon_url;
        } else {
            $url = preg_replace('#^https?://#', '', rtrim($url,'/'));
            $img_link = esc_url( $_SERVER['REQUEST_SCHEME'] . '://favicon.yandex.net/favicon/'. $url);
        }
    } elseif (!empty($image[0]) || $img_type === 'image') {
        $img_link = !empty($image[0]) ? $image[0] : false;
    }

    $item = array(
        'id' => $id,
        'title' => get_the_title($id),
        'logo_img' => $img_link,
        'icon' => get_post_meta( $id, $prefix_link . 'icon', true ),
        'icon_color' => get_post_meta( $id, $prefix_link . 'icon_color', true ),
        'bg_icon' => get_post_meta( $id, $prefix_link . 'bg_icon', true ),
        'description' => get_post_meta($id, $prefix_link . 'short_descr', true),
        'img_type' => $img_type,
        'bg_color' => $url,
        'url' => $url,
        'url_safe' => $is_safe_reidrect_disabled ? $url : $safe_url,
        'is_new_tab' => get_post_meta($id, $prefix_link . 'is_new_tab', true),
        'is_nofollow' => get_post_meta($id, $prefix_link . 'is_nofollow', true),
        'likes_count' => get_post_meta($id, $prefix_link . '_stats_likes', true)
    );

    return $item;
}

function ulc_ajax_links_loop_query($links_loop, $is_safe_reidrect_disabled = false) {
    $links = array();

    $options = get_option('ulc_settings');
    $is_safe_reidrect_disabled = isset($options) && isset($options['ulc_field_safe_redirect_disabled']) && $options['ulc_field_safe_redirect_disabled'] === '1' ? true : false;

    if($links_loop) {

      while ($links_loop->have_posts()) {

          $links_loop->the_post();

          $id = get_the_ID();

          $links[] = ulc_ajax_links_loop_query_item($id, $is_safe_reidrect_disabled);
      }
    }
    return $links;
}

function ulc_ajax_ulc_get_links() {
    check_ajax_referer('ulc-ajax-token', 'token');
    $ret = array();

    $per_page = intval($_GET['per_page']);
    if(intval($per_page) === -1) {
        $per_page = -1;
    }

    $prefix = '_ulc_';
    $links_loop_args_get = ulc_ajax_links_links_loop_args_get();
    $links_loop_args_base = ulc_ajax_links_links_loop_args_base($links_loop_args_get, null);
    $links_loop_args = ulc_ajax_links_loop_args_order($links_loop_args_base, $links_loop_args_get);
    $links_loop = new WP_Query($links_loop_args);

    if($links_loop) {

      $ret['links'] = ulc_ajax_links_loop_query($links_loop);

      if($links_loop->max_num_pages > 1) {

          // Generate pagination list
          for ($i = 1; $i <= $links_loop->max_num_pages; $i++) {
              $pagination[] = array('index' => $i);
          }
          $is_pagination = true;

          $ret['options'] = array(
              'page' => $links_loop_args_get['page'],
              'pagination'  => $pagination,
              'is_pagination' => $is_pagination
          );
      } else {
          $is_pagination = false;
          $ret['options'] = array(
              'is_pagination' => $is_pagination
          );
      }

      if ($links_loop_args_get['is_likes'] != false) {
          $ret['options']['is_likes'] = $links_loop_args_get['is_likes'];
      }

      if ($links_loop_args_get['is_likes'] != false && $links_loop_args_get['is_likes_count'] != false) {
          $ret['options']['is_likes_count'] = $links_loop_args_get['is_likes_count'];
      }

      wp_reset_postdata();
      wp_reset_query();

    }

    echo json_encode($ret);
    die;

}


// Track click
add_action('wp_ajax_ulc_track_click', 'ulc_ajax_link_track_click');
add_action('wp_ajax_nopriv_ulc_track_click', 'ulc_ajax_link_track_click');

function ulc_ajax_link_track_click() {
  check_ajax_referer('ulc-ajax-token', 'token');
  if(!empty($_POST['post_id'])) {
    $link_clicks = intval(get_post_meta( $_POST['post_id'], '_ulc_link_stats_clicks', true ));
    $link_clicks++;

    update_post_meta( $_POST['post_id'], '_ulc_link_stats_clicks', $link_clicks );
  }

  $response = array('Success' => true);
  echo json_encode($response);
  die();
}


// Track click
add_action('wp_ajax_ulc_like_click', 'ulc_ajax_link_like_click');
add_action('wp_ajax_nopriv_ulc_like_click', 'ulc_ajax_link_like_click');

function ulc_ajax_link_like_click() {
  check_ajax_referer('ulc-ajax-token', 'token');
  if(!empty($_POST['post_id'])) {
    $link_clicks = intval(get_post_meta( $_POST['post_id'], '_ulc_link_stats_likes', true ));
    $link_clicks++;

    update_post_meta( $_POST['post_id'], '_ulc_link_stats_likes', $link_clicks );
  }

  $response = array('Success' => true);
  echo json_encode($response);
  die();
}

?>